// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBrowserComponentsMetrics_h
#define mozilla_GleanBrowserComponentsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace background_update {
  /**
   * generated from background_update.reasons_to_not_update
   * Records which error was causing the background updater to fail. This list supercedes the `background-update.reason` in `mozapps/update/metrics.yaml`
   */
  constexpr impl::StringListMetric reasons_to_not_update(368);

  /**
   * generated from background_update.time_last_update_scheduled
   * Last time the background update was triggered.
   */
  constexpr impl::DatetimeMetric time_last_update_scheduled(369);
}

namespace browser {
  /**
   * generated from browser.attribution_errors
   */
  enum class AttributionErrorsLabel: uint16_t {
    eReadError = 0,
    eDecodeError = 1,
    eWriteError = 2,
    eQuarantineError = 3,
    eEmptyError = 4,
    eNullError = 5,
    e__Other__,
  };
  /**
   * Count for the number of errors encountered trying to determine attribution data: on Windows, from the installers (stub and full); on macOS, from an extended attributed on the .app bundle.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_ATTRIBUTION_ERRORS.
   */
  constexpr impl::Labeled<impl::CounterMetric, AttributionErrorsLabel> attribution_errors(384);

  /**
   * generated from browser.default_at_launch
   * Whether the shell service identified this app as the default browser.
   * Checked once near startup.
   * On Windows, this is operationalized as whether Firefox is the default
   * HTTP protocol handler and the default HTML file handler.
   */
  constexpr impl::BooleanMetric default_at_launch(385);

  /**
   * generated from browser.is_user_default
   */
  enum class IsUserDefaultLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether Firefox is the system default browser on startup. A true value is also recorded here, and a false value is recorded to set_default_error, if a user clicked 'Use Firefox as my default browser' on an in-product prompt. (Note that on Windows 8+ the latter action opens the right settings dialog but does not actually change the default browser without further user action.) On Windows, 'system default browser' is operationalized as whether Firefox is the default HTTP protocol handler.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_IS_USER_DEFAULT.
   */
  constexpr impl::Labeled<impl::CounterMetric, IsUserDefaultLabel> is_user_default(386);

  /**
   * generated from browser.is_user_default_error
   */
  enum class IsUserDefaultErrorLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True if the browser was unable to determine if the browser was set as default.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_IS_USER_DEFAULT_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric, IsUserDefaultErrorLabel> is_user_default_error(387);

  /**
   * generated from browser.set_default_always_check
   */
  enum class SetDefaultAlwaysCheckLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True if the profile has `browser.shell.checkDefaultBrowser` set to true.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_SET_DEFAULT_ALWAYS_CHECK.
   */
  constexpr impl::Labeled<impl::CounterMetric, SetDefaultAlwaysCheckLabel> set_default_always_check(388);

  /**
   * generated from browser.set_default_dialog_prompt_rawcount
   * The number of times that a profile has seen the 'Set Default Browser' dialog.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram BROWSER_SET_DEFAULT_DIALOG_PROMPT_RAWCOUNT.
   */
  constexpr impl::CustomDistributionMetric set_default_dialog_prompt_rawcount(389);

  /**
   * generated from browser.set_default_error
   */
  enum class SetDefaultErrorLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * True if the browser was unable to set Firefox as the default browser
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram BROWSER_SET_DEFAULT_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric, SetDefaultErrorLabel> set_default_error(390);

  /**
   * generated from browser.set_default_pdf_handler_user_choice_result
   */
  enum class SetDefaultPdfHandlerUserChoiceResultLabel: uint16_t {
    eSuccess = 0,
    eErrprogid = 1,
    eErrhash = 2,
    eErrlaunchexe = 3,
    eErrexetimeout = 4,
    eErrexeprogid = 5,
    eErrexehash = 6,
    eErrexerejected = 7,
    eErrexeother = 8,
    eErrother = 9,
    eErrbuild = 10,
    e__Other__,
  };
  /**
   * Result of each attempt to set the default browser with SetDefaultExtensionHandlersUserChoice() for pdf extension
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_SET_DEFAULT_PDF_HANDLER_USER_CHOICE_RESULT.
   */
  constexpr impl::Labeled<impl::CounterMetric, SetDefaultPdfHandlerUserChoiceResultLabel> set_default_pdf_handler_user_choice_result(391);

  /**
   * generated from browser.set_default_result
   * Result of the Set Default Browser dialog. After Firefox 89 the these values are: (0=Use Firefox + 'Don't ask again' checked, 1=Use Firefox + 'Don't ask again' unchecked, 2=Not Now + 'Don't ask again' checked, 3=Not Now + 'Don't ask again' unchecked). Before Firefox 89 these values were: (0=Use Firefox + 'Always perform check' unchecked, 1=Use Firefox + 'Always perform check' checked, 2=Not Now + 'Always perform check' unchecked, 3=Not Now + 'Always perform check' checked).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram BROWSER_SET_DEFAULT_RESULT.
   */
  constexpr impl::CustomDistributionMetric set_default_result(392);

  /**
   * generated from browser.set_default_user_choice_result
   */
  enum class SetDefaultUserChoiceResultLabel: uint16_t {
    eSuccess = 0,
    eErrprogid = 1,
    eErrhash = 2,
    eErrlaunchexe = 3,
    eErrexetimeout = 4,
    eErrexeprogid = 5,
    eErrexehash = 6,
    eErrexerejected = 7,
    eErrexeother = 8,
    eErrother = 9,
    eErrbuild = 10,
    e__Other__,
  };
  /**
   * Result of each attempt to set the default browser with SetDefaultBrowserUserChoice()
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram BROWSER_SET_DEFAULT_USER_CHOICE_RESULT.
   */
  constexpr impl::Labeled<impl::CounterMetric, SetDefaultUserChoiceResultLabel> set_default_user_choice_result(393);
}

namespace browser_launched_to_handle {
  /**
   * generated from browser.launched_to_handle.system_notification
   */
  struct SystemNotificationExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> name;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when Firefox launches to complete a native notification popped by a system (chrome privileged) alert.  Windows-only at the time of writing.
   */
  constexpr impl::EventMetric<SystemNotificationExtra> system_notification(394);
}

namespace browser_startup {
  /**
   * generated from browser.startup.abouthome_cache_result
   * How the about:home startup cache functioned on startup.
   * 0: Result value was never set (error case) 1: Cache did not exist 2: Cache page stream was corrupt / inaccessible 3: Cache script stream was corrupt / inaccessible 4: Cache was invalidated by a version bump 5: Cache was valid, but read too late to be useful. 6: Cache was valid and used. 7: Cache is disabled. 8: User did not load about:home on its own by default. 9: Cache is disabled because about:newtab preloading is disabled.
   * This metric was generated to correspond to the Legacy Telemetry scalar browser.startup.abouthome_cache_result.
   */
  constexpr impl::QuantityMetric abouthome_cache_result(395);

  /**
   * generated from browser.startup.abouthome_cache_shutdownwrite
   * True if the about:home startup cache was written via the AsyncShutdown blocker. This metric was generated to correspond to the Legacy Telemetry scalar browser.startup.abouthome_cache_shutdownwrite.
   */
  constexpr impl::BooleanMetric abouthome_cache_shutdownwrite(396);

  /**
   * generated from browser.startup.kiosk_mode
   * True when the browser was started in kiosk mode.
   */
  constexpr impl::BooleanMetric kiosk_mode(397);
}

namespace datasanitization {
  /**
   * generated from datasanitization.privacy_clear_on_shutdown_cache
   * A boolean reporting the value of the privacy.clearOnShutdown.cache pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_cache.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_cache(398);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_cookies
   * A boolean reporting the value of the privacy.clearOnShutdown.cookies pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_cookies.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_cookies(399);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_downloads
   * A boolean reporting the value of the privacy.clearOnShutdown.downloads pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_downloads.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_downloads(400);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_formdata
   * A boolean reporting the value of the privacy.clearOnShutdown.formdata pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_formdata.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_formdata(401);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_history
   * A boolean reporting the value of the privacy.clearOnShutdown.history pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_history.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_history(402);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_offline_apps
   * A boolean reporting the value of the privacy.clearOnShutdown.offlineApps pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_offlineApps.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_offline_apps(403);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_open_windows
   * A boolean reporting the value of the privacy.clearOnShutdown.openWindows pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_openWindows.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_open_windows(404);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_sessions
   * A boolean reporting the value of the privacy.clearOnShutdown.sessions pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_sessions.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_sessions(405);

  /**
   * generated from datasanitization.privacy_clear_on_shutdown_site_settings
   * A boolean reporting the value of the privacy.clearOnShutdown.siteSettings pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_clearOnShutdown_siteSettings.
   */
  constexpr impl::BooleanMetric privacy_clear_on_shutdown_site_settings(406);

  /**
   * generated from datasanitization.privacy_sanitize_sanitize_on_shutdown
   * A boolean reporting the value of the privacy.sanitize.sanitizeOnShutdown pref. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.privacy_sanitize_sanitizeOnShutdown.
   */
  constexpr impl::BooleanMetric privacy_sanitize_sanitize_on_shutdown(407);

  /**
   * generated from datasanitization.session_permission_exceptions
   * A count of how many "session" cookie exceptions a user has set. This metric was generated to correspond to the Legacy Telemetry scalar datasanitization.session_permission_exceptions.
   */
  constexpr impl::QuantityMetric session_permission_exceptions(408);
}

namespace launch_on_login {
  /**
   * generated from launch_on_login.last_profile_disable_startup
   */
  /**
   * Recorded when Launch on login is disabled because the start with last profile setting has been disabled. This event was generated to correspond to the Legacy Telemetry event launch_on_login.last_profile_disable#startup.
   */
  constexpr impl::EventMetric<NoExtraKeys> last_profile_disable_startup(409);
}

namespace os_environment {
  /**
   * generated from os.environment.invoked_to_handle
   * Records counts for when Firefox was invoked (i.e., was already running and was not launched) to handle a file type or protocol with `-osint -url ...`.  The result is split into keys which represent the file extension: currently, the set of file types Firefox registers to handle, namely ".avif", ".htm", ".html", ".pdf", ".shtml", ".xht", ".xhtml", ".svg", ".webp", and the set of protocol schemes that Firefox registers to handle, namely "about", "http", "https", "mailto".  If Firefox was invoked to handle a file type or protocol it does not register to handle by default, the count is recorded as ".<other extension>" or "<other protocol>", respectively (neither of which are valid extension or protocol identifiers). This metric was generated to correspond to the Legacy Telemetry scalar os.environment.invoked_to_handle.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> invoked_to_handle(410);

  /**
   * generated from os.environment.is_default_handler
   * Records whether Firefox was the default handler for particular file types or protocols.  The result is split into keys which represent the file extension or scheme: currently, a subset of the file types Firefox registers to handle, namely ".pdf" and "mailto" as protocol. In the future, more file types may be recorded. This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_default_handler.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> is_default_handler(411);

  /**
   * generated from os.environment.is_kept_in_dock
   * Whether this app was kept in macOS Dock on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_kept_in_dock.
   */
  constexpr impl::BooleanMetric is_kept_in_dock(412);

  /**
   * generated from os.environment.is_taskbar_pinned
   * Whether the non-Private Browsing version of this app was pinned to taskbar on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_taskbar_pinned.
   */
  constexpr impl::BooleanMetric is_taskbar_pinned(413);

  /**
   * generated from os.environment.is_taskbar_pinned_private
   * Whether the Private Browsing version of this app was pinned to taskbar on startup This metric was generated to correspond to the Legacy Telemetry scalar os.environment.is_taskbar_pinned_private.
   */
  constexpr impl::BooleanMetric is_taskbar_pinned_private(414);

  /**
   * generated from os.environment.launch_method
   * Records how Firefox was started on Windows. Currently will be one of "Desktop", "DesktopPrivate", "StartMenu" (including pins), "StartMenuPrivate", "Taskbar", "TaskbarPrivate", "OtherShortcut", or "Other" This metric was generated to correspond to the Legacy Telemetry scalar os.environment.launch_method.
   */
  constexpr impl::StringMetric launch_method(415);

  /**
   * generated from os.environment.launched_to_handle
   * Records counts for when Firefox was launched afresh (i.e., was not already running) to handle a file type or protocol with `-osint -url ...`.  The result is split into keys which represent the file extension: currently, the set of file types Firefox registers to handle, namely ".avif", ".htm", ".html", ".pdf", ".shtml", ".xht", ".xhtml", ".svg", ".webp", and the set of protocol schemes that Firefox registers to handle, namely "about", "http", "https", "mailto".  If Firefox was launched to handle a file type or protocol it does not register to handle by default, the count is recorded as ".<other extension>" or "<other protocol>", respectively (neither of which are valid extension or protocol identifiers). This metric was generated to correspond to the Legacy Telemetry scalar os.environment.launched_to_handle.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> launched_to_handle(416);
}

namespace primary_password {
  /**
   * generated from primary.password.enabled
   * If a primary-password is enabled for this profile. Set soon after browser startup. Does not update if a primary password is added or removed after startup.
   */
  constexpr impl::BooleanMetric enabled(419);
}

namespace security {
  /**
   * generated from security.global_privacy_control_enabled
   * Measures user retention of the Global Privacy Control. 0 = never enabled, 1 = enabled, 2 = disabled (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.global_privacy_control_enabled.
   */
  constexpr impl::QuantityMetric global_privacy_control_enabled(420);

  /**
   * generated from security.https_only_mode_enabled
   * Measures user retention of the HTTPS-Only Mode. 0 = never enabled, 1 = enabled, 2 = disabled (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.https_only_mode_enabled.
   */
  constexpr impl::QuantityMetric https_only_mode_enabled(421);

  /**
   * generated from security.https_only_mode_enabled_pbm
   * Measures user retention of the HTTPS-Only Mode in Private Browsing. 0 = https-only never enabled in PBM, 1 = https-only enabled in PBM, 2 = https-only disabled in PBM (but was enabled) This metric was generated to correspond to the Legacy Telemetry scalar security.https_only_mode_enabled_pbm.
   */
  constexpr impl::QuantityMetric https_only_mode_enabled_pbm(422);
}

namespace sslkeylogging {
  /**
   * generated from sslkeylogging.enabled
   * Records whether TLS key logging has been enabled via the environment variable SSLKEYLOGFILE.
   */
  constexpr impl::BooleanMetric enabled(437);
}

namespace start_menu {
  /**
   * generated from start_menu.manually_unpinned_since_last_launch
   */
  /**
   * Records whether Firefox has been unpinned from the Windows start menu since last launch. This will only be recorded on MSIX due to the underlying API only being available for packaged applications.
   */
  constexpr impl::EventMetric<NoExtraKeys> manually_unpinned_since_last_launch(438);
}

namespace startup {
  /**
   * generated from startup.is_cold
   * Whether or not this startup is the first startup since OS reboot (according to our best guess.) This metric was generated to correspond to the Legacy Telemetry scalar startup.is_cold.
   */
  constexpr impl::BooleanMetric is_cold(439);

  /**
   * generated from startup.seconds_since_last_os_restart
   * The time in seconds between the first browser window loading, and the time the OS started. This can give us an indication of whether starting the browser may have been the first thing the user did after starting their computer. This metric was generated to correspond to the Legacy Telemetry scalar startup.seconds_since_last_os_restart.
   */
  constexpr impl::QuantityMetric seconds_since_last_os_restart(440);
}

namespace upgrade_dialog {
  /**
   * generated from upgrade_dialog.trigger_reason
   */
  struct TriggerReasonExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggering behaviors of the upgrade dialog. Value indicates which condition failed or all satisfied. This event was generated to correspond to the Legacy Telemetry event upgrade_dialog.trigger#reason.
   */
  constexpr impl::EventMetric<TriggerReasonExtra> trigger_reason(444);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBrowserComponentsMetrics_h
