// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDevtoolsClientFrameworkMetrics_h
#define mozilla_GleanDevtoolsClientFrameworkMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace devtools {
  /**
   * generated from devtools.cold_toolbox_open_delay
   * Time taken (in ms) to open the first DevTools toolbox. This is keyed by tool ID being opened [inspector, webconsole, jsdebugger, styleeditor, performance, memory, netmonitor, storage, dom].
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_COLD_TOOLBOX_OPEN_DELAY_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> cold_toolbox_open_delay(1021);

  /**
   * generated from devtools.current_theme
   * Number of times DevTools was opened, keyed by theme. This metric was generated to correspond to the Legacy Telemetry scalar devtools.current_theme.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> current_theme(1022);

  /**
   * generated from devtools.toolbox_host
   * Records DevTools toolbox host each time the toolbox is opened and when the host is changed (0:Bottom, 1:RIGHT, 2:WINDOW, 3:CUSTOM, 4:LEFT, 5:PAGE, 9:Unknown).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DEVTOOLS_TOOLBOX_HOST.
   */
  constexpr impl::CustomDistributionMetric toolbox_host(1023);

  /**
   * generated from devtools.toolbox_page_reload_delay
   * Time taken (in ms) to update DevTools panel when reloading a page. This is keyed by tool ID being currently opened [inspector, webconsole, jsdebugger, styleeditor, performance, memory, netmonitor, storage, dom].
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_TOOLBOX_PAGE_RELOAD_DELAY_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> toolbox_page_reload_delay(1024);

  /**
   * generated from devtools.warm_toolbox_open_delay
   * Time taken (in ms) to open all but first DevTools toolbox. This is keyed by tool ID being opened [inspector, webconsole, jsdebugger, styleeditor, performance, memory, netmonitor, storage, dom].
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_WARM_TOOLBOX_OPEN_DELAY_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> warm_toolbox_open_delay(1025);
}

namespace devtools_tool {
  /**
   * generated from devtools.tool.registered
   * Recorded on enable tool checkbox check/uncheck in Developer Tools options panel. Boolean stating if the tool was enabled or disabled by the user. Keyed by tool id. Current default tools with their id's are defined in https://searchfox.org/mozilla- central/source/devtools/client/definitions.js This metric was generated to correspond to the Legacy Telemetry scalar devtools.tool.registered.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> registered(1084);
}

namespace devtools_toolbox {
  /**
   * generated from devtools.toolbox.tabs_reordered
   * Number of times the DevTools tab was reordered. Keyed by tab's id. This metric was generated to correspond to the Legacy Telemetry scalar devtools.toolbox.tabs_reordered.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabs_reordered(1085);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDevtoolsClientFrameworkMetrics_h
