// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomServiceworkersMetrics_h
#define mozilla_GleanDomServiceworkersMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace service_worker {
  /**
   * generated from service_worker.fetch_event_channel_reset
   * Time (in ms) measured between when the fetch handler finished executing and when we reset the network channel.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_FETCH_EVENT_CHANNEL_RESET_MS_2.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> fetch_event_channel_reset(3826);

  /**
   * generated from service_worker.fetch_event_dispatch
   * Time (in ms) measured between when the fetch event is dispatched by the Service Worker and before we execute the event listeners.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_FETCH_EVENT_DISPATCH_MS_2.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> fetch_event_dispatch(3827);

  /**
   * generated from service_worker.fetch_event_finish_synthesized_response
   * Time (in ms) measured between when the respondWith promise resolves and when we provide the response through the intercepted channel.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_FETCH_EVENT_FINISH_SYNTHESIZED_RESPONSE_MS_2.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> fetch_event_finish_synthesized_response(3828);

  /**
   * generated from service_worker.fetch_interception_duration
   * Time delta (ms) between when a network request is intercepted in the parent process and the service worker provides a response.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_FETCH_INTERCEPTION_DURATION_MS_2.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> fetch_interception_duration(3829);

  /**
   * generated from service_worker.isolated_launch_time
   * Time (ms) for spawning a service worker in an isolated content process.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_ISOLATED_LAUNCH_TIME.
   */
  constexpr impl::TimingDistributionMetric isolated_launch_time(3830);

  /**
   * generated from service_worker.launch_time
   * Time (ms) for spawning a service worker in the remote content process.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_LAUNCH_TIME_2.
   */
  constexpr impl::TimingDistributionMetric launch_time(3831);

  /**
   * generated from service_worker.registration_loading
   * Tracking how ServiceWorkerRegistrar loads data before the first content is shown.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SERVICE_WORKER_REGISTRATION_LOADING.
   */
  constexpr impl::TimingDistributionMetric registration_loading(3832);

  /**
   * generated from service_worker.running
   */
  enum class RunningLabel: uint16_t {
    eAll = 0,
    eFetch = 1,
    e__Other__,
  };
  /**
   * The sampled number of simultaneous running ServiceWorkers in a session, sampled once each 10 seconds (lazily on state change)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram SERVICE_WORKER_RUNNING.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, RunningLabel> running(3833);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomServiceworkersMetrics_h
