// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanEditorLibeditorMetrics_h
#define mozilla_GleanEditorLibeditorMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace htmleditors {
  /**
   * generated from htmleditors.overridden_by_beforeinput_listeners
   */
  enum class OverriddenByBeforeinputListenersLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Number of HTML editors whose dispatching beforeinput events are canceled
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTMLEDITORS_OVERRIDDEN_BY_BEFOREINPUT_LISTENERS.
   */
  constexpr impl::Labeled<impl::CounterMetric, OverriddenByBeforeinputListenersLabel> overridden_by_beforeinput_listeners(3847);

  /**
   * generated from htmleditors.with_beforeinput_listeners
   */
  enum class WithBeforeinputListenersLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Number of HTML editors whose window or a node in it has had beforeinput event listeners
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTMLEDITORS_WITH_BEFOREINPUT_LISTENERS.
   */
  constexpr impl::Labeled<impl::CounterMetric, WithBeforeinputListenersLabel> with_beforeinput_listeners(3848);

  /**
   * generated from htmleditors.with_mutation_listeners_without_beforeinput_listeners
   */
  enum class WithMutationListenersWithoutBeforeinputListenersLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Number of HTML editors whose window or a node in it has had mutation event listeners, but has not had beforeinput event listeners
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTMLEDITORS_WITH_MUTATION_LISTENERS_WITHOUT_BEFOREINPUT_LISTENERS.
   */
  constexpr impl::Labeled<impl::CounterMetric, WithMutationListenersWithoutBeforeinputListenersLabel> with_mutation_listeners_without_beforeinput_listeners(3849);

  /**
   * generated from htmleditors.with_mutation_observers_without_beforeinput_listeners
   */
  enum class WithMutationObserversWithoutBeforeinputListenersLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Number of HTML editors a node in the window has been observed by mutation observers, but has not had beforeinput event listeners
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTMLEDITORS_WITH_MUTATION_OBSERVERS_WITHOUT_BEFOREINPUT_LISTENERS.
   */
  constexpr impl::Labeled<impl::CounterMetric, WithMutationObserversWithoutBeforeinputListenersLabel> with_mutation_observers_without_beforeinput_listeners(3850);
}

} // namespace mozilla::glean

#endif // mozilla_GleanEditorLibeditorMetrics_h
