// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGenaiMetrics_h
#define mozilla_GleanGenaiMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace genai_chatbot {
  /**
   * generated from genai.chatbot.contextmenu_prompt_click
   */
  struct ContextmenuPromptClickExtra {
    mozilla::Maybe<nsCString> prompt;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> selection;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (prompt) {
        extraKeys.AppendElement()->AssignASCII("prompt");
        extraValues.EmplaceBack(prompt.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (selection) {
        extraKeys.AppendElement()->AssignASCII("selection");
        extraValues.AppendElement()->AppendInt(selection.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot prompt was clicked from the context menu.
   */
  constexpr impl::EventMetric<ContextmenuPromptClickExtra> contextmenu_prompt_click(329);

  /**
   * generated from genai.chatbot.contextmenu_remove
   */
  struct ContextmenuRemoveExtra {
    mozilla::Maybe<nsCString> provider;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot provider was removed from the context menu.
   */
  constexpr impl::EventMetric<ContextmenuRemoveExtra> contextmenu_remove(330);

  /**
   * generated from genai.chatbot.enabled
   * Indicates if the chatbot feature is enabled.
   */
  constexpr impl::BooleanMetric enabled(331);

  /**
   * generated from genai.chatbot.experiment_checkbox_click
   */
  struct ExperimentCheckboxClickExtra {
    mozilla::Maybe<bool> enabled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot experiment checkbox was clicked to enable/disable.
   */
  constexpr impl::EventMetric<ExperimentCheckboxClickExtra> experiment_checkbox_click(332);

  /**
   * generated from genai.chatbot.keyboard_shortcut
   */
  struct KeyboardShortcutExtra {
    mozilla::Maybe<bool> enabled;
    mozilla::Maybe<nsCString> sidebar;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      if (sidebar) {
        extraKeys.AppendElement()->AssignASCII("sidebar");
        extraValues.EmplaceBack(sidebar.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot sidebar toggled with keyboard shortcut.
   */
  constexpr impl::EventMetric<KeyboardShortcutExtra> keyboard_shortcut(333);

  /**
   * generated from genai.chatbot.onboarding_close
   */
  struct OnboardingCloseExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding closed from provider choice.
   */
  constexpr impl::EventMetric<OnboardingCloseExtra> onboarding_close(334);

  /**
   * generated from genai.chatbot.onboarding_continue
   */
  struct OnboardingContinueExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding continued from provider choice.
   */
  constexpr impl::EventMetric<OnboardingContinueExtra> onboarding_continue(335);

  /**
   * generated from genai.chatbot.onboarding_finish
   */
  struct OnboardingFinishExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding finished with start chatting button.
   */
  constexpr impl::EventMetric<OnboardingFinishExtra> onboarding_finish(336);

  /**
   * generated from genai.chatbot.onboarding_learn_more
   */
  struct OnboardingLearnMoreExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding opened feature learn more link.
   */
  constexpr impl::EventMetric<OnboardingLearnMoreExtra> onboarding_learn_more(337);

  /**
   * generated from genai.chatbot.onboarding_provider_choice_displayed
   */
  struct OnboardingProviderChoiceDisplayedExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding impression for provider choice screen.
   */
  constexpr impl::EventMetric<OnboardingProviderChoiceDisplayedExtra> onboarding_provider_choice_displayed(338);

  /**
   * generated from genai.chatbot.onboarding_provider_learn
   */
  struct OnboardingProviderLearnExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding opened provider learn more link.
   */
  constexpr impl::EventMetric<OnboardingProviderLearnExtra> onboarding_provider_learn(339);

  /**
   * generated from genai.chatbot.onboarding_provider_selection
   */
  struct OnboardingProviderSelectionExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding selected a provider.
   */
  constexpr impl::EventMetric<OnboardingProviderSelectionExtra> onboarding_provider_selection(340);

  /**
   * generated from genai.chatbot.onboarding_provider_terms
   */
  struct OnboardingProviderTermsExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;
    mozilla::Maybe<nsCString> text;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      if (text) {
        extraKeys.AppendElement()->AssignASCII("text");
        extraValues.EmplaceBack(text.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding opened provider terms link.
   */
  constexpr impl::EventMetric<OnboardingProviderTermsExtra> onboarding_provider_terms(341);

  /**
   * generated from genai.chatbot.onboarding_text_highlight_displayed
   */
  struct OnboardingTextHighlightDisplayedExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.AppendElement()->AppendInt(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot onboarding impression for text highlight screen.
   */
  constexpr impl::EventMetric<OnboardingTextHighlightDisplayedExtra> onboarding_text_highlight_displayed(342);

  /**
   * generated from genai.chatbot.provider
   * Indicates id of activated chatbot provider or "custom" or "none"
   */
  constexpr impl::StringMetric provider(343);

  /**
   * generated from genai.chatbot.provider_change
   */
  struct ProviderChangeExtra {
    mozilla::Maybe<nsCString> current;
    mozilla::Maybe<nsCString> previous;
    mozilla::Maybe<nsCString> surface;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (current) {
        extraKeys.AppendElement()->AssignASCII("current");
        extraValues.EmplaceBack(current.value());
      }
      if (previous) {
        extraKeys.AppendElement()->AssignASCII("previous");
        extraValues.EmplaceBack(previous.value());
      }
      if (surface) {
        extraKeys.AppendElement()->AssignASCII("surface");
        extraValues.EmplaceBack(surface.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot provider UI changed providers.
   */
  constexpr impl::EventMetric<ProviderChangeExtra> provider_change(344);

  /**
   * generated from genai.chatbot.shortcuts
   * Indicates if the chatbot feature would show shortcuts on selection.
   */
  constexpr impl::BooleanMetric shortcuts(345);

  /**
   * generated from genai.chatbot.shortcuts_checkbox_click
   */
  struct ShortcutsCheckboxClickExtra {
    mozilla::Maybe<bool> enabled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot shortcuts checkbox was clicked to enable/disable.
   */
  constexpr impl::EventMetric<ShortcutsCheckboxClickExtra> shortcuts_checkbox_click(346);

  /**
   * generated from genai.chatbot.shortcuts_custom
   * Indicates if the chatbot feature would show shortcuts custom input.
   */
  constexpr impl::BooleanMetric shortcuts_custom(347);

  /**
   * generated from genai.chatbot.shortcuts_displayed
   */
  struct ShortcutsDisplayedExtra {
    mozilla::Maybe<uint32_t> delay;
    mozilla::Maybe<nsCString> inputtype;
    mozilla::Maybe<uint32_t> selection;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (delay) {
        extraKeys.AppendElement()->AssignASCII("delay");
        extraValues.AppendElement()->AppendInt(delay.value());
      }
      if (inputtype) {
        extraKeys.AppendElement()->AssignASCII("inputType");
        extraValues.EmplaceBack(inputtype.value());
      }
      if (selection) {
        extraKeys.AppendElement()->AssignASCII("selection");
        extraValues.AppendElement()->AppendInt(selection.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Shortcuts displayed on text selection.
   */
  constexpr impl::EventMetric<ShortcutsDisplayedExtra> shortcuts_displayed(348);

  /**
   * generated from genai.chatbot.shortcuts_expanded
   */
  struct ShortcutsExpandedExtra {
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> selection;
    mozilla::Maybe<bool> warning;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (selection) {
        extraKeys.AppendElement()->AssignASCII("selection");
        extraValues.AppendElement()->AppendInt(selection.value());
      }
      if (warning) {
        extraKeys.AppendElement()->AssignASCII("warning");
        extraValues.AppendElement()->AssignASCII(warning.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Shortcuts expanded to show prompts.
   */
  constexpr impl::EventMetric<ShortcutsExpandedExtra> shortcuts_expanded(349);

  /**
   * generated from genai.chatbot.shortcuts_hide_click
   */
  struct ShortcutsHideClickExtra {
    mozilla::Maybe<uint32_t> selection;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (selection) {
        extraKeys.AppendElement()->AssignASCII("selection");
        extraValues.AppendElement()->AppendInt(selection.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot hide shortcuts was clicked from the shortcuts.
   */
  constexpr impl::EventMetric<ShortcutsHideClickExtra> shortcuts_hide_click(350);

  /**
   * generated from genai.chatbot.shortcuts_prompt_click
   */
  struct ShortcutsPromptClickExtra {
    mozilla::Maybe<nsCString> prompt;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<uint32_t> selection;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (prompt) {
        extraKeys.AppendElement()->AssignASCII("prompt");
        extraValues.EmplaceBack(prompt.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (selection) {
        extraKeys.AppendElement()->AssignASCII("selection");
        extraValues.AppendElement()->AppendInt(selection.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot prompt was clicked from the shortcuts.
   */
  constexpr impl::EventMetric<ShortcutsPromptClickExtra> shortcuts_prompt_click(351);

  /**
   * generated from genai.chatbot.sidebar
   * Indicates if the chatbot feature would open in sidebar.
   */
  constexpr impl::BooleanMetric sidebar(352);

  /**
   * generated from genai.chatbot.sidebar_close_click
   */
  struct SidebarCloseClickExtra {
    mozilla::Maybe<nsCString> provider;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot close X clicked.
   */
  constexpr impl::EventMetric<SidebarCloseClickExtra> sidebar_close_click(353);

  /**
   * generated from genai.chatbot.sidebar_more_menu_click
   */
  struct SidebarMoreMenuClickExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> provider;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot more menu clicked an action.
   */
  constexpr impl::EventMetric<SidebarMoreMenuClickExtra> sidebar_more_menu_click(354);

  /**
   * generated from genai.chatbot.sidebar_more_menu_display
   */
  struct SidebarMoreMenuDisplayExtra {
    mozilla::Maybe<nsCString> provider;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot more menu opened.
   */
  constexpr impl::EventMetric<SidebarMoreMenuDisplayExtra> sidebar_more_menu_display(355);

  /**
   * generated from genai.chatbot.sidebar_provider_menu_click
   */
  struct SidebarProviderMenuClickExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> provider;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot provider menu clicked an action.
   */
  constexpr impl::EventMetric<SidebarProviderMenuClickExtra> sidebar_provider_menu_click(356);

  /**
   * generated from genai.chatbot.sidebar_toggle
   */
  struct SidebarToggleExtra {
    mozilla::Maybe<bool> opened;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (opened) {
        extraKeys.AppendElement()->AssignASCII("opened");
        extraValues.AppendElement()->AssignASCII(opened.value() ? "true" : "false");
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Chatbot sidebar panel was toggled open/close.
   */
  constexpr impl::EventMetric<SidebarToggleExtra> sidebar_toggle(357);
}

namespace genai_linkpreview {
  /**
   * generated from genai.linkpreview.card_ai_consent
   */
  struct CardAiConsentExtra {
    mozilla::Maybe<nsCString> option;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (option) {
        extraKeys.AppendElement()->AssignASCII("option");
        extraValues.EmplaceBack(option.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user interacts with the AI consent dialog
   */
  constexpr impl::EventMetric<CardAiConsentExtra> card_ai_consent(358);

  /**
   * generated from genai.linkpreview.card_close
   */
  struct CardCloseExtra {
    mozilla::Maybe<uint32_t> duration;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.AppendElement()->AppendInt(duration.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user closes the card
   */
  constexpr impl::EventMetric<CardCloseExtra> card_close(359);

  /**
   * generated from genai.linkpreview.card_link
   */
  struct CardLinkExtra {
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks on a link from the card
   */
  constexpr impl::EventMetric<CardLinkExtra> card_link(360);

  /**
   * generated from genai.linkpreview.enabled
   * Records if the user has link previews enabled
   */
  constexpr impl::BooleanMetric enabled(361);

  /**
   * generated from genai.linkpreview.fetch
   */
  struct FetchExtra {
    mozilla::Maybe<bool> description;
    mozilla::Maybe<bool> image;
    mozilla::Maybe<uint32_t> length;
    mozilla::Maybe<nsCString> outcome;
    mozilla::Maybe<bool> sitename;
    mozilla::Maybe<bool> skipped;
    mozilla::Maybe<uint32_t> time;
    mozilla::Maybe<bool> title;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (description) {
        extraKeys.AppendElement()->AssignASCII("description");
        extraValues.AppendElement()->AssignASCII(description.value() ? "true" : "false");
      }
      if (image) {
        extraKeys.AppendElement()->AssignASCII("image");
        extraValues.AppendElement()->AssignASCII(image.value() ? "true" : "false");
      }
      if (length) {
        extraKeys.AppendElement()->AssignASCII("length");
        extraValues.AppendElement()->AppendInt(length.value());
      }
      if (outcome) {
        extraKeys.AppendElement()->AssignASCII("outcome");
        extraValues.EmplaceBack(outcome.value());
      }
      if (sitename) {
        extraKeys.AppendElement()->AssignASCII("sitename");
        extraValues.AppendElement()->AssignASCII(sitename.value() ? "true" : "false");
      }
      if (skipped) {
        extraKeys.AppendElement()->AssignASCII("skipped");
        extraValues.AppendElement()->AssignASCII(skipped.value() ? "true" : "false");
      }
      if (time) {
        extraKeys.AppendElement()->AssignASCII("time");
        extraValues.AppendElement()->AppendInt(time.value());
      }
      if (title) {
        extraKeys.AppendElement()->AssignASCII("title");
        extraValues.AppendElement()->AssignASCII(title.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the browser fetches the page to be previewed
   */
  constexpr impl::EventMetric<FetchExtra> fetch(362);

  /**
   * generated from genai.linkpreview.generate
   */
  struct GenerateExtra {
    mozilla::Maybe<uint32_t> delay;
    mozilla::Maybe<uint32_t> download;
    mozilla::Maybe<uint32_t> latency;
    mozilla::Maybe<nsCString> outcome;
    mozilla::Maybe<uint32_t> sentences;
    mozilla::Maybe<uint32_t> time;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (delay) {
        extraKeys.AppendElement()->AssignASCII("delay");
        extraValues.AppendElement()->AppendInt(delay.value());
      }
      if (download) {
        extraKeys.AppendElement()->AssignASCII("download");
        extraValues.AppendElement()->AppendInt(download.value());
      }
      if (latency) {
        extraKeys.AppendElement()->AssignASCII("latency");
        extraValues.AppendElement()->AppendInt(latency.value());
      }
      if (outcome) {
        extraKeys.AppendElement()->AssignASCII("outcome");
        extraValues.EmplaceBack(outcome.value());
      }
      if (sentences) {
        extraKeys.AppendElement()->AssignASCII("sentences");
        extraValues.AppendElement()->AppendInt(sentences.value());
      }
      if (time) {
        extraKeys.AppendElement()->AssignASCII("time");
        extraValues.AppendElement()->AppendInt(time.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the model finishes generating the preview
   */
  constexpr impl::EventMetric<GenerateExtra> generate(363);

  /**
   * generated from genai.linkpreview.key_points_toggle
   */
  struct KeyPointsToggleExtra {
    mozilla::Maybe<bool> expand;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (expand) {
        extraKeys.AppendElement()->AssignASCII("expand");
        extraValues.AppendElement()->AssignASCII(expand.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user toggles the key points section
   */
  constexpr impl::EventMetric<KeyPointsToggleExtra> key_points_toggle(364);

  /**
   * generated from genai.linkpreview.labs_checkbox
   */
  struct LabsCheckboxExtra {
    mozilla::Maybe<bool> enabled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user clicks on the Labs checkbox
   */
  constexpr impl::EventMetric<LabsCheckboxExtra> labs_checkbox(365);

  /**
   * generated from genai.linkpreview.onboarding_card
   */
  struct OnboardingCardExtra {
    mozilla::Maybe<nsCString> action;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the link preview onboarding is displayed and how the user interacts with it.
   */
  constexpr impl::EventMetric<OnboardingCardExtra> onboarding_card(366);

  /**
   * generated from genai.linkpreview.start
   */
  struct StartExtra {
    mozilla::Maybe<bool> cached;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cached) {
        extraKeys.AppendElement()->AssignASCII("cached");
        extraValues.AppendElement()->AssignASCII(cached.value() ? "true" : "false");
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user initiates a link preview
   */
  constexpr impl::EventMetric<StartExtra> start(367);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGenaiMetrics_h
