// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGleanTestsTestMetrics_h
#define mozilla_GleanGleanTestsTestMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace test_only {
  /**
   * generated from test_only.bad_code
   * Number of times we encountered bad code.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric bad_code(4763);


  /**
   * generated from test_only.button_jars
   * The number of buttons in each button jar.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::QuantityMetric, DynamicLabel> button_jars(4765);

  /**
   * generated from test_only.can_we_flag_it
   * Test metric for a boolean.
   * This is a test-only metric.
   */
  constexpr impl::BooleanMetric can_we_flag_it(4766);

  /**
   * generated from test_only.can_we_time_it
   * Test metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric can_we_time_it(4767);

  /**
   * generated from test_only.cheesy_string
   * Only the cheesiest of strings.
   * This is a test-only metric.
   */
  constexpr impl::StringMetric cheesy_string(4768);

  /**
   * generated from test_only.cheesy_string_list
   * Only the cheesiest of strings. In list form!
   * This is a test-only metric.
   */
  constexpr impl::StringListMetric cheesy_string_list(4769);

  /**
   * generated from test_only.collection_disabled_counter
   * Number of times we count.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric collection_disabled_counter(4770);


  /**
   * generated from test_only.default_products
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.default_products.
   */
  constexpr impl::CounterMetric default_products(4772);

  /**
   * generated from test_only.desktop_only
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.desktop_only.
   */
  constexpr impl::CounterMetric desktop_only(4773);

  /**
   * generated from test_only.disabled_counter
   * Number of times we count.
   * This is a test-only metric.
   */
  constexpr impl::CounterMetric disabled_counter(4774);

  /**
   * generated from test_only.do_you_remember
   * They say it's the second thing to go.
   * This is a test-only metric.
   */
  constexpr impl::MemoryDistributionMetric do_you_remember(4775);

  /**
   * generated from test_only.expired
   * This mirrors to an expired testing scalar. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.expired.
   */
  constexpr impl::CounterMetric expired(4776);

  /**
   * generated from test_only.expired_hist
   * a testing histogram; not meant to be touched
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_TEST_EXPIRED.
   */
  constexpr impl::CustomDistributionMetric expired_hist(4777);

  /**
   * generated from test_only.impression_id_only
   * This is a test uint type with only the deletion-request store. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.impression_id_only.
   */
  constexpr impl::StringMetric impression_id_only(4778);

  /**
   * generated from test_only.keyed_expired
   * This mirrors to an expired testing scalar. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_expired.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> keyed_expired(4779);

  /**
   * generated from test_only.keyed_mobile_only
   * A keyed testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_mobile_only.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> keyed_mobile_only(4780);

  /**
   * generated from test_only.keyed_release_optin
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_release_optin.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> keyed_release_optin(4781);

  /**
   * generated from test_only.keyed_release_optout
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.keyed_release_optout.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> keyed_release_optout(4782);

  /**
   * generated from test_only.mabels_balloon_labels
   */
  enum class MabelsBalloonLabelsLabel: uint16_t {
    eCelebratory = 0,
    eCelebratoryAndSnarky = 1,
    e__Other__,
  };
  /**
   * How does Mabel label her balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, MabelsBalloonLabelsLabel> mabels_balloon_labels(4783);

  /**
   * generated from test_only.mabels_balloon_strings
   * What do the labeled Mabel's liked balloons' strings say?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_balloon_strings(4784);

  /**
   * generated from test_only.mabels_bathroom_counters
   * Counts Mabels labeled by their bathroom counters.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_bathroom_counters(4785);

  /**
   * generated from test_only.mabels_custom_label_lengths
   * Mabel wants to track the length of their new label maker's labels.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> mabels_custom_label_lengths(4786);

  /**
   * generated from test_only.mabels_kitchen_counters
   * Counts Mabels labeled by their kitchen counters.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_kitchen_counters(4787);

  /**
   * generated from test_only.mabels_label_maker
   * Mabel just got a label maker and wants to party like it's
   * 1999.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_label_maker(4788);

  /**
   * generated from test_only.mabels_labeled_counters
   */
  enum class MabelsLabeledCountersLabel: uint16_t {
    eNextToTheFridge = 0,
    eClean = 1,
    e1stCounter = 2,
    e__Other__,
  };
  /**
   * Counts Mabels labeled by their kitchen counters.
   * Now with static labels.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, MabelsLabeledCountersLabel> mabels_labeled_counters(4789);

  /**
   * generated from test_only.mabels_like_balloons
   * Does the labeled Mabel like balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mabels_like_balloons(4790);

  /**
   * generated from test_only.mabels_like_labeled_balloons
   */
  enum class MabelsLikeLabeledBalloonsLabel: uint16_t {
    eWater = 0,
    eBirthdayParty = 1,
    e__Other__,
  };
  /**
   * Does the labeled Mabel like balloons?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, MabelsLikeLabeledBalloonsLabel> mabels_like_labeled_balloons(4791);

  /**
   * generated from test_only.main_only
   * This is a test uint type with only the main store. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.main_only.
   */
  constexpr impl::QuantityMetric main_only(4792);

  /**
   * generated from test_only.meaning_of_life
   * Measures the one true answer to the Ultimate Question of Life,
   * the Universe, and Everything.
   * Approximately.
   * This is a test-only metric.
   */
  constexpr impl::QuantityMetric meaning_of_life(4793);

  /**
   * generated from test_only.mirror_time
   * Mirrored metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time(4794);

  /**
   * generated from test_only.mirror_time_nanos
   * Mirrored metric for a timespan.
   * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time_nanos(4795);

  /**
   * generated from test_only.mirrors_for_labeled_bools
   * Mirrored metric.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mirrors_for_labeled_bools(4796);

  /**
   * generated from test_only.mobile_only
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.mobile_only.
   */
  constexpr impl::CounterMetric mobile_only(4797);

  /**
   * generated from test_only.multiproduct
   * A testing uint scalar; not meant to be touched This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.multiproduct.
   */
  constexpr impl::CounterMetric multiproduct(4798);

  /**
   * generated from test_only.one_ping_one_bool
   * One bool for one ping only.
   * This is a test-only metric.
   */
  constexpr impl::BooleanMetric one_ping_one_bool(4799);

  /**
   * generated from test_only.release_optin
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.release_optin.
   */
  constexpr impl::CounterMetric release_optin(4800);

  /**
   * generated from test_only.release_optout
   * A testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.release_optout.
   */
  constexpr impl::CounterMetric release_optout(4801);

  /**
   * generated from test_only.unexpired
   * This is an unexpired testing scalar; not meant to be touched. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.test.unexpired.
   */
  constexpr impl::CounterMetric unexpired(4802);

  /**
   * generated from test_only.what_a_date
   * ...To be writing FOG code. This is a test-only metric.
   */
  constexpr impl::DatetimeMetric what_a_date(4803);

  /**
   * generated from test_only.what_do_you_remember
   * What do they say is the second thing to go?
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, DynamicLabel> what_do_you_remember(4804);

  /**
   * generated from test_only.what_id_it
   * Just a UUID.
   * This is a test-only metric.
   */
  constexpr impl::UuidMetric what_id_it(4805);

  /**
   * generated from test_only.what_time_is_it
   * Adheres to at least two of the top ten fallacies programmers believe
   * about time.
   * This is a test-only metric.
   */
  constexpr impl::TimingDistributionMetric what_time_is_it(4806);

  /**
   * generated from test_only.where_has_the_time_gone
   * Time is different in different places.
   * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> where_has_the_time_gone(4807);
}

namespace test_only_ipc {
  /**
   * generated from test_only.ipc.a_bool
   * This is a test-only metric.
   * Just flagging things.
   */
  constexpr impl::BooleanMetric a_bool(4808);

  /**
   * generated from test_only.ipc.a_counter
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::CounterMetric a_counter(4809);

  /**
   * generated from test_only.ipc.a_counter_for_hgram
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::CounterMetric a_counter_for_hgram(4810);

  /**
   * generated from test_only.ipc.a_custom_dist
   * This is a test-only metric.
   * Just measuring samples.
   */
  constexpr impl::CustomDistributionMetric a_custom_dist(4811);

  /**
   * generated from test_only.ipc.a_date
   * This is a test-only metric.
   * Just putting things on the calendar.
   */
  constexpr impl::DatetimeMetric a_date(4812);

  /**
   * generated from test_only.ipc.a_labeled_counter
   * This is a test-only metric.
   * Just counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> a_labeled_counter(4813);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_categorical
   */
  enum class ALabeledCounterForCategoricalLabel: uint16_t {
    eCommonlabel = 0,
    eLabel4 = 1,
    eLabel5 = 2,
    eLabel6 = 3,
    e__Other__,
  };
  /**
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric, ALabeledCounterForCategoricalLabel> a_labeled_counter_for_categorical(4814);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_hgram
   */
  enum class ALabeledCounterForHgramLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric, ALabeledCounterForHgramLabel> a_labeled_counter_for_hgram(4815);

  /**
   * generated from test_only.ipc.a_labeled_counter_for_keyed_count_hgram
   * This is a test-only metric.
   * Just counting things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> a_labeled_counter_for_keyed_count_hgram(4816);

  /**
   * generated from test_only.ipc.a_memory_dist
   * This is a test-only metric.
   * Just measuring memory.
   */
  constexpr impl::MemoryDistributionMetric a_memory_dist(4817);

  /**
   * generated from test_only.ipc.a_quantity
   * This is a test-only metric.
   * Just quantifying things.
   */
  constexpr impl::QuantityMetric a_quantity(4818);

  /**
   * generated from test_only.ipc.a_string
   * This is a test-only metric.
   * Just setting some strings.
   */
  constexpr impl::StringMetric a_string(4819);

  /**
   * generated from test_only.ipc.a_string_list
   * This is a test-only metric.
   * Just appending some strings.
   */
  constexpr impl::StringListMetric a_string_list(4820);

  /**
   * generated from test_only.ipc.a_text
   * This is a test-only metric.
   * For holding Text data.
   */
  constexpr impl::TextMetric a_text(4821);

  /**
   * generated from test_only.ipc.a_timing_dist
   * This is a test-only metric.
   * Just measuring time.
   */
  constexpr impl::TimingDistributionMetric a_timing_dist(4822);

  /**
   * generated from test_only.ipc.a_url
   * This is a test-only metric.
   * Just setting some Urls.
   */
  constexpr impl::UrlMetric a_url(4823);

  /**
   * generated from test_only.ipc.a_uuid
   * This is a test-only metric.
   * Just recording some unique identifiers.
   */
  constexpr impl::UuidMetric a_uuid(4824);

  /**
   * generated from test_only.ipc.an_event
   */
  struct AnEventExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<nsCString> extra2;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.EmplaceBack(extra2.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(4825);

  /**
   * generated from test_only.ipc.an_external_denominator
   * This is a test-only metric.
   * A denominator not from around here.
   */
  constexpr impl::DenominatorMetric an_external_denominator(4826);

  /**
   * generated from test_only.ipc.an_unordered_bool
   * This is a test-only metric.
   * Just flagging things unorderedly in child processes.
   */
  constexpr impl::BooleanMetric an_unordered_bool(4827);

  /**
   * generated from test_only.ipc.an_unordered_labeled_boolean
   * This is a test-only metric.
   * Just flagging labeled things unorderedly in child processes.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> an_unordered_labeled_boolean(4828);

  /**
   * generated from test_only.ipc.another_labeled_counter
   * This is a test-only metric.
   * Just another metric counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> another_labeled_counter(4829);

  /**
   * generated from test_only.ipc.event_with_extra
   */
  struct EventWithExtraExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<uint32_t> extra2;
    mozilla::Maybe<bool> extra3LongerName;
    mozilla::Maybe<bool> extra4camelcase;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.AppendElement()->AppendInt(extra2.value());
      }
      if (extra3LongerName) {
        extraKeys.AppendElement()->AssignASCII("extra3_longer_name");
        extraValues.AppendElement()->AssignASCII(extra3LongerName.value() ? "true" : "false");
      }
      if (extra4camelcase) {
        extraKeys.AppendElement()->AssignASCII("extra4CamelCase");
        extraValues.AppendElement()->AssignASCII(extra4camelcase.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   */
  constexpr impl::EventMetric<EventWithExtraExtra> event_with_extra(4830);

  /**
   * generated from test_only.ipc.irate
   * This is a test-only metric.
   * A rate that isn't happy about it.
   */
  constexpr impl::RateMetric irate(4831);

  /**
   * generated from test_only.ipc.no_extra_event
   */
  /**
   * This is a test-only metric.
   * Just recording some events without the extra fuss.
   */
  constexpr impl::EventMetric<NoExtraKeys> no_extra_event(4832);

  /**
   * generated from test_only.ipc.rate_with_external_denominator
   * This is a test-only metric.
   * A rate with a denominator that is Out There.
   */
  constexpr impl::NumeratorMetric rate_with_external_denominator(4833);
}

namespace test_only_jog {
  /**
   * generated from test_only.jog.a_counter
   * This is a test-only metric.
   * Just counting things.
   * Tied closely to test_jog_name_collision.
   */
  constexpr impl::CounterMetric a_counter(4834);

  /**
   * generated from test_only.jog.an_event
   */
  struct AnEventExtra {
    mozilla::Maybe<nsCString> extra1;
    mozilla::Maybe<nsCString> extra2;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (extra1) {
        extraKeys.AppendElement()->AssignASCII("extra1");
        extraValues.EmplaceBack(extra1.value());
      }
      if (extra2) {
        extraKeys.AppendElement()->AssignASCII("extra2");
        extraValues.EmplaceBack(extra2.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is a test-only metric.
   * Just recording some events.
   * Tied closely to test_jog_name_collision.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(4835);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGleanTestsTestMetrics_h
