// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanJsXpconnectMetrics_h
#define mozilla_GleanJsXpconnectMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace javascript_gc {
  /**
   * generated from javascript.gc.animation
   * Time spent running JS GC when animating.
   */
  constexpr impl::TimingDistributionMetric animation(3997);

  /**
   * generated from javascript.gc.budget
   * Requested GC slice budget.
   */
  constexpr impl::TimingDistributionMetric budget(3998);

  /**
   * generated from javascript.gc.budget_overrun
   * How long a GC slice ran over its budget.
   */
  constexpr impl::TimingDistributionMetric budget_overrun(3999);

  /**
   * generated from javascript.gc.budget_was_increased
   */
  enum class BudgetWasIncreasedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether the budget was increased due to taking too long or approaching the incremental limit
   */
  constexpr impl::Labeled<impl::CounterMetric, BudgetWasIncreasedLabel> budget_was_increased(4000);

  /**
   * generated from javascript.gc.compact_time
   * The time spent in the compact phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric compact_time(4001);

  /**
   * generated from javascript.gc.effectiveness
   * GC effectiveness, the amount of memory freed divided by main-thread collection time (MB/s)
   */
  constexpr impl::CustomDistributionMetric effectiveness(4002);

  /**
   * generated from javascript.gc.is_zone_gc
   */
  enum class IsZoneGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Is it a zone GC?
   */
  constexpr impl::Labeled<impl::CounterMetric, IsZoneGcLabel> is_zone_gc(4003);

  /**
   * generated from javascript.gc.mark_gray
   * Time spent marking gray GC objects.
   */
  constexpr impl::TimingDistributionMetric mark_gray(4004);

  /**
   * generated from javascript.gc.mark_rate
   * The number of objects marked per ms during GC.
   */
  constexpr impl::CustomDistributionMetric mark_rate(4005);

  /**
   * generated from javascript.gc.mark_roots_time
   * The time spent marking GC roots. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_roots_time(4006);

  /**
   * generated from javascript.gc.mark_time
   * The time spent in the mark phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_time(4007);

  /**
   * generated from javascript.gc.mark_weak
   * Time spent marking GC objects held live through weakmaps.
   */
  constexpr impl::TimingDistributionMetric mark_weak(4008);

  /**
   * generated from javascript.gc.max_pause
   * Longest GC slice in a GC.
   */
  constexpr impl::TimingDistributionMetric max_pause(4009);

  /**
   * generated from javascript.gc.minor_reason
   */
  enum class MinorReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric, MinorReasonLabel> minor_reason(4010);

  /**
   * generated from javascript.gc.minor_reason_long
   */
  enum class MinorReasonLongLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) that caused a long (>1ms) minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric, MinorReasonLongLabel> minor_reason_long(4011);

  /**
   * generated from javascript.gc.minor_time
   * The time taked by a minor (nursery) collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric minor_time(4012);

  /**
   * generated from javascript.gc.mmu_50
   * Minimum percentage of time spent outside GC over any 50ms window.
   */
  constexpr impl::CustomDistributionMetric mmu_50(4013);

  /**
   * generated from javascript.gc.non_incremental
   */
  enum class NonIncrementalLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was the GC non-incremental?
   */
  constexpr impl::Labeled<impl::CounterMetric, NonIncrementalLabel> non_incremental(4014);

  /**
   * generated from javascript.gc.non_incremental_reason
   */
  enum class NonIncrementalReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for performing a non-incremental GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric, NonIncrementalReasonLabel> non_incremental_reason(4015);

  /**
   * generated from javascript.gc.nursery_bytes
   * Size of the GC nursery in bytes.
   */
  constexpr impl::MemoryDistributionMetric nursery_bytes(4016);

  /**
   * generated from javascript.gc.nursery_promotion_rate
   * The percentage of nursery objects that were promoted to the tenured heap.
   */
  constexpr impl::CustomDistributionMetric nursery_promotion_rate(4017);

  /**
   * generated from javascript.gc.parallel_mark_interruptions
   * Number of interruptions/donations per slice during parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_interruptions(4018);

  /**
   * generated from javascript.gc.parallel_mark_speedup
   * Ratio of total helper thread time spent marking to main thread time for parallel marking, scaled by 100.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_speedup(4019);

  /**
   * generated from javascript.gc.parallel_mark_used
   */
  enum class ParallelMarkUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether parallel marking was used for this collection
   */
  constexpr impl::Labeled<impl::CounterMetric, ParallelMarkUsedLabel> parallel_mark_used(4020);

  /**
   * generated from javascript.gc.parallel_mark_utilization
   * Ratio of helper thread time spent marking to total helper thread time for parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_utilization(4021);

  /**
   * generated from javascript.gc.prepare_time
   * The time spent in the preparation phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric prepare_time(4022);

  /**
   * generated from javascript.gc.pretenure_count
   * How many allocation sites were selected for pretenuring by a minor GC
   */
  constexpr impl::CustomDistributionMetric pretenure_count(4023);

  /**
   * generated from javascript.gc.reason
   */
  enum class ReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eSharedMemoryLimit = 12,
    eEagerNurseryCollection = 13,
    eBgTaskFinished = 14,
    eAbortGc = 15,
    eFullWholeCellBuffer = 16,
    eFullGenericBuffer = 17,
    eFullValueBuffer = 18,
    eFullCellPtrObjBuffer = 19,
    eFullSlotBuffer = 20,
    eFullShapeBuffer = 21,
    eTooMuchWasmMemory = 22,
    eDisableGenerationalGc = 23,
    eFinishGc = 24,
    ePrepareForTracing = 25,
    eFullWasmAnyrefBuffer = 26,
    eFullCellPtrStrBuffer = 27,
    eTooMuchJitCode = 28,
    eFullCellPtrBigintBuffer = 29,
    eNurseryTrailers = 30,
    eNurseryMallocBuffers = 31,
    eDomWindowUtils = 32,
    eComponentUtils = 33,
    eMemPressure = 34,
    eCcFinished = 35,
    eCcForced = 36,
    eLoadEnd = 37,
    eUnused3 = 38,
    ePageHide = 39,
    eNsjscontextDestroy = 40,
    eWorkerShutdown = 41,
    eSetDocShell = 42,
    eDomUtils = 43,
    eDomIpc = 44,
    eDomWorker = 45,
    eInterSliceGc = 46,
    eUnused1 = 47,
    eFullGcTimer = 48,
    eShutdownCc = 49,
    eUnused2 = 50,
    eUserInactive = 51,
    eXpconnectShutdown = 52,
    eDocshell = 53,
    eHtmlParser = 54,
    eDomTestutils = 55,
    ePrepareForPageload = 56,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a GC
   */
  constexpr impl::Labeled<impl::CounterMetric, ReasonLabel> reason(4024);

  /**
   * generated from javascript.gc.reset
   */
  enum class ResetLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was an incremental GC canceled?
   */
  constexpr impl::Labeled<impl::CounterMetric, ResetLabel> reset(4025);

  /**
   * generated from javascript.gc.reset_reason
   */
  enum class ResetReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for cancelling an ongoing GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric, ResetReasonLabel> reset_reason(4026);

  /**
   * generated from javascript.gc.slice_count
   * The number of slices in an incremental GC for the main runtime.
   */
  constexpr impl::CustomDistributionMetric slice_count(4027);

  /**
   * generated from javascript.gc.slice_time
   * The time spent running a GC slice. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric slice_time(4028);

  /**
   * generated from javascript.gc.slice_was_long
   */
  enum class SliceWasLongLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a GC slice took 1.5 times or 5ms more than its budget
   */
  constexpr impl::Labeled<impl::CounterMetric, SliceWasLongLabel> slice_was_long(4029);

  /**
   * generated from javascript.gc.slow_phase
   */
  enum class SlowPhaseLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepJitScripts = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eSweepPropMap = 48,
    eFinalizeEnd = 49,
    eDestroy = 50,
    eFindDeadCompartments = 51,
    eSweep = 52,
    eCompactMove = 53,
    eCompactUpdateCells = 54,
    eCompactUpdate = 55,
    eCompact = 56,
    eDecommit = 57,
    eGcEnd = 58,
    eMinorGc = 59,
    eEvictNursery = 60,
    eTraceHeap = 61,
    e__Other__,
  };
  /**
   * The longest phase in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric, SlowPhaseLabel> slow_phase(4030);

  /**
   * generated from javascript.gc.slow_task
   */
  enum class SlowTaskLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepJitScripts = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eSweepPropMap = 48,
    eFinalizeEnd = 49,
    eDestroy = 50,
    eFindDeadCompartments = 51,
    eSweep = 52,
    eCompactMove = 53,
    eCompactUpdateCells = 54,
    eCompactUpdate = 55,
    eCompact = 56,
    eDecommit = 57,
    eGcEnd = 58,
    eMinorGc = 59,
    eEvictNursery = 60,
    eTraceHeap = 61,
    e__Other__,
  };
  /**
   * The longest parallel task in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric, SlowTaskLabel> slow_task(4031);

  /**
   * generated from javascript.gc.sweep_time
   * The time spent in the sweep phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric sweep_time(4032);

  /**
   * generated from javascript.gc.task_start_delay
   * Delay between queuing a GC task and the task starting.
   */
  constexpr impl::TimingDistributionMetric task_start_delay(4033);

  /**
   * generated from javascript.gc.tenured_survival_rate
   * The percentage of tenured GC things that survived a collection.
   */
  constexpr impl::CustomDistributionMetric tenured_survival_rate(4034);

  /**
   * generated from javascript.gc.time_between
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between(4035);

  /**
   * generated from javascript.gc.time_between_slices
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between_slices(4036);

  /**
   * generated from javascript.gc.total_time
   * The total time taken by a major collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_time(4037);

  /**
   * generated from javascript.gc.zone_count
   * Total number of GC zones
   */
  constexpr impl::CustomDistributionMetric zone_count(4038);

  /**
   * generated from javascript.gc.zones_collected
   * Number of zones collected in a zone GC.
   */
  constexpr impl::CustomDistributionMetric zones_collected(4039);
}

namespace javascript_ion {
  /**
   * generated from javascript.ion.compile_time
   * Time in microseconds of an Ion compilation.
   */
  constexpr impl::TimingDistributionMetric compile_time(4040);
}

namespace script_preloader {
  /**
   * generated from script.preloader.mainthread_recompile
   * How many times we ended up recompiling a script from the script preloader on the main thread. This metric was generated to correspond to the Legacy Telemetry scalar script.preloader.mainthread_recompile.
   */
  constexpr impl::CounterMetric mainthread_recompile(4041);

  /**
   * generated from script.preloader.requests
   */
  enum class RequestsLabel: uint16_t {
    eHit = 0,
    eHitchild = 1,
    eMiss = 2,
    e__Other__,
  };
  /**
   * Record hits and misses to the script preloader, with categories.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram SCRIPT_PRELOADER_REQUESTS.
   */
  constexpr impl::Labeled<impl::CounterMetric, RequestsLabel> requests(4042);

  /**
   * generated from script.preloader.wait_time
   * Time spent waiting for off-thread compiles in the script preloader.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SCRIPT_PRELOADER_WAIT_TIME.
   */
  constexpr impl::TimingDistributionMetric wait_time(4043);
}

namespace slow_script_warning {
  /**
   * generated from slow_script_warning.notify_delay
   * The difference between the js slow script timeout for content set in prefs and the actual time we waited before displaying the notification (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SLOW_SCRIPT_NOTIFY_DELAY.
   */
  constexpr impl::TimingDistributionMetric notify_delay(4044);

  /**
   * generated from slow_script_warning.shown_browser
   */
  struct ShownBrowserExtra {
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<nsCString> uriType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#browser.
   */
  constexpr impl::EventMetric<ShownBrowserExtra> shown_browser(4045);

  /**
   * generated from slow_script_warning.shown_content
   */
  struct ShownContentExtra {
    mozilla::Maybe<nsCString> endReason;
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<uint32_t> nTabDeselect;
    mozilla::Maybe<nsCString> uptime;
    mozilla::Maybe<nsCString> uriType;
    mozilla::Maybe<uint32_t> waitCount;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (endReason) {
        extraKeys.AppendElement()->AssignASCII("end_reason");
        extraValues.EmplaceBack(endReason.value());
      }
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (nTabDeselect) {
        extraKeys.AppendElement()->AssignASCII("n_tab_deselect");
        extraValues.AppendElement()->AppendInt(nTabDeselect.value());
      }
      if (uptime) {
        extraKeys.AppendElement()->AssignASCII("uptime");
        extraValues.EmplaceBack(uptime.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      if (waitCount) {
        extraKeys.AppendElement()->AssignASCII("wait_count");
        extraValues.AppendElement()->AppendInt(waitCount.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#content.
   */
  constexpr impl::EventMetric<ShownContentExtra> shown_content(4046);
}

} // namespace mozilla::glean

#endif // mozilla_GleanJsXpconnectMetrics_h
