// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanMlMetrics_h
#define mozilla_GleanMlMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace firefox_ai_runtime {
  /**
   * generated from firefox.ai.runtime.engine_creation_failure
   */
  struct EngineCreationFailureExtra {
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> taskname;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (taskname) {
        extraKeys.AppendElement()->AssignASCII("taskName");
        extraValues.EmplaceBack(taskname.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An inference engine has failed to create
   */
  constexpr impl::EventMetric<EngineCreationFailureExtra> engine_creation_failure(4860);

  /**
   * generated from firefox.ai.runtime.engine_creation_success
   */
  enum class EngineCreationSuccessLabel: uint16_t {
    eAutofillMl = 0,
    ePdfjs = 1,
    eMlSuggestIntent = 2,
    eMlSuggestNer = 3,
    eAboutInference = 4,
    eWebextension = 5,
    eWllamapreview = 6,
    eDefaultEngine = 7,
    eSmartTabEmbeddingEngine = 8,
    eSmartTabTopicEngine = 9,
    e__Other__,
  };
  /**
   * An inference engine was created
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, EngineCreationSuccessLabel> engine_creation_success(4861);

  /**
   * generated from firefox.ai.runtime.model_deletion
   */
  struct ModelDeletionExtra {
    mozilla::Maybe<nsCString> deletedby;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> modelrevision;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (deletedby) {
        extraKeys.AppendElement()->AssignASCII("deletedBy");
        extraValues.EmplaceBack(deletedby.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (modelrevision) {
        extraKeys.AppendElement()->AssignASCII("modelRevision");
        extraValues.EmplaceBack(modelrevision.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A model is deleted
   */
  constexpr impl::EventMetric<ModelDeletionExtra> model_deletion(4862);

  /**
   * generated from firefox.ai.runtime.model_download
   */
  struct ModelDownloadExtra {
    mozilla::Maybe<uint32_t> duration;
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> modeldownloadid;
    mozilla::Maybe<nsCString> modelid;
    mozilla::Maybe<nsCString> modelrevision;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<uint32_t> when;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.AppendElement()->AppendInt(duration.value());
      }
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (modeldownloadid) {
        extraKeys.AppendElement()->AssignASCII("modelDownloadId");
        extraValues.EmplaceBack(modeldownloadid.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      if (modelrevision) {
        extraKeys.AppendElement()->AssignASCII("modelRevision");
        extraValues.EmplaceBack(modelrevision.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (when) {
        extraKeys.AppendElement()->AssignASCII("when");
        extraValues.AppendElement()->AppendInt(when.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A model is downloaded
   */
  constexpr impl::EventMetric<ModelDownloadExtra> model_download(4863);

  /**
   * generated from firefox.ai.runtime.run_inference_failure
   */
  struct RunInferenceFailureExtra {
    mozilla::Maybe<nsCString> engineid;
    mozilla::Maybe<nsCString> featureid;
    mozilla::Maybe<nsCString> modelid;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (engineid) {
        extraKeys.AppendElement()->AssignASCII("engineId");
        extraValues.EmplaceBack(engineid.value());
      }
      if (featureid) {
        extraKeys.AppendElement()->AssignASCII("featureId");
        extraValues.EmplaceBack(featureid.value());
      }
      if (modelid) {
        extraKeys.AppendElement()->AssignASCII("modelId");
        extraValues.EmplaceBack(modelid.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An inference run has failed
   */
  constexpr impl::EventMetric<RunInferenceFailureExtra> run_inference_failure(4864);

  /**
   * generated from firefox.ai.runtime.run_inference_success
   */
  enum class RunInferenceSuccessLabel: uint16_t {
    eAutofillMl = 0,
    ePdfjs = 1,
    eMlSuggestIntent = 2,
    eMlSuggestNer = 3,
    eAboutInference = 4,
    eWebextension = 5,
    eWllamapreview = 6,
    eDefaultEngine = 7,
    eSmartTabEmbeddingEngine = 8,
    eSmartTabTopicEngine = 9,
    e__Other__,
  };
  /**
   * An inference engine was created
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, RunInferenceSuccessLabel> run_inference_success(4865);
}

} // namespace mozilla::glean

#endif // mozilla_GleanMlMetrics_h
