// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkDnsMetrics_h
#define mozilla_GleanNetwerkDnsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace dns {
  /**
   * generated from dns.blocklist_count
   * The number of unusable addresses reported for each record
   * This metric was generated to correspond to the Legacy Telemetry linear histogram DNS_BLACKLIST_COUNT.
   */
  constexpr impl::CustomDistributionMetric blocklist_count(4164);

  /**
   * generated from dns.by_type_cleanup_age
   * DNS Cache Entry Age for by-type queries at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric by_type_cleanup_age(4165);

  /**
   * generated from dns.by_type_failed_lookup_time
   * Time for a completed by-type resolution that has a negative answer (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_FAILED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_failed_lookup_time(4166);

  /**
   * generated from dns.by_type_premature_eviction
   * DNS Cache Entry Age for by-type queries at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric by_type_premature_eviction(4167);

  /**
   * generated from dns.by_type_succeeded_lookup_time
   * Time for a completed by-type resolution that succeeded (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_BY_TYPE_SUCCEEDED_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric by_type_succeeded_lookup_time(4168);

  /**
   * generated from dns.cleanup_age
   * DNS Cache Entry Age at Removal Time (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_CLEANUP_AGE.
   */
  constexpr impl::TimingDistributionMetric cleanup_age(4169);

  /**
   * generated from dns.grace_period_renewal
   */
  enum class GracePeriodRenewalLabel: uint16_t {
    eDifferentRecord = 0,
    eSameRecord = 1,
    e__Other__,
  };
  /**
   * Counts the amount of times that we get a record that is different (or identical) from the one that was used from the cache after a grace period induced renewal.
   * This is to keep track of the amount of possible breakage that is occuring due to the grace period and useful for evaluating experiments increasing the grace period.
   */
  constexpr impl::Labeled<impl::CounterMetric, GracePeriodRenewalLabel> grace_period_renewal(4170);

  /**
   * generated from dns.lookup_algorithm
   */
  enum class LookupAlgorithmLabel: uint16_t {
    eNativeonly = 0,
    eTrrrace = 1,
    eTrrfirst = 2,
    eTrronly = 3,
    eTrrshadow = 4,
    e__Other__,
  };
  /**
   * DNS: lookup algorithm
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DNS_LOOKUP_ALGORITHM.
   */
  constexpr impl::Labeled<impl::CounterMetric, LookupAlgorithmLabel> lookup_algorithm(4171);

  /**
   * generated from dns.lookup_method
   * DNS Lookup Type (hit, renewal, negative-hit, literal, overflow, network-first, network-shared)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNS_LOOKUP_METHOD2.
   */
  constexpr impl::CustomDistributionMetric lookup_method(4172);

  /**
   * generated from dns.native_lookup_time
   * Time for a completed native name resolution (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_LOOKUP_TIME.
   */
  constexpr impl::TimingDistributionMetric native_lookup_time(4173);

  /**
   * generated from dns.native_queuing
   * Time in resolve queue waiting to getaddrinfo (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_NATIVE_QUEUING.
   */
  constexpr impl::TimingDistributionMetric native_queuing(4174);

  /**
   * generated from dns.premature_eviction
   * DNS Cache Entry Age at Removal Time of non-expired entries (minutes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_PREMATURE_EVICTION.
   */
  constexpr impl::TimingDistributionMetric premature_eviction(4175);

  /**
   * generated from dns.trr_attempt_count
   * Number of times we attempted TRR for a successful lookup in TRR-first mode. Keyed by provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_ATTEMPT_COUNT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_attempt_count(4176);

  /**
   * generated from dns.trr_lookup_time
   * Time for a completed TRR resolution (msec); Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_LOOKUP_TIME3.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> trr_lookup_time(4177);

  /**
   * generated from dns.trr_processing_time
   * Time from the last received byte of the response until we have notified the consumer with a DNS record (msec)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DNS_TRR_PROCESSING_TIME.
   */
  constexpr impl::TimingDistributionMetric trr_processing_time(4178);

  /**
   * generated from dns.trr_relevant_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_failed(4179);

  /**
   * generated from dns.trr_relevant_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_native_success(4180);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first(4181);

  /**
   * generated from dns.trr_relevant_skip_reason_trr_first_type_rec
   * When in TRR-first mode, it lists the reason we may have skipped TRR for HTTPS RR, keyed by the provider. Does not include requests that intentionally skip TRR.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_RELEVANT_SKIP_REASON_TRR_FIRST_TYPE_REC.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_relevant_skip_reason_trr_first_type_rec(4182);

  /**
   * generated from dns.trr_skip_reason_native_failed
   * When in TRR-first mode, if TRR was skipped and native failed, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_failed(4183);

  /**
   * generated from dns.trr_skip_reason_native_success
   * When in TRR-first mode, if TRR was skipped and native succeeded, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_NATIVE_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_native_success(4184);

  /**
   * generated from dns.trr_skip_reason_retry_failed
   * When in TRR-first mode, if TRR failed once and retried unsuccessfully, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_FAILED.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_failed(4185);

  /**
   * generated from dns.trr_skip_reason_retry_success
   * When in TRR-first mode, if TRR failed once and was successfully retried, it lists the reason for the first failure, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_RETRY_SUCCESS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_retry_success(4186);

  /**
   * generated from dns.trr_skip_reason_strict_mode
   * When in TRR-first mode, it lists the reason we may have skipped TRR. The key is like `<provider>|<skip reason of first attempt>` or just `<provider>` used when there was no second attempt.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_STRICT_MODE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_strict_mode(4187);

  /**
   * generated from dns.trr_skip_reason_trr_first
   * When in TRR-first mode, it lists the reason we may have skipped TRR, keyed by the provider.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TRR_SKIP_REASON_TRR_FIRST2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> trr_skip_reason_trr_first(4188);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkDnsMetrics_h
