// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkProtocolHttpMetrics_h
#define mozilla_GleanNetwerkProtocolHttpMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace networking {
  /**
   * generated from networking.data_transferred_v3_kb
   * How many KB of HTTP data transferred by type, there are some categories separated by keys based on 5 parameters:
   *   1. normal browsing or private browsing
   *   2. system principal or not
   *   3. first party or third party
   *   4. class of service (Leader/Background/Others)
   *   5. tracking classification (Basic/Content/FingerprintingContent)
   * 
   * Available keys are:
   *   "Y0_N1Sys",
   *   "Y1_N1",
   *   "Y2_N3Oth",
   *   "Y3_N3BasicLead",
   *   "Y4_N3BasicBg",
   *   "Y5_N3BasicOth",
   *   "Y6_N3ContentLead",
   *   "Y7_N3ContentBg",
   *   "Y8_N3ContentOth",
   *   "Y9_N3FpLead",
   *   "Y10_N3FpBg",
   *   "Y11_N3FpOth",
   *   "Y12_P1Sys",
   *   "Y13_P1",
   *   "Y14_P3Oth",
   *   "Y15_P3BasicLead",
   *   "Y16_P3BasicBg",
   *   "Y17_P3BasicOth",
   *   "Y18_P3ContentLead",
   *   "Y19_P3ContentBg",
   *   "Y20_P3ContentOth",
   *   "Y21_P3FpLead",
   *   "Y22_P3FpBg",
   *   "Y23_P3FpOth"
   * 
   * This metric was generated to correspond to the Legacy Telemetry scalar networking.data_transferred_v3_kb.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> data_transferred_v3_kb(190);

  /**
   * generated from networking.http3_enabled
   * True if HTTP3 is enabled at the start of a session. This metric was generated to correspond to the Legacy Telemetry scalar networking.http3_enabled.
   */
  constexpr impl::BooleanMetric http3_enabled(191);

  /**
   * generated from networking.https_record_state
   */
  enum class HttpsRecordStateLabel: uint16_t {
    eInvalid = 0,
    eSucceeded = 1,
    eUnmatchedCname = 2,
    eAllExcluded = 3,
    eNoDefaultAlpn = 4,
    eOthers = 5,
    e__Other__,
  };
  /**
   * Gather the outcome of checking if a HTTPS record can be used: - "invalid" - "succeeded" - "unmatched_cname" - "all_excluded" - "no_default_alpn" - "others"
   */
  constexpr impl::Labeled<impl::CounterMetric, HttpsRecordStateLabel> https_record_state(192);

  /**
   * generated from networking.https_rr_prefs_usage
   * A bitfield representation for the usage of HTTPS RR prefs. bit 0: network.dns.upgrade_with_https_rr is enabled or not. bit 1: network.dns.use_https_rr_as_altsvc is enabled or not. bit 2: network.dns.echconfig.enabled is enabled or not. This metric was generated to correspond to the Legacy Telemetry scalar networking.https_rr_prefs_usage.
   */
  constexpr impl::QuantityMetric https_rr_prefs_usage(193);

  /**
   * generated from networking.trr_connection_cycle_count
   * Number of times we cycled the TRR connection during a subsession. Keyed by TRR provider URL. This metric was generated to correspond to the Legacy Telemetry scalar networking.trr_connection_cycle_count.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> trr_connection_cycle_count(194);
}

namespace glam_experiment {
  /**
   * generated from glam_experiment.sub_complete_load_net
   * Duplicate of: `network.sub_complete_load_net`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::TimingDistributionMetric sub_complete_load_net(301);
}

namespace network {
  /**
   * generated from network.alpn_mismatch_count
   * Counts the number of times we encountered a mismatched ALPN token and needed to reset the connection. Keyed by the negotiated NPN.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> alpn_mismatch_count(4095);

  /**
   * generated from network.async_open_child_to_transaction_pending_exp
   * The time spent from HttpChannelChild::AsyncOpen to adding the transactionto the nsHttpConnectionMgr, in milliseconds, keyed by the classOfService flags
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_ASYNC_OPEN_CHILD_TO_TRANSACTION_PENDING_EXP_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> async_open_child_to_transaction_pending_exp(4096);

  /**
   * generated from network.back_pressure_suspension_cp_type
   * Collect the content policy when the resource is non-local and suspended by back pressure (0-44 from nsContentPolicyType in nsIContentPolicy.idl).
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_BACK_PRESSURE_SUSPENSION_CP_TYPE.
   */
  constexpr impl::CustomDistributionMetric back_pressure_suspension_cp_type(4097);

  /**
   * generated from network.back_pressure_suspension_delay_time
   * The delay caused by the e10s back pressure suspension(ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_BACK_PRESSURE_SUSPENSION_DELAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric back_pressure_suspension_delay_time(4098);

  /**
   * generated from network.back_pressure_suspension_rate
   */
  enum class BackPressureSuspensionRateLabel: uint16_t {
    eSuspended = 0,
    eNotsuspended = 1,
    eSuspendedlocal = 2,
    eNotsuspendedlocal = 3,
    e__Other__,
  };
  /**
   * Collect whether the resource is suspended by back pressure. And split by local-ness.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram NETWORK_BACK_PRESSURE_SUSPENSION_RATE_V2.
   */
  constexpr impl::Labeled<impl::CounterMetric, BackPressureSuspensionRateLabel> back_pressure_suspension_rate(4099);

  /**
   * generated from network.byte_range_request
   */
  enum class ByteRangeRequestLabel: uint16_t {
    eCacheable = 0,
    eNotCacheable = 1,
    e__Other__,
  };
  /**
   * Counts of cacheable/non-cacheable byte-range requests
   */
  constexpr impl::Labeled<impl::CounterMetric, ByteRangeRequestLabel> byte_range_request(4100);

  /**
   * generated from network.cache_hit_miss_stat_per_cache_size
   * Hit/Miss count split by cache size in file count Hit 0-5000, Miss 0-5000, Hit 5001-10000, ...
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> cache_hit_miss_stat_per_cache_size(4101);

  /**
   * generated from network.cache_hit_rate_per_cache_size
   * Hit rate for a specific cache size in file count. The hit rate is split into 20 buckets. The key is the cacheSize (20 buckets) and the value is between 0 and 100.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> cache_hit_rate_per_cache_size(4102);

  /**
   * generated from network.cache_hit_time
   * Time to open existing cache entry file. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric cache_hit_time(4103);

  /**
   * generated from network.cache_miss_time
   * Time spent to find out a cache entry file is missing. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric cache_miss_time(4104);

  /**
   * generated from network.cache_read_time
   * In the HTTP page channel, time from connection cache read start to cache read end. Corresponds to Legacy histogram HTTP_PAGE_CACHE_READ_TIME_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric cache_read_time(4105);

  /**
   * generated from network.complete_load
   * In the HTTP page channel, time from connection open to complete load (cache read end/until the last byte received) Corresponds to Legacy histogram HTTP_PAGE_COMPLETE_LOAD_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric complete_load(4106);

  /**
   * generated from network.complete_load_cached
   * In the HTTP page channel, time from connection open to cache read end. Corresponds to Legacy histogram HTTP_PAGE_COMPLETE_LOAD_CACHED_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric complete_load_cached(4107);

  /**
   * generated from network.complete_load_net
   * In the HTTP page channel, time from connection open to the last byte received. Corresponds to Legacy histogram HTTP_PAGE_COMPLETE_LOAD_NET_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric complete_load_net(4108);

  /**
   * generated from network.cors_authorization_header
   */
  enum class CorsAuthorizationHeaderLabel: uint16_t {
    eAllowed = 0,
    eDisallowed = 1,
    eCoveredByWildcard = 2,
    e__Other__,
  };
  /**
   * Count how many times we see `Authorization` header in `Access-Control-Request-Headers` header and the possible outcomes.
   */
  constexpr impl::Labeled<impl::CounterMetric, CorsAuthorizationHeaderLabel> cors_authorization_header(4109);

  /**
   * generated from network.dns_end
   * In the HTTP page channel, time from the DNS request being issued to the response. Corresponds to Legacy histogram HTTP_PAGE_DNS_LOOKUP_TIME in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric dns_end(4110);

  /**
   * generated from network.dns_end_to_connect_start_exp
   * The time spent from dns resolution to connect start, in milliseconds, keyed by protocol version and the classOfService flags
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_DNS_END_TO_CONNECT_START_EXP_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> dns_end_to_connect_start_exp(4111);

  /**
   * generated from network.dns_start
   * In the HTTP page channel, time from connection open to the DNS request being issued. Corresponds to Legacy histogram HTTP_PAGE_DNS_ISSUE_TIME in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric dns_start(4112);

  /**
   * generated from network.first_from_cache
   * In the HTTP page channel, time from connection open to cache read start. Corresponds to Legacy histogram HTTP_PAGE_OPEN_TO_FIRST_FROM_CACHE_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric first_from_cache(4113);

  /**
   * generated from network.first_sent_to_last_received
   * In the HTTP page channel, time from first byte of request sent to the last byte received. Corresponds to Legacy histogram HTTP_PAGE_FIRST_SENT_TO_LAST_RECEIVED in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric first_sent_to_last_received(4114);

  /**
   * generated from network.font_download_end
   * Time after navigationStart that all webfont downloads are completed. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric font_download_end(4115);

  /**
   * generated from network.http3_complete_load
   */
  enum class Http3CompleteLoadLabel: uint16_t {
    eUsesHttp3Page = 0,
    eUsesHttp3Sub = 1,
    eSupportsHttp3Page = 2,
    eSupportsHttp3Sub = 3,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: uses_http3_page, uses_http3_sub, supports_http3_page, supports_http3_sub), overall load time
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3CompleteLoadLabel> http3_complete_load(4116);

  /**
   * generated from network.http3_first_sent_to_last_received
   */
  enum class Http3FirstSentToLastReceivedLabel: uint16_t {
    eUsesHttp3Page = 0,
    eUsesHttp3Sub = 1,
    eSupportsHttp3Page = 2,
    eSupportsHttp3Sub = 3,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: uses_http3_page, uses_http3_sub, supports_http3_page, supports_http3_sub), time from first byte of request sent to last byte of response received
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3FirstSentToLastReceivedLabel> http3_first_sent_to_last_received(4117);

  /**
   * generated from network.http3_open_to_first_received
   */
  enum class Http3OpenToFirstReceivedLabel: uint16_t {
    eUsesHttp3Page = 0,
    eUsesHttp3Sub = 1,
    eSupportsHttp3Page = 2,
    eSupportsHttp3Sub = 3,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: uses_http3_page, uses_http3_sub, supports_http3_page, supports_http3_sub), time from open to first byte of reply received
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3OpenToFirstReceivedLabel> http3_open_to_first_received(4118);

  /**
   * generated from network.http3_open_to_first_sent
   */
  enum class Http3OpenToFirstSentLabel: uint16_t {
    eUsesHttp3Page = 0,
    eUsesHttp3Sub = 1,
    eSupportsHttp3Page = 2,
    eSupportsHttp3Sub = 3,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: uses_http3_page, uses_http3_sub, supports_http3_page, supports_http3_sub), time from open to first byte of request
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3OpenToFirstSentLabel> http3_open_to_first_sent(4119);

  /**
   * generated from network.http3_tls_handshake
   */
  enum class Http3TlsHandshakeLabel: uint16_t {
    eUsesHttp3Page = 0,
    eUsesHttp3Sub = 1,
    eSupportsHttp3Page = 2,
    eSupportsHttp3Sub = 3,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: uses_http3_page, uses_http3_sub, supports_http3_page, supports_http3_sub), time from secure connection start (after TCP SYN) to ready for HTTP
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3TlsHandshakeLabel> http3_tls_handshake(4120);

  /**
   * generated from network.http_fetch_duration
   */
  enum class HttpFetchDurationLabel: uint16_t {
    eH3Cloudflare = 0,
    eH3Others = 1,
    eH2Cloudflare = 2,
    eH2Others = 3,
    eH1Cloudflare = 4,
    eH1Others = 5,
    e__Other__,
  };
  /**
   * The time between requestStart and responseEnd, keyed by the server header
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, HttpFetchDurationLabel> http_fetch_duration(4121);

  /**
   * generated from network.http_revalidation
   * In the HTTP page channel, time for positive cache validation Corresponds to Legacy histogram HTTP_PAGE_REVALIDATION in Desktop.
   */
  constexpr impl::TimingDistributionMetric http_revalidation(4122);

  /**
   * generated from network.open_to_first_received
   * In the HTTP subitem channel,time from connection open to the first byte received. Corresponds to Legacy histogram HTTP_PAGE_OPEN_TO_FIRST_RECEIVED in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric open_to_first_received(4123);

  /**
   * generated from network.open_to_first_sent
   * In the HTTP page channel, time from connection open to the first byte of requst sent. Corresponds to Legacy histogram HTTP_PAGE_OPEN_TO_FIRST_SENT in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric open_to_first_sent(4124);

  /**
   * generated from network.page_load_size
   */
  enum class PageLoadSizeLabel: uint16_t {
    ePage = 0,
    eSubresources = 1,
    e__Other__,
  };
  /**
   * The size of the HTTP response for a document load, keyed by the page itself or the sum of subresources.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, PageLoadSizeLabel> page_load_size(4125);

  /**
   * generated from network.race_cache_bandwidth_not_race
   * Amount of bytes received when we decide not to race cache with network.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RACE_CACHE_BANDWIDTH_NOT_RACE.
   */
  constexpr impl::MemoryDistributionMetric race_cache_bandwidth_not_race(4126);

  /**
   * generated from network.race_cache_bandwidth_race_cache_win
   * Amount of bytes received when we decide to race cache with network and cache wins.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RACE_CACHE_BANDWIDTH_RACE_CACHE_WIN.
   */
  constexpr impl::MemoryDistributionMetric race_cache_bandwidth_race_cache_win(4127);

  /**
   * generated from network.race_cache_bandwidth_race_network_win
   * Amount of bytes received when we decide to race cache with network and network wins.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RACE_CACHE_BANDWIDTH_RACE_NETWORK_WIN.
   */
  constexpr impl::MemoryDistributionMetric race_cache_bandwidth_race_network_win(4128);

  /**
   * generated from network.race_cache_validation
   */
  enum class RaceCacheValidationLabel: uint16_t {
    eNotsent = 0,
    eCachedcontentused = 1,
    eCachedcontentnotused = 2,
    e__Other__,
  };
  /**
   * Stats for validation requests when cache won the race.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram NETWORK_RACE_CACHE_VALIDATION.
   */
  constexpr impl::Labeled<impl::CounterMetric, RaceCacheValidationLabel> race_cache_validation(4129);

  /**
   * generated from network.race_cache_with_network_ocec_on_start_diff
   * Time in milliseconds between onStartRequest from the cache and onCacheEntryCheck. Report only when net wins and OCEC is before onStartRequest from net.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram NETWORK_RACE_CACHE_WITH_NETWORK_OCEC_ON_START_DIFF.
   */
  constexpr impl::TimingDistributionMetric race_cache_with_network_ocec_on_start_diff(4130);

  /**
   * generated from network.race_cache_with_network_saved_time
   * Time in milliseconds that we saved when we race cache with network.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RACE_CACHE_WITH_NETWORK_SAVED_TIME.
   */
  constexpr impl::TimingDistributionMetric race_cache_with_network_saved_time(4131);

  /**
   * generated from network.race_cache_with_network_usage
   */
  enum class RaceCacheWithNetworkUsageLabel: uint16_t {
    eNetworknorace = 0,
    eCachenorace = 1,
    eNetworkrace = 2,
    eCacherace = 3,
    eNetworkdelayedrace = 4,
    eCachedelayedrace = 5,
    e__Other__,
  };
  /**
   * Whether we raced network with the cache.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram NETWORK_RACE_CACHE_WITH_NETWORK_USAGE_2.
   */
  constexpr impl::Labeled<impl::CounterMetric, RaceCacheWithNetworkUsageLabel> race_cache_with_network_usage(4132);

  /**
   * generated from network.response_end_parent_to_content
   * The time spent relaying response completion from the socket thread of the parent process to the content process, in milliseconds, keyed by the classOfService flags
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RESPONSE_END_PARENT_TO_CONTENT_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> response_end_parent_to_content(4133);

  /**
   * generated from network.response_start_parent_to_content_exp
   * The time spent relaying response start from the socket thread of the parent process to the content process, in milliseconds, keyed by the classOfService flags
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_RESPONSE_START_PARENT_TO_CONTENT_EXP_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> response_start_parent_to_content_exp(4134);

  /**
   * generated from network.sub_cache_read_time
   * In the HTTP subitem channel, time from connection cache read start to cache read end. Corresponds to Legacy histogram HTTP_SUB_CACHE_READ_TIME_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_cache_read_time(4135);

  /**
   * generated from network.sub_complete_load
   * In the HTTP subitem channel, time from connection open to complete load (cache read end/until the last byte received) Corresponds to Legacy histogram HTTP_SUB_COMPLETE_LOAD_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_complete_load(4136);

  /**
   * generated from network.sub_complete_load_cached
   * In the HTTP subitem channel, time from connection open to cache read end. Corresponds to Legacy histogram HTTP_SUB_COMPLETE_LOAD_CACHED_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_complete_load_cached(4137);

  /**
   * generated from network.sub_complete_load_net
   * In the HTTP subitem channel, time from connection open to the last byte received. Corresponds to Legacy histogram HTTP_SUB_COMPLETE_LOAD_NET_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_complete_load_net(4138);

  /**
   * generated from network.sub_dns_end
   * In the HTTP subitem channel, time from the DNS request being issued to the response. Corresponds to Legacy histogram HTTP_SUB_DNS_LOOKUP_TIME in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_dns_end(4139);

  /**
   * generated from network.sub_dns_start
   * In the HTTP subitem channel, time from connection open to the DNS request being issued. Corresponds to Legacy histogram HTTP_SUB_DNS_ISSUE_TIME in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_dns_start(4140);

  /**
   * generated from network.sub_first_from_cache
   * In the HTTP subitem channel, time from connection open to cache read start. Corresponds to Legacy histogram HTTP_SUB_OPEN_TO_FIRST_FROM_CACHE_V2 in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_first_from_cache(4141);

  /**
   * generated from network.sub_first_sent_to_last_received
   * In the HTTP subitem channel, time from first byte of request sent to the last byte received. Corresponds to Legacy histogram HTTP_SUB_FIRST_SENT_TO_LAST_RECEIVED in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_first_sent_to_last_received(4142);

  /**
   * generated from network.sub_http_revalidation
   * In the HTTP subitem channel, time for positive cache validation Corresponds to Legacy histogram HTTP_SUB_REVALIDATION in Desktop.
   */
  constexpr impl::TimingDistributionMetric sub_http_revalidation(4143);

  /**
   * generated from network.sub_open_to_first_received
   * In the HTTP subitem channel, time from connection open to the first byte received. Corresponds to Legacy histogram HTTP_SUB_OPEN_TO_FIRST_RECEIVED in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_open_to_first_received(4144);

  /**
   * generated from network.sub_open_to_first_sent
   * In the HTTP subitem channel, time from connection open to the first byte of requst sent. Corresponds to Legacy histogram HTTP_SUB_OPEN_TO_FIRST_SENT in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_open_to_first_sent(4145);

  /**
   * generated from network.sub_tcp_connection
   * In the HTTP subitem channel, time from the TCP SYN packet is received to the connection is established and ready for HTTP. Corresponds to Legacy histogram HTTP_SUB_TCP_CONNECTION_2 in Desktop (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_tcp_connection(4146);

  /**
   * generated from network.sub_tls_handshake
   * In the HTTP subitem channel, time from after the TCP SYN packet is received to the secure connection is established and ready for HTTP. Corresponds to Legacy histogram HTTP_SUB_TLS_HANDSHAKE in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric sub_tls_handshake(4147);

  /**
   * generated from network.sup_http3_tcp_connection
   */
  enum class SupHttp3TcpConnectionLabel: uint16_t {
    eSupportsHttp3Page = 0,
    eSupportsHttp3Sub = 1,
    e__Other__,
  };
  /**
   * In the HTTP channel (keys: supports_http3_page, supports_http3_sub), time from TCP SYN to ready for HTTP
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, SupHttp3TcpConnectionLabel> sup_http3_tcp_connection(4148);

  /**
   * generated from network.system_channel_addon_status
   */
  enum class SystemChannelAddonStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to addons.mozilla.org
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelAddonStatusLabel> system_channel_addon_status(4149);

  /**
   * generated from network.system_channel_addonversion_status
   */
  enum class SystemChannelAddonversionStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to *.addons.mozilla.org
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelAddonversionStatusLabel> system_channel_addonversion_status(4150);

  /**
   * generated from network.system_channel_other_status
   */
  enum class SystemChannelOtherStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to other mozilla.org domains
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelOtherStatusLabel> system_channel_other_status(4151);

  /**
   * generated from network.system_channel_remote_settings_status
   */
  enum class SystemChannelRemoteSettingsStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to firefox.settings.services.mozilla.com
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelRemoteSettingsStatusLabel> system_channel_remote_settings_status(4152);

  /**
   * generated from network.system_channel_success_or_failure
   */
  enum class SystemChannelSuccessOrFailureLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the number of succeeded and failed channels with a system principal to a mozilla domain. Label contains ok or failure reason.
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelSuccessOrFailureLabel> system_channel_success_or_failure(4153);

  /**
   * generated from network.system_channel_telemetry_status
   */
  enum class SystemChannelTelemetryStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to incoming.telemetry.mozilla.org
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelTelemetryStatusLabel> system_channel_telemetry_status(4154);

  /**
   * generated from network.system_channel_update_status
   */
  enum class SystemChannelUpdateStatusLabel: uint16_t {
    eOk = 0,
    eOffline = 1,
    eConnectivity = 2,
    eDns = 3,
    eConnectFail = 4,
    eTlsFail = 5,
    eHttpStatus = 6,
    eCancel = 7,
    eTimeout = 8,
    eReset = 9,
    eRefused = 10,
    ePartial = 11,
    eOther = 12,
    e__Other__,
  };
  /**
   * Counts the status of succeeded and failed requests to aus5.mozilla.org
   */
  constexpr impl::Labeled<impl::CounterMetric, SystemChannelUpdateStatusLabel> system_channel_update_status(4155);

  /**
   * generated from network.tcp_connection
   * In the HTTP page channel, time from the TCP SYN packet is received to the connection is established and ready for HTTP. Corresponds to Legacy histogram HTTP_PAGE_TCP_CONNECTION_2 in Desktop (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric tcp_connection(4156);

  /**
   * generated from network.tls_early_data_accepted
   */
  enum class TlsEarlyDataAcceptedLabel: uint16_t {
    eAccepted = 0,
    eRejected = 1,
    e__Other__,
  };
  /**
   * TLS early data was used and it was accepted or rejected by the remote host.
   */
  constexpr impl::Labeled<impl::CounterMetric, TlsEarlyDataAcceptedLabel> tls_early_data_accepted(4157);

  /**
   * generated from network.tls_early_data_bytes_written
   * Amount of bytes sent using TLS early data at the start of a TLS connection for a given channel.
   */
  constexpr impl::CustomDistributionMetric tls_early_data_bytes_written(4158);

  /**
   * generated from network.tls_early_data_negotiated
   */
  enum class TlsEarlyDataNegotiatedLabel: uint16_t {
    eNotAvailable = 0,
    eAvailableAndUsed = 1,
    eAvailableButNotUsed = 2,
    e__Other__,
  };
  /**
   * Sending TLS early data was not possible, possible and used, or possible but not used.
   */
  constexpr impl::Labeled<impl::CounterMetric, TlsEarlyDataNegotiatedLabel> tls_early_data_negotiated(4159);

  /**
   * generated from network.tls_handshake
   * In the HTTP page channel, time from after the TCP SYN packet is received to the secure connection is established and ready for HTTP. Corresponds to Legacy histogram HTTP_PAGE_TLS_HANDSHAKE in Desktop. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::TimingDistributionMetric tls_handshake(4160);

  /**
   * generated from network.trr_idle_close_time_h1
   */
  enum class TrrIdleCloseTimeH1Label: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * Time (in seconds) that it takes for an idle TRR connection to be closed by the server (HTTP/1.1)
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrIdleCloseTimeH1Label> trr_idle_close_time_h1(4161);

  /**
   * generated from network.trr_idle_close_time_h2
   */
  enum class TrrIdleCloseTimeH2Label: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * Time (in seconds) that it takes for an idle TRR connection to be closed by the server (HTTP/2)
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrIdleCloseTimeH2Label> trr_idle_close_time_h2(4162);

  /**
   * generated from network.trr_idle_close_time_h3
   */
  enum class TrrIdleCloseTimeH3Label: uint16_t {
    eMozillaCloudflareDnsCom = 0,
    eFirefoxDnsNextdnsIo = 1,
    ePrivateCanadianshieldCiraCa = 2,
    eDohXfinityCom = 3,
    eDnsShawCa = 4,
    eDoohCloudflareDnsCom = 5,
    eMozillaCloudflareDnsCom2 = 6,
    eFirefoxDnsNextdnsIo2 = 7,
    ePrivateCanadianshieldCiraCa2 = 8,
    eDohXfinityCom2 = 9,
    eDnsShawCa2 = 10,
    eDoohCloudflareDnsCom2 = 11,
    eMozillaCloudflareDnsCom3 = 12,
    eFirefoxDnsNextdnsIo3 = 13,
    ePrivateCanadianshieldCiraCa3 = 14,
    eDohXfinityCom3 = 15,
    eDnsShawCa3 = 16,
    eDoohCloudflareDnsCom3 = 17,
    e__Other__,
  };
  /**
   * Time (in seconds) that it takes for an idle TRR connection to be closed by the server (HTTP/3)
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, TrrIdleCloseTimeH3Label> trr_idle_close_time_h3(4163);
}

namespace hpack {
  /**
   * generated from hpack.bytes_evicted_compressor
   * HPACK: Number of bytes removed from dynamic table to make room for 1 new item
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_BYTES_EVICTED_COMPRESSOR.
   */
  constexpr impl::MemoryDistributionMetric bytes_evicted_compressor(4216);

  /**
   * generated from hpack.bytes_evicted_decompressor
   * HPACK: Number of bytes removed from dynamic table to make room for 1 new item
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_BYTES_EVICTED_DECOMPRESSOR.
   */
  constexpr impl::MemoryDistributionMetric bytes_evicted_decompressor(4217);

  /**
   * generated from hpack.bytes_evicted_ratio_compressor
   * HPACK: Ratio of bytes evicted to bytes added (* 100)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_BYTES_EVICTED_RATIO_COMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric bytes_evicted_ratio_compressor(4218);

  /**
   * generated from hpack.bytes_evicted_ratio_decompressor
   * HPACK: Ratio of bytes evicted to bytes added (* 100)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_BYTES_EVICTED_RATIO_DECOMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric bytes_evicted_ratio_decompressor(4219);

  /**
   * generated from hpack.elements_evicted_compressor
   * HPACK: Number of items removed from dynamic table to make room for 1 new item
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_ELEMENTS_EVICTED_COMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric elements_evicted_compressor(4220);

  /**
   * generated from hpack.elements_evicted_decompressor
   * HPACK: Number of items removed from dynamic table to make room for 1 new item
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_ELEMENTS_EVICTED_DECOMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric elements_evicted_decompressor(4221);

  /**
   * generated from hpack.peak_count_compressor
   * HPACK: peak number of items in the dynamic table
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_PEAK_COUNT_COMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric peak_count_compressor(4222);

  /**
   * generated from hpack.peak_count_decompressor
   * HPACK: peak number of items in the dynamic table
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_PEAK_COUNT_DECOMPRESSOR.
   */
  constexpr impl::CustomDistributionMetric peak_count_decompressor(4223);

  /**
   * generated from hpack.peak_size_compressor
   * HPACK: peak size in bytes of the table
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_PEAK_SIZE_COMPRESSOR.
   */
  constexpr impl::MemoryDistributionMetric peak_size_compressor(4224);

  /**
   * generated from hpack.peak_size_decompressor
   * HPACK: peak size in bytes of the table
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HPACK_PEAK_SIZE_DECOMPRESSOR.
   */
  constexpr impl::MemoryDistributionMetric peak_size_decompressor(4225);
}

namespace http {
  /**
   * generated from http.altsvc_entries_per_header
   * How many alt-svc productions were seen in a single Alt-Svc header
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_ALTSVC_ENTRIES_PER_HEADER.
   */
  constexpr impl::CustomDistributionMetric altsvc_entries_per_header(4226);

  /**
   * generated from http.altsvc_mapping_changed_target
   */
  enum class AltsvcMappingChangedTargetLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether or not a new alt-svc mapping would change the target hostname of the existing mapping
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_ALTSVC_MAPPING_CHANGED_TARGET.
   */
  constexpr impl::Labeled<impl::CounterMetric, AltsvcMappingChangedTargetLabel> altsvc_mapping_changed_target(4227);

  /**
   * generated from http.cache_lm_inconsistent
   */
  enum class CacheLmInconsistentLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Cache discovered inconsistent last-modified entry
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CACHE_LM_INCONSISTENT.
   */
  constexpr impl::Labeled<impl::CounterMetric, CacheLmInconsistentLabel> cache_lm_inconsistent(4228);

  /**
   * generated from http.channel_disposition
   * Channel Disposition: 0=Cancel, 1=Disk, 2=NetOK, 3=NetEarlyFail, 4=NetlateFail, +8 for HTTPS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_CHANNEL_DISPOSITION.
   */
  constexpr impl::CustomDistributionMetric channel_disposition(4229);

  /**
   * generated from http.channel_onstart_success
   */
  enum class ChannelOnstartSuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Successfully started HTTP channels
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_CHANNEL_ONSTART_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric, ChannelOnstartSuccessLabel> channel_onstart_success(4230);

  /**
   * generated from http.channel_page_onstart_success_trr
   * Successfully started HTTP channels for page loading when TRR is enabled; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_CHANNEL_PAGE_ONSTART_SUCCESS_TRR3.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> channel_page_onstart_success_trr(4231);

  /**
   * generated from http.channel_sub_onstart_success_trr
   * Successfully started HTTP channels for resource loading when TRR is enabled; Keyed by TRR domain
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_CHANNEL_SUB_ONSTART_SUCCESS_TRR3.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> channel_sub_onstart_success_trr(4232);

  /**
   * generated from http.connection_close_reason
   * Reason for HTTP connection closure, keyed by properties like HTTP version and connection state.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_CONNECTION_CLOSE_REASON.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> connection_close_reason(4233);

  /**
   * generated from http.connection_entry_cache_hit
   */
  enum class ConnectionEntryCacheHitLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Fraction of sockets that used a nsConnectionEntry with history - size 300.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_CONNECTION_ENTRY_CACHE_HIT_1.
   */
  constexpr impl::Labeled<impl::CounterMetric, ConnectionEntryCacheHitLabel> connection_entry_cache_hit(4234);

  /**
   * generated from http.content_encoding
   * encoding removed: 0=unknown, 1=gzip, 2=deflate, 3=brotli, 4=zstd
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_CONTENT_ENCODING.
   */
  constexpr impl::CustomDistributionMetric content_encoding(4235);

  /**
   * generated from http.dns_httpssvc_connection_failed_reason
   * The reason why we failed to connect with an HTTPSSVC record
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNS_HTTPSSVC_CONNECTION_FAILED_REASON.
   */
  constexpr impl::CustomDistributionMetric dns_httpssvc_connection_failed_reason(4236);

  /**
   * generated from http.dns_httpssvc_record_receiving_stage
   * Record at which stage an HTTPSSVC record is received
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNS_HTTPSSVC_RECORD_RECEIVING_STAGE.
   */
  constexpr impl::CustomDistributionMetric dns_httpssvc_record_receiving_stage(4237);

  /**
   * generated from http.dnt_usage
   * I want to be tracked, I do NOT want to be tracked, DNT unset
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DNT_USAGE.
   */
  constexpr impl::CustomDistributionMetric dnt_usage(4238);

  /**
   * generated from http.echconfig_success_rate
   */
  enum class EchconfigSuccessRateLabel: uint16_t {
    eEchconfigsucceeded = 0,
    eEchconfigfailed = 1,
    eNoechconfigsucceeded = 2,
    eNoechconfigfailed = 3,
    e__Other__,
  };
  /**
   * TLS handshake with and without EchConfig success rate.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram ECHCONFIG_SUCCESS_RATE.
   */
  constexpr impl::Labeled<impl::CounterMetric, EchconfigSuccessRateLabel> echconfig_success_rate(4239);

  /**
   * generated from http.http2_fail_before_settings
   */
  enum class Http2FailBeforeSettingsLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether an HTTP/2 session failed because the peer did not handshake properly
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP2_FAIL_BEFORE_SETTINGS.
   */
  constexpr impl::Labeled<impl::CounterMetric, Http2FailBeforeSettingsLabel> http2_fail_before_settings(4240);

  /**
   * generated from http.kbread_per_conn2
   * HTTP: KB read per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_KBREAD_PER_CONN2.
   */
  constexpr impl::MemoryDistributionMetric kbread_per_conn2(4241);

  /**
   * generated from http.pageload_is_ssl
   */
  enum class PageloadIsSslLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a HTTP page load was over SSL or not. Recorded during response processing for all first-party page loads.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_PAGELOAD_IS_SSL.
   */
  constexpr impl::Labeled<impl::CounterMetric, PageloadIsSslLabel> pageload_is_ssl(4242);

  /**
   * generated from http.proxy_type
   * HTTP Proxy Type (none, http, socks)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_PROXY_TYPE.
   */
  constexpr impl::CustomDistributionMetric proxy_type(4243);

  /**
   * generated from http.request_per_conn
   * HTTP: requests per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_REQUEST_PER_CONN.
   */
  constexpr impl::CustomDistributionMetric request_per_conn(4244);

  /**
   * generated from http.request_per_page
   * HTTP: Requests per page (count)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_REQUEST_PER_PAGE.
   */
  constexpr impl::CustomDistributionMetric request_per_page(4245);

  /**
   * generated from http.request_per_page_from_cache
   * HTTP: Requests serviced from cache (%)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_REQUEST_PER_PAGE_FROM_CACHE.
   */
  constexpr impl::CustomDistributionMetric request_per_page_from_cache(4246);

  /**
   * generated from http.response_version
   * HTTP: Protocol Version Used on Response from nsHttp.h
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_RESPONSE_VERSION.
   */
  constexpr impl::CustomDistributionMetric response_version(4247);

  /**
   * generated from http.saw_quic_alt_protocol
   * Does a response has a h3(1), other quic(2) or non(0) alt-protocol advertisement.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_SAW_QUIC_ALT_PROTOCOL_2.
   */
  constexpr impl::CustomDistributionMetric saw_quic_alt_protocol(4248);

  /**
   * generated from http.script_block_incorrect_mime
   */
  enum class ScriptBlockIncorrectMimeLabel: uint16_t {
    eUnknown = 0,
    eJavascript = 1,
    eImage = 2,
    eAudio = 3,
    eVideo = 4,
    eTextPlain = 5,
    eTextCsv = 6,
    eTextXml = 7,
    eAppOctetStream = 8,
    eAppXml = 9,
    eAppJson = 10,
    eTextJson = 11,
    eTextHtml = 12,
    eEmpty = 13,
    eServiceworkerLoad = 14,
    eWorkerLoad = 15,
    eImportscriptLoad = 16,
    eScriptLoad = 17,
    eSameOrigin = 18,
    eCorsOrigin = 19,
    eCrossOrigin = 20,
    eWorkletLoad = 21,
    e__Other__,
  };
  /**
   * Whether the script load has a MIME type of ...?  (unknown, javaScript, image, audio, video, text_plain, text_csv, text_xml, app_octet_stream, app_xml, app_json, text_json, text_html, empty). Whether the script load is from ...?  (serviceworker_load, worker_load, importSript_load, script_load). Whether the script load is of ...?  (same_origin, CORS_origin, cross_origin)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram SCRIPT_BLOCK_INCORRECT_MIME_3.
   */
  constexpr impl::Labeled<impl::CounterMetric, ScriptBlockIncorrectMimeLabel> script_block_incorrect_mime(4249);

  /**
   * generated from http.subitem_first_byte_latency_time
   * HTTP subitem channel: Page start -> first byte received for subitem reply (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_SUBITEM_FIRST_BYTE_LATENCY_TIME.
   */
  constexpr impl::TimingDistributionMetric subitem_first_byte_latency_time(4250);

  /**
   * generated from http.subitem_open_latency_time
   * HTTP subitem channel: Page start -> subitem open() (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_SUBITEM_OPEN_LATENCY_TIME.
   */
  constexpr impl::TimingDistributionMetric subitem_open_latency_time(4251);

  /**
   * generated from http.tls_early_data_accepted
   */
  enum class TlsEarlyDataAcceptedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * TLS early data was used and it was accepted (true) or rejected (false) by the remote host.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TLS_EARLY_DATA_ACCEPTED.
   */
  constexpr impl::Labeled<impl::CounterMetric, TlsEarlyDataAcceptedLabel> tls_early_data_accepted(4252);

  /**
   * generated from http.tls_early_data_negotiated
   * Sending TLS early data was possible: 0 - not possible, 1 - possible but not used, 2 - possible and used.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram TLS_EARLY_DATA_NEGOTIATED.
   */
  constexpr impl::CustomDistributionMetric tls_early_data_negotiated(4253);

  /**
   * generated from http.transaction_ech_retry_ech_failed_count
   * When echConfig is enabled, number of times a transaction is retried because of SSL_ERROR_ECH_FAILED
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_ECH_RETRY_ECH_FAILED_COUNT.
   */
  constexpr impl::CustomDistributionMetric transaction_ech_retry_ech_failed_count(4254);

  /**
   * generated from http.transaction_ech_retry_others_count
   * When echConfig is enabled, number of times a transaction is retried because of other error
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_ECH_RETRY_OTHERS_COUNT.
   */
  constexpr impl::CustomDistributionMetric transaction_ech_retry_others_count(4255);

  /**
   * generated from http.transaction_ech_retry_with_ech_count
   * When echConfig is enabled, number of times a transaction is retried because of SSL_ERROR_ECH_RETRY_WITH_ECH
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_ECH_RETRY_WITH_ECH_COUNT.
   */
  constexpr impl::CustomDistributionMetric transaction_ech_retry_with_ech_count(4256);

  /**
   * generated from http.transaction_ech_retry_without_ech_count
   * When echConfig is enabled, number of times a transaction is retried because of SSL_ERROR_ECH_RETRY_WITHOUT_ECH
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_ECH_RETRY_WITHOUT_ECH_COUNT.
   */
  constexpr impl::CustomDistributionMetric transaction_ech_retry_without_ech_count(4257);

  /**
   * generated from http.transaction_is_ssl
   */
  enum class TransactionIsSslLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether an HTTP request occurred over TLS/SSL or not. Recorded during response processing for all requests.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_TRANSACTION_IS_SSL.
   */
  constexpr impl::Labeled<impl::CounterMetric, TransactionIsSslLabel> transaction_is_ssl(4258);

  /**
   * generated from http.transaction_restart_reason
   * The reason why a HTTP transaction is restarted.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP_TRANSACTION_RESTART_REASON.
   */
  constexpr impl::CustomDistributionMetric transaction_restart_reason(4259);

  /**
   * generated from http.transaction_use_altsvc
   */
  enum class TransactionUseAltsvcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a HTTP transaction was routed via Alt-Svc or not.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram HTTP_TRANSACTION_USE_ALTSVC.
   */
  constexpr impl::Labeled<impl::CounterMetric, TransactionUseAltsvcLabel> transaction_use_altsvc(4260);

  /**
   * generated from http.transaction_wait_time_http
   * Time from submission to dispatch of HTTP transaction (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_WAIT_TIME_HTTP.
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_http(4261);

  /**
   * generated from http.transaction_wait_time_http2_sup_http3
   * Time from submission to dispatch of HTTP2 transaction that has received a respone from a server that addretizes HTTP3 support (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_WAIT_TIME_HTTP2_SUP_HTTP3.
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_http2_sup_http3(4262);

  /**
   * generated from http.transaction_wait_time_http3
   * Time from submission to dispatch of HTTP/3 transaction (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_WAIT_TIME_HTTP3.
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_http3(4263);

  /**
   * generated from http.transaction_wait_time_spdy
   * Time from submission to dispatch of SPDY transaction (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TRANSACTION_WAIT_TIME_SPDY.
   */
  constexpr impl::TimingDistributionMetric transaction_wait_time_spdy(4264);

  /**
   * generated from http.upload_bandwidth_mbps
   * The upload bandwidth for requests larger than 10MB. Measured in megabits per second, Mbps. Keyed by HTTP protocol version.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_UPLOAD_BANDWIDTH_MBPS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> upload_bandwidth_mbps(4265);
}

namespace http3 {
  /**
   * generated from http3.blocked_by_stream_limit_per_conn
   * HTTP3: number of times a connection is blocked by maximum allowed number of parallel streams per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_BLOCKED_BY_STREAM_LIMIT_PER_CONN.
   */
  constexpr impl::CustomDistributionMetric blocked_by_stream_limit_per_conn(4266);

  /**
   * generated from http3.connection_close_code
   * Error code when http3 connection is closed. Look at Http3Session for more details.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP3_CONNECTION_CLOSE_CODE_3.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> connection_close_code(4267);

  /**
   * generated from http3.counts_pto
   * HTTP3: the number of PTOs.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_COUNTS_PTO.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> counts_pto(4268);

  /**
   * generated from http3.drop_dgrams
   * HTTP3: the number of dropped datagrams.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_DROP_DGRAMS.
   */
  constexpr impl::CustomDistributionMetric drop_dgrams(4269);

  /**
   * generated from http3.ech_outcome
   */
  enum class EchOutcomeLabel: uint16_t {
    eNone = 0,
    eGrease = 1,
    eReal = 2,
    e__Other__,
  };
  /**
   * Success / Fail Rates for HTTP3 Keyed by ECH Usage
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram HTTP3_ECH_OUTCOME.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, EchOutcomeLabel> ech_outcome(4270);

  /**
   * generated from http3.late_ack
   */
  enum class LateAckLabel: uint16_t {
    eAck = 0,
    ePto = 1,
    e__Other__,
  };
  /**
   * HTTP3: the number of spurious retransmissions.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_LATE_ACK.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, LateAckLabel> late_ack(4271);

  /**
   * generated from http3.late_ack_ratio
   */
  enum class LateAckRatioLabel: uint16_t {
    eAck = 0,
    ePto = 1,
    e__Other__,
  };
  /**
   * HTTP3: spurious retransmissions ratio (spurios_retransmission / packet sent * 10000).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_LATE_ACK_RATIO.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, LateAckRatioLabel> late_ack_ratio(4272);

  /**
   * generated from http3.loss_ratio
   * HTTP3: packet loss ratio (multiply by 10000).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_LOSS_RATIO.
   */
  constexpr impl::CustomDistributionMetric loss_ratio(4273);

  /**
   * generated from http3.received_sent_dgrams
   */
  enum class ReceivedSentDgramsLabel: uint16_t {
    eReceived = 0,
    eSent = 1,
    e__Other__,
  };
  /**
   * HTTP3: the number of received/sent packets.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_RECEIVED_SENT_DGRAMS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, ReceivedSentDgramsLabel> received_sent_dgrams(4274);

  /**
   * generated from http3.request_per_conn
   * HTTP3: Streams created per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_REQUEST_PER_CONN.
   */
  constexpr impl::CustomDistributionMetric request_per_conn(4275);

  /**
   * generated from http3.saved_dgrams
   * HTTP3: the number of saved datagrams that are waiting for keys to be available.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_SAVED_DGRAMS.
   */
  constexpr impl::CustomDistributionMetric saved_dgrams(4276);

  /**
   * generated from http3.sending_blocked_by_flow_control_per_trans
   * HTTP3: number of times when a stream is blocked by the flow control while sendnig data.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_SENDING_BLOCKED_BY_FLOW_CONTROL_PER_TRANS.
   */
  constexpr impl::CustomDistributionMetric sending_blocked_by_flow_control_per_trans(4277);

  /**
   * generated from http3.timer_delayed
   * Time difference between setting timer value and actually firing the timer for calling neqo
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_TIMER_DELAYED.
   */
  constexpr impl::TimingDistributionMetric timer_delayed(4278);

  /**
   * generated from http3.trans_blocked_by_stream_limit_per_conn
   * HTTP3: number of transactions that are blocked by maximum allowed number of parallel streams per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_TRANS_BLOCKED_BY_STREAM_LIMIT_PER_CONN.
   */
  constexpr impl::CustomDistributionMetric trans_blocked_by_stream_limit_per_conn(4279);

  /**
   * generated from http3.trans_sending_blocked_by_flow_control_per_conn
   * HTTP3: number of times streams are blocked by the flow control while sending data per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP3_TRANS_SENDING_BLOCKED_BY_FLOW_CONTROL_PER_CONN.
   */
  constexpr impl::CustomDistributionMetric trans_sending_blocked_by_flow_control_per_conn(4280);
}

namespace netwerk {
  /**
   * generated from netwerk.http3_0rtt_state
   */
  enum class Http30rttStateLabel: uint16_t {
    eNotUsed = 0,
    eSucceeded = 1,
    eRejected = 2,
    eConnError = 3,
    eConnClosedByNecko = 4,
    e__Other__,
  };
  /**
   * Gather the outcome of 0-RTT usage: - "not_used": 0RTT_NOT_USED - "succeeded": 0RTT_USED_SUCCESS - "rejected": 0RTT_USED_REJECT - "conn_error": 0RTT_USED_CONN_ERROR - "conn_closed_by_necko": 0RTT_CONN_CLOSED_BY_NECKO
   */
  constexpr impl::Labeled<impl::CounterMetric, Http30rttStateLabel> http3_0rtt_state(4281);

  /**
   * generated from netwerk.http3_0rtt_state_duration
   */
  enum class Http30rttStateDurationLabel: uint16_t {
    eSucceeded = 0,
    eRejected = 1,
    eConnError = 2,
    eConnClosedByNecko = 3,
    eNotUsed = 4,
    e__Other__,
  };
  /**
   * The time a connection was in the 0-RTT state
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http30rttStateDurationLabel> http3_0rtt_state_duration(4282);

  /**
   * generated from netwerk.http3_time_to_reuse_idle_connection
   */
  enum class Http3TimeToReuseIdleConnectionLabel: uint16_t {
    eSucceeded = 0,
    eFailed = 1,
    e__Other__,
  };
  /**
   * The time to reuse an idle connection in HTTP3 (ms); keyed by the transaction reusing an idle connection has succeeded or failed
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, Http3TimeToReuseIdleConnectionLabel> http3_time_to_reuse_idle_connection(4283);

  /**
   * generated from netwerk.parent_connect_timeout
   * Counts how often the parent-connect-timeout timer is necessary to clear up EarlyHintPreloader
   */
  constexpr impl::CounterMetric parent_connect_timeout(4284);
}

namespace opaque_response_blocking {
  /**
   * generated from opaque.response.blocking.cross_origin_opaque_response_count
   * The number of loads of cross origin opaque resources. This metric was generated to correspond to the Legacy Telemetry scalar opaque.response.blocking.cross_origin_opaque_response_count.
   */
  constexpr impl::CounterMetric cross_origin_opaque_response_count(4285);

  /**
   * generated from opaque.response.blocking.javascript_validation_count
   * The number of times we run the JS validator. This metric was generated to correspond to the Legacy Telemetry scalar opaque.response.blocking.javascript_validation_count.
   */
  constexpr impl::CounterMetric javascript_validation_count(4286);
}

namespace orb {
  /**
   * generated from orb.block_initiator
   */
  enum class BlockInitiatorLabel: uint16_t {
    eInvalid = 0,
    eOther = 1,
    eFilteredFetch = 2,
    eBlockedFetch = 3,
    eJson = 4,
    eScript = 5,
    eImage = 6,
    eStylesheet = 7,
    eXmlhttprequest = 8,
    eDtd = 9,
    eFont = 10,
    eMedia = 11,
    eCspReport = 12,
    eXslt = 13,
    eImageset = 14,
    eWebManifest = 15,
    eSpeculative = 16,
    eUaFont = 17,
    eProxiedWebrtcMedia = 18,
    ePing = 19,
    eBeacon = 20,
    eWebTransport = 21,
    eExcluded = 22,
    e__Other__,
  };
  /**
   * The initiator of this ORB blocked request.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram ORB_BLOCK_INITIATOR.
   */
  constexpr impl::Labeled<impl::CounterMetric, BlockInitiatorLabel> block_initiator(4287);

  /**
   * generated from orb.block_reason
   */
  enum class BlockReasonLabel: uint16_t {
    eMimeNeverSniffed = 0,
    eResp206Blclisted = 1,
    eNosniffBlcOrTextp = 2,
    eResp206NoFirst = 3,
    eAfterSniffMedia = 4,
    eAfterSniffNosniff = 5,
    eAfterSniffStaCode = 6,
    eAfterSniffCtFail = 7,
    eMediaNotInitial = 8,
    eMediaIncorrectResp = 9,
    eJsValidationFailed = 10,
    e__Other__,
  };
  /**
   * The reason of why this request was blocked by ORB
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram ORB_BLOCK_REASON.
   */
  constexpr impl::Labeled<impl::CounterMetric, BlockReasonLabel> block_reason(4288);

  /**
   * generated from orb.did_ever_block_response
   */
  enum class DidEverBlockResponseLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * If any opaque response was blocked for a given top-level window context.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram ORB_DID_EVER_BLOCK_RESPONSE.
   */
  constexpr impl::Labeled<impl::CounterMetric, DidEverBlockResponseLabel> did_ever_block_response(4289);

  /**
   * generated from orb.javascript_validation
   */
  enum class JavascriptValidationLabel: uint16_t {
    eJavascript = 0,
    eJson = 1,
    eOther = 2,
    eFailure = 3,
    e__Other__,
  };
  /**
   * Time (in ms) that it takes for a ORB JavaScript validator to complete a validation, including IPC to the validator actor.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram ORB_JAVASCRIPT_VALIDATION_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, JavascriptValidationLabel> javascript_validation(4290);

  /**
   * generated from orb.receive_data_for_validation
   */
  enum class ReceiveDataForValidationLabel: uint16_t {
    eJavascript = 0,
    eJson = 1,
    eOther = 2,
    eFailure = 3,
    e__Other__,
  };
  /**
   * Time (in ms) that it takes to receive data for ORB JavaScript validation, including IPC to the validator actor.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram ORB_RECEIVE_DATA_FOR_VALIDATION_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, ReceiveDataForValidationLabel> receive_data_for_validation(4291);
}

namespace spdy {
  /**
   * generated from spdy.chunk_recvd
   * SPDY: Recvd Chunk Size (rounded to KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_CHUNK_RECVD.
   */
  constexpr impl::MemoryDistributionMetric chunk_recvd(4292);

  /**
   * generated from spdy.continued_headers
   * Size of continued H2 headers in bytes.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_CONTINUED_HEADERS.
   */
  constexpr impl::MemoryDistributionMetric continued_headers(4293);

  /**
   * generated from spdy.goaway_local
   * H2: goaway reason client sent from rfc 7540. 31 is none sent.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SPDY_GOAWAY_LOCAL.
   */
  constexpr impl::CustomDistributionMetric goaway_local(4294);

  /**
   * generated from spdy.goaway_peer
   * H2: goaway reason from peer from rfc 7540. 31 is none received.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram SPDY_GOAWAY_PEER.
   */
  constexpr impl::CustomDistributionMetric goaway_peer(4295);

  /**
   * generated from spdy.kbread_per_conn
   * SPDY: KB read per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_KBREAD_PER_CONN2.
   */
  constexpr impl::MemoryDistributionMetric kbread_per_conn(4296);

  /**
   * generated from spdy.parallel_streams
   * SPDY: Streams concurrent active per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_PARALLEL_STREAMS.
   */
  constexpr impl::CustomDistributionMetric parallel_streams(4297);

  /**
   * generated from spdy.request_per_conn
   * SPDY: Streams created per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_REQUEST_PER_CONN_3.
   */
  constexpr impl::CustomDistributionMetric request_per_conn(4298);

  /**
   * generated from spdy.server_initiated_streams
   * SPDY: Streams received per connection
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_SERVER_INITIATED_STREAMS.
   */
  constexpr impl::CustomDistributionMetric server_initiated_streams(4299);

  /**
   * generated from spdy.settings_iw
   * H2: Settings Initial Window (rounded to KB)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_SETTINGS_IW.
   */
  constexpr impl::MemoryDistributionMetric settings_iw(4300);

  /**
   * generated from spdy.settings_max_streams
   * H2: Settings Max Streams parameter
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_SETTINGS_MAX_STREAMS.
   */
  constexpr impl::CustomDistributionMetric settings_max_streams(4301);

  /**
   * generated from spdy.syn_ratio
   * SPDY: SYN Frame Header Ratio (lower better)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram SPDY_SYN_RATIO.
   */
  constexpr impl::CustomDistributionMetric syn_ratio(4302);

  /**
   * generated from spdy.syn_reply_ratio
   * SPDY: SYN Reply Header Ratio (lower better)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram SPDY_SYN_REPLY_RATIO.
   */
  constexpr impl::CustomDistributionMetric syn_reply_ratio(4303);

  /**
   * generated from spdy.syn_reply_size
   * SPDY: SYN Reply Header Size
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_SYN_REPLY_SIZE.
   */
  constexpr impl::MemoryDistributionMetric syn_reply_size(4304);

  /**
   * generated from spdy.syn_size
   * SPDY: SYN Frame Header Size
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SPDY_SYN_SIZE.
   */
  constexpr impl::MemoryDistributionMetric syn_size(4305);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkProtocolHttpMetrics_h
