// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNormandyMetrics_h
#define mozilla_GleanNormandyMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace normandy {
  /**
   * generated from normandy.enroll_addon_rollout
   */
  struct EnrollAddonRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experimenttype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experimenttype) {
        extraKeys.AppendElement()->AssignASCII("experimentType");
        extraValues.EmplaceBack(experimenttype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has succeeded. This event was generated to correspond to the Legacy Telemetry event normandy.enroll#addon_rollout.
   */
  constexpr impl::EventMetric<EnrollAddonRolloutExtra> enroll_addon_rollout(4924);

  /**
   * generated from normandy.enroll_addon_study
   */
  struct EnrollAddonStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experimenttype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experimenttype) {
        extraKeys.AppendElement()->AssignASCII("experimentType");
        extraValues.EmplaceBack(experimenttype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has succeeded. This event was generated to correspond to the Legacy Telemetry event normandy.enroll#addon_study.
   */
  constexpr impl::EventMetric<EnrollAddonStudyExtra> enroll_addon_study(4925);

  /**
   * generated from normandy.enroll_failed_addon_rollout
   */
  struct EnrollFailedAddonRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefbranch;
    mozilla::Maybe<nsCString> preference;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefbranch) {
        extraKeys.AppendElement()->AssignASCII("prefBranch");
        extraValues.EmplaceBack(prefbranch.value());
      }
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has failed. This event was generated to correspond to the Legacy Telemetry event normandy.enrollFailed#addon_rollout.
   */
  constexpr impl::EventMetric<EnrollFailedAddonRolloutExtra> enroll_failed_addon_rollout(4926);

  /**
   * generated from normandy.enroll_failed_addon_study
   */
  struct EnrollFailedAddonStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefbranch;
    mozilla::Maybe<nsCString> preference;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefbranch) {
        extraKeys.AppendElement()->AssignASCII("prefBranch");
        extraValues.EmplaceBack(prefbranch.value());
      }
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has failed. This event was generated to correspond to the Legacy Telemetry event normandy.enrollFailed#addon_study.
   */
  constexpr impl::EventMetric<EnrollFailedAddonStudyExtra> enroll_failed_addon_study(4927);

  /**
   * generated from normandy.enroll_failed_nimbus_experiment
   */
  struct EnrollFailedNimbusExperimentExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefbranch;
    mozilla::Maybe<nsCString> preference;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefbranch) {
        extraKeys.AppendElement()->AssignASCII("prefBranch");
        extraValues.EmplaceBack(prefbranch.value());
      }
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has failed. This event was generated to correspond to the Legacy Telemetry event normandy.enrollFailed#nimbus_experiment.
   */
  constexpr impl::EventMetric<EnrollFailedNimbusExperimentExtra> enroll_failed_nimbus_experiment(4928);

  /**
   * generated from normandy.enroll_failed_preference_rollout
   */
  struct EnrollFailedPreferenceRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefbranch;
    mozilla::Maybe<nsCString> preference;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefbranch) {
        extraKeys.AppendElement()->AssignASCII("prefBranch");
        extraValues.EmplaceBack(prefbranch.value());
      }
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has failed. This event was generated to correspond to the Legacy Telemetry event normandy.enrollFailed#preference_rollout.
   */
  constexpr impl::EventMetric<EnrollFailedPreferenceRolloutExtra> enroll_failed_preference_rollout(4929);

  /**
   * generated from normandy.enroll_failed_preference_study
   */
  struct EnrollFailedPreferenceStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefbranch;
    mozilla::Maybe<nsCString> preference;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefbranch) {
        extraKeys.AppendElement()->AssignASCII("prefBranch");
        extraValues.EmplaceBack(prefbranch.value());
      }
      if (preference) {
        extraKeys.AppendElement()->AssignASCII("preference");
        extraValues.EmplaceBack(preference.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has failed. This event was generated to correspond to the Legacy Telemetry event normandy.enrollFailed#preference_study.
   */
  constexpr impl::EventMetric<EnrollFailedPreferenceStudyExtra> enroll_failed_preference_study(4930);

  /**
   * generated from normandy.enroll_nimbus_experiment
   */
  struct EnrollNimbusExperimentExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experimenttype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experimenttype) {
        extraKeys.AppendElement()->AssignASCII("experimentType");
        extraValues.EmplaceBack(experimenttype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has succeeded. This event was generated to correspond to the Legacy Telemetry event normandy.enroll#nimbus_experiment.
   */
  constexpr impl::EventMetric<EnrollNimbusExperimentExtra> enroll_nimbus_experiment(4931);

  /**
   * generated from normandy.enroll_preference_rollout
   */
  struct EnrollPreferenceRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experimenttype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experimenttype) {
        extraKeys.AppendElement()->AssignASCII("experimentType");
        extraValues.EmplaceBack(experimenttype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has succeeded. This event was generated to correspond to the Legacy Telemetry event normandy.enroll#preference_rollout.
   */
  constexpr impl::EventMetric<EnrollPreferenceRolloutExtra> enroll_preference_rollout(4932);

  /**
   * generated from normandy.enroll_preference_study
   */
  struct EnrollPreferenceStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> experimenttype;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (experimenttype) {
        extraKeys.AppendElement()->AssignASCII("experimentType");
        extraValues.EmplaceBack(experimenttype.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a Normandy recipe of the above types has succeeded. This event was generated to correspond to the Legacy Telemetry event normandy.enroll#preference_study.
   */
  constexpr impl::EventMetric<EnrollPreferenceStudyExtra> enroll_preference_study(4933);

  /**
   * generated from normandy.exp_pref_changed_preference_study
   */
  struct ExpPrefChangedPreferenceStudyExtra {
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> preferencename;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (preferencename) {
        extraKeys.AppendElement()->AssignASCII("preferenceName");
        extraValues.EmplaceBack(preferencename.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records that a preference that was set by an experiment has been changed away from its experimental value. This can be triggered by a user changing a preference at runtime, by the preference being changed on disk when Firefox is not running, or by the preference already having a user-set value when a user has enrolls in a default branch experiment. This event was generated to correspond to the Legacy Telemetry event normandy.expPrefChanged#preference_study.
   */
  constexpr impl::EventMetric<ExpPrefChangedPreferenceStudyExtra> exp_pref_changed_preference_study(4934);

  /**
   * generated from normandy.graduate_preference_rollout
   */
  struct GraduatePreferenceRolloutExtra {
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a preference rollout ends due to the rolled-out preference becoming a new default. This event was generated to correspond to the Legacy Telemetry event normandy.graduate#preference_rollout.
   */
  constexpr impl::EventMetric<GraduatePreferenceRolloutExtra> graduate_preference_rollout(4935);

  /**
   * generated from normandy.recipe_freshness
   * For each recipe ID seen by the Normandy client, its last_modified. This metric was generated to correspond to the Legacy Telemetry scalar normandy.recipe_freshness.
   */
  constexpr impl::Labeled<impl::QuantityMetric, DynamicLabel> recipe_freshness(4936);

  /**
   * generated from normandy.unenroll_addon_rollback
   */
  struct UnenrollAddonRollbackExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> didresetvalue;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefname;
    mozilla::Maybe<nsCString> preftype;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (didresetvalue) {
        extraKeys.AppendElement()->AssignASCII("didResetValue");
        extraValues.EmplaceBack(didresetvalue.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefname) {
        extraKeys.AppendElement()->AssignASCII("prefName");
        extraValues.EmplaceBack(prefname.value());
      }
      if (preftype) {
        extraKeys.AppendElement()->AssignASCII("prefType");
        extraValues.EmplaceBack(preftype.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a Normandy recipe of certain types "ends".  N.B. For preference_rollback, this is fired when the recipe is fired (the recipe that "ends" is a corresponding preference_rollout). This event was generated to correspond to the Legacy Telemetry event normandy.unenroll#addon_rollback.
   */
  constexpr impl::EventMetric<UnenrollAddonRollbackExtra> unenroll_addon_rollback(4937);

  /**
   * generated from normandy.unenroll_addon_study
   */
  struct UnenrollAddonStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> didresetvalue;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefname;
    mozilla::Maybe<nsCString> preftype;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (didresetvalue) {
        extraKeys.AppendElement()->AssignASCII("didResetValue");
        extraValues.EmplaceBack(didresetvalue.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefname) {
        extraKeys.AppendElement()->AssignASCII("prefName");
        extraValues.EmplaceBack(prefname.value());
      }
      if (preftype) {
        extraKeys.AppendElement()->AssignASCII("prefType");
        extraValues.EmplaceBack(preftype.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a Normandy recipe of certain types "ends".  N.B. For preference_rollback, this is fired when the recipe is fired (the recipe that "ends" is a corresponding preference_rollout). This event was generated to correspond to the Legacy Telemetry event normandy.unenroll#addon_study.
   */
  constexpr impl::EventMetric<UnenrollAddonStudyExtra> unenroll_addon_study(4938);

  /**
   * generated from normandy.unenroll_failed_addon_rollback
   */
  struct UnenrollFailedAddonRollbackExtra {
    mozilla::Maybe<nsCString> caller;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> originalreason;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (caller) {
        extraKeys.AppendElement()->AssignASCII("caller");
        extraValues.EmplaceBack(caller.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (originalreason) {
        extraKeys.AppendElement()->AssignASCII("originalReason");
        extraValues.EmplaceBack(originalreason.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when unenrolling a user fails (see the unenroll event). This event was generated to correspond to the Legacy Telemetry event normandy.unenrollFailed#addon_rollback.
   */
  constexpr impl::EventMetric<UnenrollFailedAddonRollbackExtra> unenroll_failed_addon_rollback(4939);

  /**
   * generated from normandy.unenroll_failed_nimbus_experiment
   */
  struct UnenrollFailedNimbusExperimentExtra {
    mozilla::Maybe<nsCString> caller;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> originalreason;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (caller) {
        extraKeys.AppendElement()->AssignASCII("caller");
        extraValues.EmplaceBack(caller.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (originalreason) {
        extraKeys.AppendElement()->AssignASCII("originalReason");
        extraValues.EmplaceBack(originalreason.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when unenrolling a user fails (see the unenroll event). This event was generated to correspond to the Legacy Telemetry event normandy.unenrollFailed#nimbus_experiment.
   */
  constexpr impl::EventMetric<UnenrollFailedNimbusExperimentExtra> unenroll_failed_nimbus_experiment(4940);

  /**
   * generated from normandy.unenroll_failed_preference_rollback
   */
  struct UnenrollFailedPreferenceRollbackExtra {
    mozilla::Maybe<nsCString> caller;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> originalreason;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (caller) {
        extraKeys.AppendElement()->AssignASCII("caller");
        extraValues.EmplaceBack(caller.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (originalreason) {
        extraKeys.AppendElement()->AssignASCII("originalReason");
        extraValues.EmplaceBack(originalreason.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when unenrolling a user fails (see the unenroll event). This event was generated to correspond to the Legacy Telemetry event normandy.unenrollFailed#preference_rollback.
   */
  constexpr impl::EventMetric<UnenrollFailedPreferenceRollbackExtra> unenroll_failed_preference_rollback(4941);

  /**
   * generated from normandy.unenroll_failed_preference_study
   */
  struct UnenrollFailedPreferenceStudyExtra {
    mozilla::Maybe<nsCString> caller;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> originalreason;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (caller) {
        extraKeys.AppendElement()->AssignASCII("caller");
        extraValues.EmplaceBack(caller.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (originalreason) {
        extraKeys.AppendElement()->AssignASCII("originalReason");
        extraValues.EmplaceBack(originalreason.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when unenrolling a user fails (see the unenroll event). This event was generated to correspond to the Legacy Telemetry event normandy.unenrollFailed#preference_study.
   */
  constexpr impl::EventMetric<UnenrollFailedPreferenceStudyExtra> unenroll_failed_preference_study(4942);

  /**
   * generated from normandy.unenroll_nimbus_experiment
   */
  struct UnenrollNimbusExperimentExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> didresetvalue;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefname;
    mozilla::Maybe<nsCString> preftype;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (didresetvalue) {
        extraKeys.AppendElement()->AssignASCII("didResetValue");
        extraValues.EmplaceBack(didresetvalue.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefname) {
        extraKeys.AppendElement()->AssignASCII("prefName");
        extraValues.EmplaceBack(prefname.value());
      }
      if (preftype) {
        extraKeys.AppendElement()->AssignASCII("prefType");
        extraValues.EmplaceBack(preftype.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a Normandy recipe of certain types "ends".  N.B. For preference_rollback, this is fired when the recipe is fired (the recipe that "ends" is a corresponding preference_rollout). This event was generated to correspond to the Legacy Telemetry event normandy.unenroll#nimbus_experiment.
   */
  constexpr impl::EventMetric<UnenrollNimbusExperimentExtra> unenroll_nimbus_experiment(4943);

  /**
   * generated from normandy.unenroll_preference_rollback
   */
  struct UnenrollPreferenceRollbackExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> didresetvalue;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefname;
    mozilla::Maybe<nsCString> preftype;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (didresetvalue) {
        extraKeys.AppendElement()->AssignASCII("didResetValue");
        extraValues.EmplaceBack(didresetvalue.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefname) {
        extraKeys.AppendElement()->AssignASCII("prefName");
        extraValues.EmplaceBack(prefname.value());
      }
      if (preftype) {
        extraKeys.AppendElement()->AssignASCII("prefType");
        extraValues.EmplaceBack(preftype.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a Normandy recipe of certain types "ends".  N.B. For preference_rollback, this is fired when the recipe is fired (the recipe that "ends" is a corresponding preference_rollout). This event was generated to correspond to the Legacy Telemetry event normandy.unenroll#preference_rollback.
   */
  constexpr impl::EventMetric<UnenrollPreferenceRollbackExtra> unenroll_preference_rollback(4944);

  /**
   * generated from normandy.unenroll_preference_study
   */
  struct UnenrollPreferenceStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> changedpref;
    mozilla::Maybe<nsCString> conflictingslug;
    mozilla::Maybe<nsCString> didresetvalue;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> prefname;
    mozilla::Maybe<nsCString> preftype;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (changedpref) {
        extraKeys.AppendElement()->AssignASCII("changedPref");
        extraValues.EmplaceBack(changedpref.value());
      }
      if (conflictingslug) {
        extraKeys.AppendElement()->AssignASCII("conflictingSlug");
        extraValues.EmplaceBack(conflictingslug.value());
      }
      if (didresetvalue) {
        extraKeys.AppendElement()->AssignASCII("didResetValue");
        extraValues.EmplaceBack(didresetvalue.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (prefname) {
        extraKeys.AppendElement()->AssignASCII("prefName");
        extraValues.EmplaceBack(prefname.value());
      }
      if (preftype) {
        extraKeys.AppendElement()->AssignASCII("prefType");
        extraValues.EmplaceBack(preftype.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a Normandy recipe of certain types "ends".  N.B. For preference_rollback, this is fired when the recipe is fired (the recipe that "ends" is a corresponding preference_rollout). This event was generated to correspond to the Legacy Telemetry event normandy.unenroll#preference_study.
   */
  constexpr impl::EventMetric<UnenrollPreferenceStudyExtra> unenroll_preference_study(4945);

  /**
   * generated from normandy.update_addon_rollout
   */
  struct UpdateAddonRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> previousstate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (previousstate) {
        extraKeys.AppendElement()->AssignASCII("previousState");
        extraValues.EmplaceBack(previousstate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is fired when a client detects that a recipe of the ahove types has changed on the server, and the new version of the recipe is being applied over an existing, older version previously fetched from the server. This event was generated to correspond to the Legacy Telemetry event normandy.update#addon_rollout.
   */
  constexpr impl::EventMetric<UpdateAddonRolloutExtra> update_addon_rollout(4946);

  /**
   * generated from normandy.update_addon_study
   */
  struct UpdateAddonStudyExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> previousstate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (previousstate) {
        extraKeys.AppendElement()->AssignASCII("previousState");
        extraValues.EmplaceBack(previousstate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is fired when a client detects that a recipe of the ahove types has changed on the server, and the new version of the recipe is being applied over an existing, older version previously fetched from the server. This event was generated to correspond to the Legacy Telemetry event normandy.update#addon_study.
   */
  constexpr impl::EventMetric<UpdateAddonStudyExtra> update_addon_study(4947);

  /**
   * generated from normandy.update_failed_addon_rollout
   */
  struct UpdateFailedAddonRolloutExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a new version of a Normandy recipe of the above types (over an existing, older version previously fetched from the server) has failed. This event was generated to correspond to the Legacy Telemetry event normandy.updateFailed#addon_rollout.
   */
  constexpr impl::EventMetric<UpdateFailedAddonRolloutExtra> update_failed_addon_rollout(4948);

  /**
   * generated from normandy.update_failed_addon_study
   */
  struct UpdateFailedAddonStudyExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> detail;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (detail) {
        extraKeys.AppendElement()->AssignASCII("detail");
        extraValues.EmplaceBack(detail.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when applying a new version of a Normandy recipe of the above types (over an existing, older version previously fetched from the server) has failed. This event was generated to correspond to the Legacy Telemetry event normandy.updateFailed#addon_study.
   */
  constexpr impl::EventMetric<UpdateFailedAddonStudyExtra> update_failed_addon_study(4949);

  /**
   * generated from normandy.update_nimbus_experiment
   */
  struct UpdateNimbusExperimentExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> previousstate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (previousstate) {
        extraKeys.AppendElement()->AssignASCII("previousState");
        extraValues.EmplaceBack(previousstate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is fired when a client detects that a recipe of the ahove types has changed on the server, and the new version of the recipe is being applied over an existing, older version previously fetched from the server. This event was generated to correspond to the Legacy Telemetry event normandy.update#nimbus_experiment.
   */
  constexpr impl::EventMetric<UpdateNimbusExperimentExtra> update_nimbus_experiment(4950);

  /**
   * generated from normandy.update_preference_rollout
   */
  struct UpdatePreferenceRolloutExtra {
    mozilla::Maybe<nsCString> addonid;
    mozilla::Maybe<nsCString> addonversion;
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> enrollmentid;
    mozilla::Maybe<nsCString> previousstate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonid) {
        extraKeys.AppendElement()->AssignASCII("addonId");
        extraValues.EmplaceBack(addonid.value());
      }
      if (addonversion) {
        extraKeys.AppendElement()->AssignASCII("addonVersion");
        extraValues.EmplaceBack(addonversion.value());
      }
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (enrollmentid) {
        extraKeys.AppendElement()->AssignASCII("enrollmentId");
        extraValues.EmplaceBack(enrollmentid.value());
      }
      if (previousstate) {
        extraKeys.AppendElement()->AssignASCII("previousState");
        extraValues.EmplaceBack(previousstate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is fired when a client detects that a recipe of the ahove types has changed on the server, and the new version of the recipe is being applied over an existing, older version previously fetched from the server. This event was generated to correspond to the Legacy Telemetry event normandy.update#preference_rollout.
   */
  constexpr impl::EventMetric<UpdatePreferenceRolloutExtra> update_preference_rollout(4951);

  /**
   * generated from normandy.validation_failed_nimbus_experiment
   */
  struct ValidationFailedNimbusExperimentExtra {
    mozilla::Maybe<nsCString> branch;
    mozilla::Maybe<nsCString> featureIds;
    mozilla::Maybe<nsCString> l10nIds;
    mozilla::Maybe<nsCString> locale;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (branch) {
        extraKeys.AppendElement()->AssignASCII("branch");
        extraValues.EmplaceBack(branch.value());
      }
      if (featureIds) {
        extraKeys.AppendElement()->AssignASCII("feature_ids");
        extraValues.EmplaceBack(featureIds.value());
      }
      if (l10nIds) {
        extraKeys.AppendElement()->AssignASCII("l10n_ids");
        extraValues.EmplaceBack(l10nIds.value());
      }
      if (locale) {
        extraKeys.AppendElement()->AssignASCII("locale");
        extraValues.EmplaceBack(locale.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This records when validation of a recipe fails. This event was generated to correspond to the Legacy Telemetry event normandy.validationFailed#nimbus_experiment.
   */
  constexpr impl::EventMetric<ValidationFailedNimbusExperimentExtra> validation_failed_nimbus_experiment(4952);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNormandyMetrics_h
