// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanParserHtmlparserMetrics_h
#define mozilla_GleanParserHtmlparserMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace ysod {
  /**
   * generated from ysod.shown_ysod
   */
  struct ShownYsodExtra {
    mozilla::Maybe<nsCString> destroyed;
    mozilla::Maybe<uint32_t> errorCode;
    mozilla::Maybe<bool> hidden;
    mozilla::Maybe<nsCString> lastLine;
    mozilla::Maybe<uint32_t> lastLineLen;
    mozilla::Maybe<nsCString> location;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (destroyed) {
        extraKeys.AppendElement()->AssignASCII("destroyed");
        extraValues.EmplaceBack(destroyed.value());
      }
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.AppendElement()->AppendInt(errorCode.value());
      }
      if (hidden) {
        extraKeys.AppendElement()->AssignASCII("hidden");
        extraValues.AppendElement()->AssignASCII(hidden.value() ? "true" : "false");
      }
      if (lastLine) {
        extraKeys.AppendElement()->AssignASCII("last_line");
        extraValues.EmplaceBack(lastLine.value());
      }
      if (lastLineLen) {
        extraKeys.AppendElement()->AssignASCII("last_line_len");
        extraValues.AppendElement()->AppendInt(lastLineLen.value());
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is recorded only for Firefox UI documents (chrome). Recorded when a Yellow Screen of Death is shown. The `value` is a url on which the error happened. Yellow Screen of Death happens when XML or XHTML document encounters a parsing error. It is commonly a result of the document being malformed or missing DTD entity. This data should be reviewed periodically for urls that error frequently. This event was generated to correspond to the Legacy Telemetry event ysod.shown#ysod.
   */
  constexpr impl::EventMetric<ShownYsodExtra> shown_ysod(4308);
}

} // namespace mozilla::glean

#endif // mozilla_GleanParserHtmlparserMetrics_h
