// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPreferencesMetrics_h
#define mozilla_GleanPreferencesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace aboutpreferences {
  /**
   * generated from aboutpreferences.show_click
   */
  struct ShowClickExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when a pane is shown when user clicks category name inside about:preferences. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#click.
   */
  constexpr impl::EventMetric<ShowClickExtra> show_click(638);

  /**
   * generated from aboutpreferences.show_hash
   */
  struct ShowHashExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when a pane is shown via a hash change in url. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#hash.
   */
  constexpr impl::EventMetric<ShowHashExtra> show_hash(639);

  /**
   * generated from aboutpreferences.show_initial
   */
  struct ShowInitialExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when a pane is shown direclty. This happens with or without a hash in the URL. The "general" pane loads without such a hash, when the pane is loaded via the "main" entrypoints in the menu system or with shortcuts. This event was generated to correspond to the Legacy Telemetry event aboutpreferences.show#initial.
   */
  constexpr impl::EventMetric<ShowInitialExtra> show_initial(640);
}

namespace intl_ui_browser_language {
  /**
   * generated from intl.ui.browser_language.accept_dialog
   */
  struct AcceptDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.accept#dialog.
   */
  constexpr impl::EventMetric<AcceptDialogExtra> accept_dialog(641);

  /**
   * generated from intl.ui.browser_language.add_dialog
   */
  struct AddDialogExtra {
    mozilla::Maybe<nsCString> installid;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (installid) {
        extraKeys.AppendElement()->AssignASCII("installId");
        extraValues.EmplaceBack(installid.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.add#dialog.
   */
  constexpr impl::EventMetric<AddDialogExtra> add_dialog(642);

  /**
   * generated from intl.ui.browser_language.apply_main
   */
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.apply#main.
   */
  constexpr impl::EventMetric<NoExtraKeys> apply_main(643);

  /**
   * generated from intl.ui.browser_language.cancel_dialog
   */
  struct CancelDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.cancel#dialog.
   */
  constexpr impl::EventMetric<CancelDialogExtra> cancel_dialog(644);

  /**
   * generated from intl.ui.browser_language.manage_main
   */
  struct ManageMainExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.manage#main.
   */
  constexpr impl::EventMetric<ManageMainExtra> manage_main(645);

  /**
   * generated from intl.ui.browser_language.remove_dialog
   */
  struct RemoveDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.remove#dialog.
   */
  constexpr impl::EventMetric<RemoveDialogExtra> remove_dialog(646);

  /**
   * generated from intl.ui.browser_language.reorder_dialog
   */
  struct ReorderDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.reorder#dialog.
   */
  constexpr impl::EventMetric<ReorderDialogExtra> reorder_dialog(647);

  /**
   * generated from intl.ui.browser_language.reorder_main
   */
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.reorder#main.
   */
  constexpr impl::EventMetric<NoExtraKeys> reorder_main(648);

  /**
   * generated from intl.ui.browser_language.search_dialog
   */
  struct SearchDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.search#dialog.
   */
  constexpr impl::EventMetric<SearchDialogExtra> search_dialog(649);

  /**
   * generated from intl.ui.browser_language.search_main
   */
  struct SearchMainExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.search#main.
   */
  constexpr impl::EventMetric<SearchMainExtra> search_main(650);

  /**
   * generated from intl.ui.browser_language.set_fallback_dialog
   */
  struct SetFallbackDialogExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser language within about-preferences in the main pane and in the browser language dialog. Each dialog event (on the dialog object, and the manage and search methods of the main object) has a value which is a monotonically increasing number that links it with other events related to the same dialog instance. This event was generated to correspond to the Legacy Telemetry event intl.ui.browserLanguage.set_fallback#dialog.
   */
  constexpr impl::EventMetric<SetFallbackDialogExtra> set_fallback_dialog(651);
}

namespace network_proxy_settings {
  /**
   * generated from network.proxy.settings.proxy_type_preference
   */
  struct ProxyTypePreferenceExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This metric tracks what proxy types users are choosing in the Network Settings dialog at the bottom of about:preferences#general. It gets recorded when pressing OK in the dialog box.
   */
  constexpr impl::EventMetric<ProxyTypePreferenceExtra> proxy_type_preference(652);
}

namespace privacy_ui_fpp_click {
  /**
   * generated from privacy.ui.fpp.click.checkbox
   */
  struct CheckboxExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on fingerprinting protection checkbox in the ETP Custom subpanel.
   */
  constexpr impl::EventMetric<CheckboxExtra> checkbox(653);

  /**
   * generated from privacy.ui.fpp.click.menu
   */
  struct MenuExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on fingerprinting protection menulist in the ETP Custom subpanel.
   */
  constexpr impl::EventMetric<MenuExtra> menu(654);
}

namespace security_doh_settings {
  /**
   * generated from security.doh.settings.mode_changed_button
   */
  struct ModeChangedButtonExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User changed the TRR mode in about:preferences#privacy settings Value is id of the clicked button. This event was generated to correspond to the Legacy Telemetry event security.doh.settings.mode_changed#button.
   */
  constexpr impl::EventMetric<ModeChangedButtonExtra> mode_changed_button(655);

  /**
   * generated from security.doh.settings.provider_choice_value
   */
  struct ProviderChoiceValueExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User changed their DoH provider. Recorded value is URL of one of the existing providers or "custom". This event was generated to correspond to the Legacy Telemetry event security.doh.settings.provider_choice#value.
   */
  constexpr impl::EventMetric<ProviderChoiceValueExtra> provider_choice_value(656);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPreferencesMetrics_h
