// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanProcesstoolsMetrics_h
#define mozilla_GleanProcesstoolsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace glam_experiment {
  /**
   * generated from glam_experiment.cpu_time_bogus_values
   * Duplicate of: `power.cpu_time_bogus_values`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::CounterMetric cpu_time_bogus_values(303);

  /**
   * generated from glam_experiment.total_cpu_time_ms
   * Duplicate of: `power.total_cpu_time_ms`
   * Intended for the purpose of testing client side sampling of data. This metric is disabled by default and will be enabled only for the purpose of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::CounterMetric total_cpu_time_ms(304);
}

namespace power {
  /**
   * generated from power.cpu_time_bogus_values
   * Impossibly large CPU time values that were discarded.
   */
  constexpr impl::CounterMetric cpu_time_bogus_values(5136);

  /**
   * generated from power.cpu_time_per_process_type_ms
   */
  enum class CpuTimePerProcessTypeMsLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    e__Other__,
  };
  /**
   * CPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric, CpuTimePerProcessTypeMsLabel> cpu_time_per_process_type_ms(5137);

  /**
   * generated from power.cpu_time_per_tracker_type_ms
   */
  enum class CpuTimePerTrackerTypeMsLabel: uint16_t {
    eAd = 0,
    eAnalytics = 1,
    eCryptomining = 2,
    eFingerprinting = 3,
    eSocial = 4,
    eUnknown = 5,
    e__Other__,
  };
  /**
   * CPU time used by content processes used only for tracking resources, labeled by the category of the tracker.
   */
  constexpr impl::Labeled<impl::CounterMetric, CpuTimePerTrackerTypeMsLabel> cpu_time_per_tracker_type_ms(5138);

  /**
   * generated from power.energy_per_process_type
   */
  enum class EnergyPerProcessTypeLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    e__Other__,
  };
  /**
   * How much energy (in µWh) has been used, broken down by process type. Only available on Apple Silicon.
   */
  constexpr impl::Labeled<impl::CounterMetric, EnergyPerProcessTypeLabel> energy_per_process_type(5139);

  /**
   * generated from power.gpu_time_bogus_values
   * Impossibly large GPU time values that were discarded.
   */
  constexpr impl::CounterMetric gpu_time_bogus_values(5140);

  /**
   * generated from power.gpu_time_per_process_type_ms
   */
  enum class GpuTimePerProcessTypeMsLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    e__Other__,
  };
  /**
   * GPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuTimePerProcessTypeMsLabel> gpu_time_per_process_type_ms(5141);

  /**
   * generated from power.total_cpu_time_ms
   * Total CPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric total_cpu_time_ms(5142);

  /**
   * generated from power.total_gpu_time_ms
   * Total GPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric total_gpu_time_ms(5143);

  /**
   * generated from power.total_thread_wakeups
   * How many times threads woke up and could have woken up a CPU core.
   */
  constexpr impl::CounterMetric total_thread_wakeups(5144);

  /**
   * generated from power.wakeups_per_process_type
   */
  enum class WakeupsPerProcessTypeLabel: uint16_t {
    eParentActive = 0,
    eParentActivePlayingAudio = 1,
    eParentActivePlayingVideo = 2,
    eParentInactive = 3,
    eParentInactivePlayingAudio = 4,
    eParentInactivePlayingVideo = 5,
    ePrealloc = 6,
    ePrivilegedabout = 7,
    eRdd = 8,
    eSocket = 9,
    eWebBackground = 10,
    eWebBackgroundPerceivable = 11,
    eWebForeground = 12,
    eExtension = 13,
    eGpu = 14,
    eGmplugin = 15,
    eUtility = 16,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, WakeupsPerProcessTypeLabel> wakeups_per_process_type(5145);
}

namespace power_battery {
  /**
   * generated from power.battery.percentage_when_user_active
   * Records how many percent of battery was available for each period of user activity.
   */
  constexpr impl::CustomDistributionMetric percentage_when_user_active(5146);
}

namespace power_cpu_ms_per_thread {
  /**
   * generated from power.cpu_ms_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentBackgroundLabel> content_background(5147);

  /**
   * generated from power.cpu_ms_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentForegroundLabel> content_foreground(5148);

  /**
   * generated from power.cpu_ms_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuProcessLabel> gpu_process(5149);

  /**
   * generated from power.cpu_ms_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentActiveLabel> parent_active(5150);

  /**
   * generated from power.cpu_ms_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentInactiveLabel> parent_inactive(5151);
}

namespace power_wakeups_per_thread {
  /**
   * generated from power.wakeups_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentBackgroundLabel> content_background(5152);

  /**
   * generated from power.wakeups_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentForegroundLabel> content_foreground(5153);

  /**
   * generated from power.wakeups_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuProcessLabel> gpu_process(5154);

  /**
   * generated from power.wakeups_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentActiveLabel> parent_active(5155);

  /**
   * generated from power.wakeups_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
    eAndroidui = 0,
    eAsynclogger = 1,
    eAudioipc = 2,
    eAudioipcCallbackRpc = 3,
    eAudioipcClientCallback = 4,
    eAudioipcClientRpc = 5,
    eAudioipcDevicecollectionRpc = 6,
    eAudioipcServerCallback = 7,
    eAudioipcServerRpc = 8,
    eBackgroundthreadpool = 9,
    eBgiothreadpool = 10,
    eBgreadurls = 11,
    eBhmgrMonitor = 12,
    eBhmgrProcessor = 13,
    eCamerasIpc = 14,
    eCanvasrenderer = 15,
    eCapturethread = 16,
    eClassifierUpdate = 17,
    eComMta = 18,
    eCompositor = 19,
    eConvolverworker = 20,
    eCookie = 21,
    eCubeboperation = 22,
    eDatachannelIo = 23,
    eDnsResolver = 24,
    eDomWorker = 25,
    eDomWorklet = 26,
    eDomcachethread = 27,
    eExtensionprotocolhandler = 28,
    eFontLoader = 29,
    eFontenumthread = 30,
    eFsBroker = 31,
    eGeckomain = 32,
    eGmpthread = 33,
    eGraphrunner = 34,
    eHrtfdatabaseldr = 35,
    eHtml5Parser = 36,
    eImagebridgechld = 37,
    eImageio = 38,
    eIndexeddb = 39,
    eInitfontlist = 40,
    eInotifyeventthread = 41,
    eIndexeddbIo = 42,
    eIpcIOChild = 43,
    eIpcIOParent = 44,
    eIpcLaunch = 45,
    eIpdlBackground = 46,
    eJsWatchdog = 47,
    eJumpList = 48,
    eLibwebrtcmodulethread = 49,
    eLinkMonitor = 50,
    eLsThread = 51,
    eMdnsService = 52,
    eMediacache = 53,
    eMediadecoderstatemachine = 54,
    eMediapdecoder = 55,
    eMediasupervisor = 56,
    eMediatimer = 57,
    eMediatrackgrph = 58,
    eMemorypoller = 59,
    eMozstorage = 60,
    eMtransport = 61,
    eNetlinkMonitor = 62,
    ePacerthread = 63,
    ePermission = 64,
    ePlayeventsound = 65,
    eProcesshangmon = 66,
    eProfilerchild = 67,
    eProxyresolution = 68,
    eQuotamanagerIo = 69,
    eRegisterfonts = 70,
    eRemotebackbuffer = 71,
    eRemotelzystream = 72,
    eRemvidchild = 73,
    eRenderer = 74,
    eSandboxreporter = 75,
    eSavescripts = 76,
    eSocketThread = 77,
    eSoftwarevsyncthread = 78,
    eSqldbContentPrefsSqlite = 79,
    eSqldbCookiesSqlite = 80,
    eSqldbFormhistorySqlite = 81,
    eSslCert = 82,
    eStartupcache = 83,
    eStreamtrans = 84,
    eStylethread = 85,
    eSwcomposite = 86,
    eTaskcontroller = 87,
    eTimer = 88,
    eToastbgthread = 89,
    eTrrBackground = 90,
    eUntrustedModules = 91,
    eUrlClassifier = 92,
    eVideocapture = 93,
    eVsynciothread = 94,
    eWebrtccallthread = 95,
    eWebrtcworker = 96,
    eWincompositor = 97,
    eWindowsvsyncthread = 98,
    eWinwindowocclusioncalc = 99,
    eWifiTickler = 100,
    eWorkerLauncher = 101,
    eWrrenderbackend = 102,
    eWrscenebuilder = 103,
    eWrscenebuilderlp = 104,
    eWrworker = 105,
    eWrworkerlp = 106,
    e__Other__,
  };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentInactiveLabel> parent_inactive(5156);
}

} // namespace mozilla::glean

#endif // mozilla_GleanProcesstoolsMetrics_h
