// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanServicesCommonMetrics_h
#define mozilla_GleanServicesCommonMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace uptake_remotecontent_result {
  /**
   * generated from uptake.remotecontent.result.uptake_normandy
   */
  struct UptakeNormandyExtra {
    mozilla::Maybe<nsCString> age;
    mozilla::Maybe<nsCString> duration;
    mozilla::Maybe<nsCString> errorname;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> timestamp;
    mozilla::Maybe<nsCString> trigger;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (age) {
        extraKeys.AppendElement()->AssignASCII("age");
        extraValues.EmplaceBack(age.value());
      }
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.EmplaceBack(duration.value());
      }
      if (errorname) {
        extraKeys.AppendElement()->AssignASCII("errorName");
        extraValues.EmplaceBack(errorname.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (timestamp) {
        extraKeys.AppendElement()->AssignASCII("timestamp");
        extraValues.EmplaceBack(timestamp.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Was the remote content successfully pulled? This uptake telemetry allows to monitor the behaviour of our clients when it comes to fetching data from remote servers. This helps defect-detection and allow observation of the proportion of success among clients and sources, the distribution of error causes, and its evolution over time. This event was generated to correspond to the Legacy Telemetry event uptake.remotecontent.result.uptake#normandy.
   */
  constexpr impl::EventMetric<UptakeNormandyExtra> uptake_normandy(4396);

  /**
   * generated from uptake.remotecontent.result.uptake_remotesettings
   */
  struct UptakeRemotesettingsExtra {
    mozilla::Maybe<nsCString> age;
    mozilla::Maybe<nsCString> duration;
    mozilla::Maybe<nsCString> errorname;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> timestamp;
    mozilla::Maybe<nsCString> trigger;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (age) {
        extraKeys.AppendElement()->AssignASCII("age");
        extraValues.EmplaceBack(age.value());
      }
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.EmplaceBack(duration.value());
      }
      if (errorname) {
        extraKeys.AppendElement()->AssignASCII("errorName");
        extraValues.EmplaceBack(errorname.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (timestamp) {
        extraKeys.AppendElement()->AssignASCII("timestamp");
        extraValues.EmplaceBack(timestamp.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Was the remote content successfully pulled? This uptake telemetry allows to monitor the behaviour of our clients when it comes to fetching data from remote servers. This helps defect-detection and allow observation of the proportion of success among clients and sources, the distribution of error causes, and its evolution over time. This event was generated to correspond to the Legacy Telemetry event uptake.remotecontent.result.uptake#remotesettings.
   */
  constexpr impl::EventMetric<UptakeRemotesettingsExtra> uptake_remotesettings(4397);
}

} // namespace mozilla::glean

#endif // mozilla_GleanServicesCommonMetrics_h
