// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanServicesFxaccountsMetrics_h
#define mozilla_GleanServicesFxaccountsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace client_association {
  /**
   * generated from client_association.legacy_client_id
   * The legacy Telemetry client ID associated with this user profile.
   */
  constexpr impl::UuidMetric legacy_client_id(4398);

  /**
   * generated from client_association.uid
   * The Mozilla Account UID associated with the user.
   */
  constexpr impl::StringMetric uid(4399);
}

namespace fxa {
  /**
   * generated from fxa.account_enabled
   * Whether the user's logged in to an FxA account.
   */
  constexpr impl::BooleanMetric account_enabled(4400);

  /**
   * generated from fxa.connect_account
   */
  struct ConnectAccountExtra {
    mozilla::Maybe<nsCString> fxa;
    mozilla::Maybe<nsCString> sync;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxa) {
        extraKeys.AppendElement()->AssignASCII("fxa");
        extraValues.EmplaceBack(fxa.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.EmplaceBack(sync.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when a Firefox Account, or a Firefox Account service, is explicitly connected from the browser via an intentional user action. This event was generated to correspond to the Legacy Telemetry event fxa.connect#account.
   */
  constexpr impl::EventMetric<ConnectAccountExtra> connect_account(4401);

  /**
   * generated from fxa.disconnect_account
   */
  struct DisconnectAccountExtra {
    mozilla::Maybe<nsCString> fxa;
    mozilla::Maybe<nsCString> sync;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxa) {
        extraKeys.AppendElement()->AssignASCII("fxa");
        extraValues.EmplaceBack(fxa.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.EmplaceBack(sync.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when a Firefox Account, or a Firefox Account service, is explicitly disconnected from the browser via an intentional user action. This event was generated to correspond to the Legacy Telemetry event fxa.disconnect#account.
   */
  constexpr impl::EventMetric<DisconnectAccountExtra> disconnect_account(4402);

  /**
   * generated from fxa.sync_enabled
   * Whether the weave service is present and enabled.
   * Implies `fxa.account_enabled`.
   */
  constexpr impl::BooleanMetric sync_enabled(4403);
}

namespace sync_settings {
  /**
   * generated from sync_settings.open_choose_what_to_sync_menu
   */
  struct OpenChooseWhatToSyncMenuExtra {
    mozilla::Maybe<nsCString> why;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (why) {
        extraKeys.AppendElement()->AssignASCII("why");
        extraValues.EmplaceBack(why.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when the user opens the choose what to sync menu.
   */
  constexpr impl::EventMetric<OpenChooseWhatToSyncMenuExtra> open_choose_what_to_sync_menu(4404);

  /**
   * generated from sync_settings.save
   */
  /**
   * Records when the user clicks the save button after opening the choose what to sync menu.
   */
  constexpr impl::EventMetric<NoExtraKeys> save(4405);
}

} // namespace mozilla::glean

#endif // mozilla_GleanServicesFxaccountsMetrics_h
