// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanServicesSyncModulesMetrics_h
#define mozilla_GleanServicesSyncModulesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace deletion_request {
  /**
   * generated from deletion.request.sync_device_id
   * An identifier used by sync ping, to identify the current Firefox profile for a specific Account. This metric was generated to correspond to the Legacy Telemetry scalar deletion.request.sync_device_id.
   */
  constexpr impl::StringMetric sync_device_id(527);
}

namespace synced_tabs {
  /**
   * generated from synced_tabs.click_fxa_app_menu
   */
  struct ClickFxaAppMenuExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#fxa_app_menu.
   */
  constexpr impl::EventMetric<ClickFxaAppMenuExtra> click_fxa_app_menu(864);

  /**
   * generated from synced_tabs.click_fxa_avatar_menu
   */
  struct ClickFxaAvatarMenuExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#fxa_avatar_menu.
   */
  constexpr impl::EventMetric<ClickFxaAvatarMenuExtra> click_fxa_avatar_menu(865);

  /**
   * generated from synced_tabs.click_synced_tabs_sidebar
   */
  struct ClickSyncedTabsSidebarExtra {
    mozilla::Maybe<nsCString> filter;
    mozilla::Maybe<nsCString> tabPos;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (filter) {
        extraKeys.AppendElement()->AssignASCII("filter");
        extraValues.EmplaceBack(filter.value());
      }
      if (tabPos) {
        extraKeys.AppendElement()->AssignASCII("tab_pos");
        extraValues.EmplaceBack(tabPos.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record how users access and use synced tabs component This event was generated to correspond to the Legacy Telemetry event synced_tabs.click#synced_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncedTabsSidebarExtra> click_synced_tabs_sidebar(866);
}

namespace fxa_app_menu {
  /**
   * generated from fxa_app_menu.click_account_settings
   */
  struct ClickAccountSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#account_settings.
   */
  constexpr impl::EventMetric<ClickAccountSettingsExtra> click_account_settings(4406);

  /**
   * generated from fxa_app_menu.click_cad
   */
  struct ClickCadExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#cad.
   */
  constexpr impl::EventMetric<ClickCadExtra> click_cad(4407);

  /**
   * generated from fxa_app_menu.click_login
   */
  struct ClickLoginExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#login.
   */
  constexpr impl::EventMetric<ClickLoginExtra> click_login(4408);

  /**
   * generated from fxa_app_menu.click_monitor_cta
   */
  struct ClickMonitorCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#monitor_cta.
   */
  constexpr impl::EventMetric<ClickMonitorCtaExtra> click_monitor_cta(4409);

  /**
   * generated from fxa_app_menu.click_open_monitor
   */
  struct ClickOpenMonitorExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#open_monitor.
   */
  constexpr impl::EventMetric<ClickOpenMonitorExtra> click_open_monitor(4410);

  /**
   * generated from fxa_app_menu.click_open_send
   */
  struct ClickOpenSendExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#open_send.
   */
  constexpr impl::EventMetric<ClickOpenSendExtra> click_open_send(4411);

  /**
   * generated from fxa_app_menu.click_relay_cta
   */
  struct ClickRelayCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#relay_cta.
   */
  constexpr impl::EventMetric<ClickRelayCtaExtra> click_relay_cta(4412);

  /**
   * generated from fxa_app_menu.click_send_tab
   */
  struct ClickSendTabExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#send_tab.
   */
  constexpr impl::EventMetric<ClickSendTabExtra> click_send_tab(4413);

  /**
   * generated from fxa_app_menu.click_sync_cta
   */
  struct ClickSyncCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_cta.
   */
  constexpr impl::EventMetric<ClickSyncCtaExtra> click_sync_cta(4414);

  /**
   * generated from fxa_app_menu.click_sync_now
   */
  struct ClickSyncNowExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_now.
   */
  constexpr impl::EventMetric<ClickSyncNowExtra> click_sync_now(4415);

  /**
   * generated from fxa_app_menu.click_sync_settings
   */
  struct ClickSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_settings.
   */
  constexpr impl::EventMetric<ClickSyncSettingsExtra> click_sync_settings(4416);

  /**
   * generated from fxa_app_menu.click_sync_tabs
   */
  struct ClickSyncTabsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_tabs.
   */
  constexpr impl::EventMetric<ClickSyncTabsExtra> click_sync_tabs(4417);

  /**
   * generated from fxa_app_menu.click_sync_tabs_sidebar
   */
  struct ClickSyncTabsSidebarExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#sync_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncTabsSidebarExtra> click_sync_tabs_sidebar(4418);

  /**
   * generated from fxa_app_menu.click_toolbar_icon
   */
  struct ClickToolbarIconExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#toolbar_icon.
   */
  constexpr impl::EventMetric<ClickToolbarIconExtra> click_toolbar_icon(4419);

  /**
   * generated from fxa_app_menu.click_unver_sync_settings
   */
  struct ClickUnverSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#unver_sync_settings.
   */
  constexpr impl::EventMetric<ClickUnverSyncSettingsExtra> click_unver_sync_settings(4420);

  /**
   * generated from fxa_app_menu.click_vpn_cta
   */
  struct ClickVpnCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA menu in the app (hamburger) menu This event was generated to correspond to the Legacy Telemetry event fxa_app_menu.click#vpn_cta.
   */
  constexpr impl::EventMetric<ClickVpnCtaExtra> click_vpn_cta(4421);
}

namespace fxa_avatar_menu {
  /**
   * generated from fxa_avatar_menu.click_account_settings
   */
  struct ClickAccountSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#account_settings.
   */
  constexpr impl::EventMetric<ClickAccountSettingsExtra> click_account_settings(4422);

  /**
   * generated from fxa_avatar_menu.click_cad
   */
  struct ClickCadExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#cad.
   */
  constexpr impl::EventMetric<ClickCadExtra> click_cad(4423);

  /**
   * generated from fxa_avatar_menu.click_login
   */
  struct ClickLoginExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#login.
   */
  constexpr impl::EventMetric<ClickLoginExtra> click_login(4424);

  /**
   * generated from fxa_avatar_menu.click_monitor_cta
   */
  struct ClickMonitorCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#monitor_cta.
   */
  constexpr impl::EventMetric<ClickMonitorCtaExtra> click_monitor_cta(4425);

  /**
   * generated from fxa_avatar_menu.click_open_monitor
   */
  struct ClickOpenMonitorExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#open_monitor.
   */
  constexpr impl::EventMetric<ClickOpenMonitorExtra> click_open_monitor(4426);

  /**
   * generated from fxa_avatar_menu.click_open_send
   */
  struct ClickOpenSendExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#open_send.
   */
  constexpr impl::EventMetric<ClickOpenSendExtra> click_open_send(4427);

  /**
   * generated from fxa_avatar_menu.click_relay_cta
   */
  struct ClickRelayCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#relay_cta.
   */
  constexpr impl::EventMetric<ClickRelayCtaExtra> click_relay_cta(4428);

  /**
   * generated from fxa_avatar_menu.click_send_tab
   */
  struct ClickSendTabExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#send_tab.
   */
  constexpr impl::EventMetric<ClickSendTabExtra> click_send_tab(4429);

  /**
   * generated from fxa_avatar_menu.click_sync_cta
   */
  struct ClickSyncCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_cta.
   */
  constexpr impl::EventMetric<ClickSyncCtaExtra> click_sync_cta(4430);

  /**
   * generated from fxa_avatar_menu.click_sync_now
   */
  struct ClickSyncNowExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_now.
   */
  constexpr impl::EventMetric<ClickSyncNowExtra> click_sync_now(4431);

  /**
   * generated from fxa_avatar_menu.click_sync_settings
   */
  struct ClickSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_settings.
   */
  constexpr impl::EventMetric<ClickSyncSettingsExtra> click_sync_settings(4432);

  /**
   * generated from fxa_avatar_menu.click_sync_tabs
   */
  struct ClickSyncTabsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_tabs.
   */
  constexpr impl::EventMetric<ClickSyncTabsExtra> click_sync_tabs(4433);

  /**
   * generated from fxa_avatar_menu.click_sync_tabs_sidebar
   */
  struct ClickSyncTabsSidebarExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#sync_tabs_sidebar.
   */
  constexpr impl::EventMetric<ClickSyncTabsSidebarExtra> click_sync_tabs_sidebar(4434);

  /**
   * generated from fxa_avatar_menu.click_toolbar_icon
   */
  struct ClickToolbarIconExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#toolbar_icon.
   */
  constexpr impl::EventMetric<ClickToolbarIconExtra> click_toolbar_icon(4435);

  /**
   * generated from fxa_avatar_menu.click_unver_sync_settings
   */
  struct ClickUnverSyncSettingsExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#unver_sync_settings.
   */
  constexpr impl::EventMetric<ClickUnverSyncSettingsExtra> click_unver_sync_settings(4436);

  /**
   * generated from fxa_avatar_menu.click_vpn_cta
   */
  struct ClickVpnCtaExtra {
    mozilla::Maybe<nsCString> fxaAvatar;
    mozilla::Maybe<nsCString> fxaStatus;
    mozilla::Maybe<nsCString> fxaSyncOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxaAvatar) {
        extraKeys.AppendElement()->AssignASCII("fxa_avatar");
        extraValues.EmplaceBack(fxaAvatar.value());
      }
      if (fxaStatus) {
        extraKeys.AppendElement()->AssignASCII("fxa_status");
        extraValues.EmplaceBack(fxaStatus.value());
      }
      if (fxaSyncOn) {
        extraKeys.AppendElement()->AssignASCII("fxa_sync_on");
        extraValues.EmplaceBack(fxaSyncOn.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded on interactions with the FxA avatar menu on the toolbar This event was generated to correspond to the Legacy Telemetry event fxa_avatar_menu.click#vpn_cta.
   */
  constexpr impl::EventMetric<ClickVpnCtaExtra> click_vpn_cta(4437);
}

namespace sync {
  /**
   * generated from sync.device_count_desktop
   * Number of desktop devices (including this device) associated with this Sync account. Recorded each time Sync successfully completes the 'clients' engine.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEAVE_DEVICE_COUNT_DESKTOP.
   */
  constexpr impl::CustomDistributionMetric device_count_desktop(4438);

  /**
   * generated from sync.device_count_mobile
   * Number of mobile devices associated with this Sync account. Recorded each time Sync successfully completes the 'clients' engine.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEAVE_DEVICE_COUNT_MOBILE.
   */
  constexpr impl::CustomDistributionMetric device_count_mobile(4439);
}

namespace sync_merge_dialog {
  /**
   * generated from sync_merge_dialog.clicked
   */
  struct ClickedExtra {
    mozilla::Maybe<nsCString> optionClicked;
    mozilla::Maybe<nsCString> variantShown;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (optionClicked) {
        extraKeys.AppendElement()->AssignASCII("option_clicked");
        extraValues.EmplaceBack(optionClicked.value());
      }
      if (variantShown) {
        extraKeys.AppendElement()->AssignASCII("variant_shown");
        extraValues.EmplaceBack(variantShown.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Event to record that showed the user a warning for potentially merging data from multiple accounts and recorded
   */
  constexpr impl::EventMetric<ClickedExtra> clicked(4440);
}

} // namespace mozilla::glean

#endif // mozilla_GleanServicesSyncModulesMetrics_h
