// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitModulesMetrics_h
#define mozilla_GleanToolkitModulesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace os_environment {
  /**
   * generated from os.environment.allowed_app_sources
   * Indicates what sources the OS is currently configured to allow apps to be installed from. Possible values are "Anywhere", "Recommendations", "PreferStore", "StoreOnly", "NoSuchFeature", or "Error". "Recommendations" allows installs from anywhere, but recommends a comparable app from the store, if available. "NoSuchFeature" will be reported on versions of Windows that do not have an app source setting. This metric was generated to correspond to the Legacy Telemetry scalar os.environment.allowed_app_sources.
   */
  constexpr impl::StringMetric allowed_app_sources(417);
}

namespace first_startup {
  /**
   * generated from first_startup.delete_tasks_time
   * Number of milliseconds until TaskScheduler.deleteAllTasks resolved in FirstStartup.
   */
  constexpr impl::QuantityMetric delete_tasks_time(5673);

  /**
   * generated from first_startup.elapsed
   * Number of milliseconds the FirstStartup service took to run.
   */
  constexpr impl::QuantityMetric elapsed(5674);

  /**
   * generated from first_startup.new_profile
   * True if FirstStartup was initted after a new profile was just created. If false, this means that FirstStartup was initted with a pre-existing profile, which is a no-op.
   */
  constexpr impl::BooleanMetric new_profile(5675);

  /**
   * generated from first_startup.normandy_init_time
   * Number of milliseconds until Normandy.init resolved in FirstStartup.
   */
  constexpr impl::QuantityMetric normandy_init_time(5676);

  /**
   * generated from first_startup.status_code
   * Status of the FirstStartup service, which runs
   * post-install/early-startup in Firefox.
   */
  constexpr impl::QuantityMetric status_code(5677);
}

namespace jsonfile {
  /**
   * generated from jsonfile.load_autofillprofiles
   */
  struct LoadAutofillprofilesExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when JSONFile.sys.mjs consumers are trying to access a missing or corrupt json file. For example, Login Store trying to access logins.json when it has gone missing or corrupt. This event was generated to correspond to the Legacy Telemetry event jsonfile.load#autofillprofiles.
   */
  constexpr impl::EventMetric<LoadAutofillprofilesExtra> load_autofillprofiles(5678);

  /**
   * generated from jsonfile.load_logins
   */
  struct LoadLoginsExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when JSONFile.sys.mjs consumers are trying to access a missing or corrupt json file. For example, Login Store trying to access logins.json when it has gone missing or corrupt. This event was generated to correspond to the Legacy Telemetry event jsonfile.load#logins.
   */
  constexpr impl::EventMetric<LoadLoginsExtra> load_logins(5679);
}

namespace newtab_page {
  /**
   * generated from newtab_page.blocked_sites_count
   * Number of sites blocked from the new tab page.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NEWTAB_PAGE_BLOCKED_SITES_COUNT.
   */
  constexpr impl::CustomDistributionMetric blocked_sites_count(5680);

  /**
   * generated from newtab_page.pinned_sites_count
   * Number of pinned sites on the new tab page.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NEWTAB_PAGE_PINNED_SITES_COUNT.
   */
  constexpr impl::CustomDistributionMetric pinned_sites_count(5681);
}

namespace popup_notification {
  /**
   * generated from popup_notification.dismissal
   * (Bug 1207089) Time in ms between displaying a popup notification and dismissing it without an action the first time, keyed by ID
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram POPUP_NOTIFICATION_DISMISSAL_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> dismissal(5682);

  /**
   * generated from popup_notification.main_action
   * (Bug 1207089) Time in ms between initially requesting a popup notification and triggering the main action, keyed by ID
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram POPUP_NOTIFICATION_MAIN_ACTION_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> main_action(5683);

  /**
   * generated from popup_notification.stats
   * (Bug 1207089) Usage of popup notifications, keyed by ID (0 = Offered, 1..4 = Action (3 is unused), 5 = Click outside (unused), 6 = Leave page, 7 = Use 'X' (unused), 8 = Not now (unused), 10 = Open submenu, 11 = Learn more. Add 20 if happened after reopen.)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram POPUP_NOTIFICATION_STATS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> stats(5684);
}

namespace service_request {
  /**
   * generated from service_request.bypass_proxy_info
   */
  struct BypassProxyInfoExtra {
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> type;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (type) {
        extraKeys.AppendElement()->AssignASCII("type");
        extraValues.EmplaceBack(type.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This event is recorded by a small set of services when a proxy failure causes a service to re-request with a proxy bypass.  It records some basic information such as the type of proxy configuration, and the source of the proxy configuration.  The value of the event is the name of the service that triggers the event (e.g. telemetry, remote-settings). This event was generated to correspond to the Legacy Telemetry event service_request.bypass#proxy_info.
   */
  constexpr impl::EventMetric<BypassProxyInfoExtra> bypass_proxy_info(5685);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitModulesMetrics_h
