// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsUpdateMetrics_h
#define mozilla_GleanToolkitMozappsUpdateMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace update {
  /**
   * generated from update.bits_result_complete
   * Update: Result code from downloading a complete update via BITS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_BITS_RESULT_COMPLETE.
   */
  constexpr impl::CustomDistributionMetric bits_result_complete(5785);

  /**
   * generated from update.bits_result_partial
   * Update: Result code from downloading a partial update via BITS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_BITS_RESULT_PARTIAL.
   */
  constexpr impl::CustomDistributionMetric bits_result_partial(5786);

  /**
   * generated from update.can_use_bits_external
   */
  enum class CanUseBitsExternalLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric, CanUseBitsExternalLabel> can_use_bits_external(5787);

  /**
   * generated from update.can_use_bits_notify
   */
  enum class CanUseBitsNotifyLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric, CanUseBitsNotifyLabel> can_use_bits_notify(5788);

  /**
   * generated from update.can_use_bits_subsequent
   */
  enum class CanUseBitsSubsequentLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric, CanUseBitsSubsequentLabel> can_use_bits_subsequent(5789);

  /**
   * generated from update.cannot_stage_external
   * Update: count of systems that cannot stage updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_EXTERNAL.
   */
  constexpr impl::CounterMetric cannot_stage_external(5790);

  /**
   * generated from update.cannot_stage_notify
   * Update: count of systems that cannot stage updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_NOTIFY.
   */
  constexpr impl::CounterMetric cannot_stage_notify(5791);

  /**
   * generated from update.cannot_stage_subsequent
   * Update: count of systems that cannot stage updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_SUBSEQUENT.
   */
  constexpr impl::CounterMetric cannot_stage_subsequent(5792);

  /**
   * generated from update.check_code_external
   * Update: background update check result code except for no updates found (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric check_code_external(5793);

  /**
   * generated from update.check_code_notify
   * Update: background update check result code except for no updates found (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric check_code_notify(5794);

  /**
   * generated from update.check_code_subsequent
   * Update: background update check result code except for no updates found (after we already have an update ready). Possible codes are enumerated by constants starting with CHK_ in toolkit/mozapps/update/UpdateTelemetry.sys.mjs
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric check_code_subsequent(5795);

  /**
   * generated from update.check_extended_error_external
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> check_extended_error_external(5796);

  /**
   * generated from update.check_extended_error_notify
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> check_extended_error_notify(5797);

  /**
   * generated from update.check_extended_error_subsequent
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> check_extended_error_subsequent(5798);

  /**
   * generated from update.check_no_update_external
   * Update: count of no updates were found for a background update check (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_EXTERNAL.
   */
  constexpr impl::CounterMetric check_no_update_external(5799);

  /**
   * generated from update.check_no_update_notify
   * Update: count of no updates were found for a background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_NOTIFY.
   */
  constexpr impl::CounterMetric check_no_update_notify(5800);

  /**
   * generated from update.check_no_update_subsequent
   * Update: count of no updates were found for a background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_SUBSEQUENT.
   */
  constexpr impl::CounterMetric check_no_update_subsequent(5801);

  /**
   * generated from update.download_code_complete
   * Update: complete patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_COMPLETE.
   */
  constexpr impl::CustomDistributionMetric download_code_complete(5802);

  /**
   * generated from update.download_code_partial
   * Update: partial patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_PARTIAL.
   */
  constexpr impl::CustomDistributionMetric download_code_partial(5803);

  /**
   * generated from update.download_code_unknown
   * Update: unknown patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_UNKNOWN.
   */
  constexpr impl::CustomDistributionMetric download_code_unknown(5804);

  /**
   * generated from update.invalid_lastupdatetime_external
   * Update: count of systems that have a last update time greater than the current time (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_EXTERNAL.
   */
  constexpr impl::CounterMetric invalid_lastupdatetime_external(5805);

  /**
   * generated from update.invalid_lastupdatetime_notify
   * Update: count of systems that have a last update time greater than the current time (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_NOTIFY.
   */
  constexpr impl::CounterMetric invalid_lastupdatetime_notify(5806);

  /**
   * generated from update.invalid_lastupdatetime_subsequent
   * Update: count of systems that have a last update time greater than the current time (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_SUBSEQUENT.
   */
  constexpr impl::CounterMetric invalid_lastupdatetime_subsequent(5807);

  /**
   * generated from update.langpack_overtime
   * Update: How much longer langpacks took to download than the app update in seconds.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram UPDATE_LANGPACK_OVERTIME.
   */
  constexpr impl::TimingDistributionMetric langpack_overtime(5808);

  /**
   * generated from update.last_notify_interval_days_external
   * Update: interval in days since the last background update check (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_EXTERNAL.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_external(5809);

  /**
   * generated from update.last_notify_interval_days_notify
   * Update: interval in days since the last background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_NOTIFY.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_notify(5810);

  /**
   * generated from update.last_notify_interval_days_subsequent
   * Update: interval in days since the last background update check (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_SUBSEQUENT.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_subsequent(5811);

  /**
   * generated from update.not_pref_update_auto_external
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_EXTERNAL.
   */
  constexpr impl::CounterMetric not_pref_update_auto_external(5812);

  /**
   * generated from update.not_pref_update_auto_notify
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_NOTIFY.
   */
  constexpr impl::CounterMetric not_pref_update_auto_notify(5813);

  /**
   * generated from update.not_pref_update_auto_subsequent
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_SUBSEQUENT.
   */
  constexpr impl::CounterMetric not_pref_update_auto_subsequent(5814);

  /**
   * generated from update.not_pref_update_service_enabled_external
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_EXTERNAL.
   */
  constexpr impl::CounterMetric not_pref_update_service_enabled_external(5815);

  /**
   * generated from update.not_pref_update_service_enabled_notify
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_NOTIFY.
   */
  constexpr impl::CounterMetric not_pref_update_service_enabled_notify(5816);

  /**
   * generated from update.not_pref_update_service_enabled_subsequent
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric not_pref_update_service_enabled_subsequent(5817);

  /**
   * generated from update.not_pref_update_staging_enabled_external
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_EXTERNAL.
   */
  constexpr impl::CounterMetric not_pref_update_staging_enabled_external(5818);

  /**
   * generated from update.not_pref_update_staging_enabled_notify
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_NOTIFY.
   */
  constexpr impl::CounterMetric not_pref_update_staging_enabled_notify(5819);

  /**
   * generated from update.not_pref_update_staging_enabled_subsequent
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric not_pref_update_staging_enabled_subsequent(5820);

  /**
   * generated from update.notification_badge_shown
   */
  enum class NotificationBadgeShownLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the application update badge type that was displayed.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_BADGE_SHOWN.
   */
  constexpr impl::Labeled<impl::CounterMetric, NotificationBadgeShownLabel> notification_badge_shown(5821);

  /**
   * generated from update.notification_dismissed
   */
  enum class NotificationDismissedLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the dismiss action was executed for this application update doorhanger type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_DISMISSED.
   */
  constexpr impl::Labeled<impl::CounterMetric, NotificationDismissedLabel> notification_dismissed(5822);

  /**
   * generated from update.notification_main_action_doorhanger
   */
  enum class NotificationMainActionDoorhangerLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the main update action was initiated for this application update doorhanger type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_MAIN_ACTION_DOORHANGER.
   */
  constexpr impl::Labeled<impl::CounterMetric, NotificationMainActionDoorhangerLabel> notification_main_action_doorhanger(5823);

  /**
   * generated from update.notification_main_action_menu
   */
  enum class NotificationMainActionMenuLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the update action was initiated from the PanelUI application update menu item.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_MAIN_ACTION_MENU.
   */
  constexpr impl::Labeled<impl::CounterMetric, NotificationMainActionMenuLabel> notification_main_action_menu(5824);

  /**
   * generated from update.notification_shown
   */
  enum class NotificationShownLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the application update doorhanger type that was displayed.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_SHOWN.
   */
  constexpr impl::Labeled<impl::CounterMetric, NotificationShownLabel> notification_shown(5825);

  /**
   * generated from update.ping_count_external
   * Update: count of systems for this ping for comparison with other pings (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_EXTERNAL.
   */
  constexpr impl::CounterMetric ping_count_external(5826);

  /**
   * generated from update.ping_count_notify
   * Update: count of systems for this ping for comparison with other pings (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_NOTIFY.
   */
  constexpr impl::CounterMetric ping_count_notify(5827);

  /**
   * generated from update.ping_count_subsequent
   * Update: count of systems for this ping for comparison with other pings (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_SUBSEQUENT.
   */
  constexpr impl::CounterMetric ping_count_subsequent(5828);

  /**
   * generated from update.pref_service_errors_external
   * Update: number of sequential update service errors greater than 0 (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_external(5829);

  /**
   * generated from update.pref_service_errors_notify
   * Update: number of sequential update service errors greater than 0 (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_notify(5830);

  /**
   * generated from update.pref_service_errors_subsequent
   * Update: number of sequential update service errors greater than 0 (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_subsequent(5831);

  /**
   * generated from update.pref_update_cancelations_external
   * Update: number of sequential update elevation request cancelations greater than 0 (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_external(5832);

  /**
   * generated from update.pref_update_cancelations_notify
   * Update: number of sequential update elevation request cancelations greater than 0 (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_notify(5833);

  /**
   * generated from update.pref_update_cancelations_subsequent
   * Update: number of sequential update elevation request cancelations greater than 0 (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_subsequent(5834);

  /**
   * generated from update.service_installed_external
   */
  enum class ServiceInstalledExternalLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric, ServiceInstalledExternalLabel> service_installed_external(5835);

  /**
   * generated from update.service_installed_notify
   */
  enum class ServiceInstalledNotifyLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric, ServiceInstalledNotifyLabel> service_installed_notify(5836);

  /**
   * generated from update.service_installed_subsequent
   */
  enum class ServiceInstalledSubsequentLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric, ServiceInstalledSubsequentLabel> service_installed_subsequent(5837);

  /**
   * generated from update.service_manually_uninstalled_external
   * Update: count of systems that manually uninstalled the service (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_EXTERNAL.
   */
  constexpr impl::CounterMetric service_manually_uninstalled_external(5838);

  /**
   * generated from update.service_manually_uninstalled_notify
   * Update: count of systems that manually uninstalled the service (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_NOTIFY.
   */
  constexpr impl::CounterMetric service_manually_uninstalled_notify(5839);

  /**
   * generated from update.service_manually_uninstalled_subsequent
   * Update: count of systems that manually uninstalled the service (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric service_manually_uninstalled_subsequent(5840);

  /**
   * generated from update.state_code_complete_stage
   * Update: the state of a complete patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_COMPLETE_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_complete_stage(5841);

  /**
   * generated from update.state_code_complete_startup
   * Update: the state of a complete update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_COMPLETE_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_complete_startup(5842);

  /**
   * generated from update.state_code_partial_stage
   * Update: the state of a partial patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_PARTIAL_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_partial_stage(5843);

  /**
   * generated from update.state_code_partial_startup
   * Update: the state of a partial patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_PARTIAL_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_partial_startup(5844);

  /**
   * generated from update.state_code_unknown_stage
   * Update: the state of an unknown patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_UNKNOWN_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_unknown_stage(5845);

  /**
   * generated from update.state_code_unknown_startup
   * Update: the state of an unknown patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_UNKNOWN_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_unknown_startup(5846);

  /**
   * generated from update.status_error_code_complete_stage
   * Update: the status error code for a failed complete patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_COMPLETE_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_complete_stage(5847);

  /**
   * generated from update.status_error_code_complete_startup
   * Update: the status error code for a failed complete patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_COMPLETE_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_complete_startup(5848);

  /**
   * generated from update.status_error_code_partial_stage
   * Update: the status error code for a failed partial patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_PARTIAL_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_partial_stage(5849);

  /**
   * generated from update.status_error_code_partial_startup
   * Update: the status error code for a failed partial patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_PARTIAL_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_partial_startup(5850);

  /**
   * generated from update.status_error_code_unknown_stage
   * Update: the status error code for a failed unknown patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_UNKNOWN_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_unknown_stage(5851);

  /**
   * generated from update.status_error_code_unknown_startup
   * Update: the status error code for a failed unknown patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_UNKNOWN_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_unknown_startup(5852);

  /**
   * generated from update.unable_to_apply_external
   * Update: count of systems that cannot apply updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_EXTERNAL.
   */
  constexpr impl::CounterMetric unable_to_apply_external(5853);

  /**
   * generated from update.unable_to_apply_notify
   * Update: count of systems that cannot apply updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_NOTIFY.
   */
  constexpr impl::CounterMetric unable_to_apply_notify(5854);

  /**
   * generated from update.unable_to_apply_subsequent
   * Update: count of systems that cannot apply updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_SUBSEQUENT.
   */
  constexpr impl::CounterMetric unable_to_apply_subsequent(5855);
}

namespace update_settings {
  /**
   * generated from update.settings.auto_download
   * Whether app updates are set to auto-download.
   */
  constexpr impl::BooleanMetric auto_download(5861);

  /**
   * generated from update.settings.background
   * Whether updates can be delivered in the background.
   */
  constexpr impl::BooleanMetric background(5862);

  /**
   * generated from update.settings.channel
   * The update channel according to defaults,
   * including partner bits.
   * e.g. "nightly-cck"
   */
  constexpr impl::StringMetric channel(5863);

  /**
   * generated from update.settings.enabled
   * Whether updates are available.
   */
  constexpr impl::BooleanMetric enabled(5864);
}

namespace updater {
  /**
   * generated from updater.available
   * Whether the app was built with the updater binary.
   * Corresponds to the value of the `MOZ_UPDATER` define.
   */
  constexpr impl::BooleanMetric available(5865);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsUpdateMetrics_h
