// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanUrlbarMetrics_h
#define mozilla_GleanUrlbarMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace quick_suggest {
  /**
   * generated from quick_suggest.advertiser
   * The name of the advertiser providing the sponsored TopSite.
   */
  constexpr impl::StringMetric advertiser(923);

  /**
   * generated from quick_suggest.block_id
   * A unique identifier for the suggestion (a.k.a. a keywords block).
   */
  constexpr impl::StringMetric block_id(924);

  /**
   * generated from quick_suggest.context_id
   * An identifier to identify users for Contextual Services user interaction pings.
   */
  constexpr impl::UuidMetric context_id(925);

  /**
   * generated from quick_suggest.country
   * Records the home region of the user as determined by `Region.sys.mjs` and the `browser.search.region` pref.
   */
  constexpr impl::StringMetric country(926);

  /**
   * generated from quick_suggest.iab_category
   * The suggestion's category. Either "22 - Shopping" or "5 - Educational".
   */
  constexpr impl::StringMetric iab_category(927);

  /**
   * generated from quick_suggest.improve_suggest_experience
   * Whether the "Improve Suggest Experience" checkbox is checked.
   */
  constexpr impl::BooleanMetric improve_suggest_experience(928);

  /**
   * generated from quick_suggest.is_clicked
   * Whether this quicksuggest-impression ping was for an item that was clicked.
   */
  constexpr impl::BooleanMetric is_clicked(929);

  /**
   * generated from quick_suggest.match_type
   * Whether this was a best/top match or not. Either "best-match" or "firefox-suggest".
   */
  constexpr impl::StringMetric match_type(930);

  /**
   * generated from quick_suggest.ping_type
   * The ping's type. In other situations might be designated by an event's name or an interaction field. E.g. "quicksuggest-impression", "quicksuggest-block", "quicksuggest-click".
   */
  constexpr impl::StringMetric ping_type(931);

  /**
   * generated from quick_suggest.position
   * The position (1-based) of the QuickSuggest item being interatcted with.
   */
  constexpr impl::QuantityMetric position(932);

  /**
   * generated from quick_suggest.reporting_url
   * The url to report this interaction to.
   */
  constexpr impl::UrlMetric reporting_url(933);

  /**
   * generated from quick_suggest.request_id
   * A request identifier for each API request to [Merino](https://mozilla-services.github.io/merino/). Only present for suggestions provided by Merino.
   */
  constexpr impl::StringMetric request_id(934);

  /**
   * generated from quick_suggest.source
   * The source of the interaction. E.g. "urlbar".
   */
  constexpr impl::StringMetric source(935);

  /**
   * generated from quick_suggest.suggested_index
   * A stringified integer value that is the intended index of the suggestion being interacted with. If `suggested_index_relative_to_group` is true, the index is relative to the "Firefox Suggest" group; otherwise the index is relative to the entire list of suggestions. Non-negative values (starting at 0) are relative to the start/top of the group/list; negative values are relative to the end/bottom of the group/list.
   */
  constexpr impl::StringMetric suggested_index(936);

  /**
   * generated from quick_suggest.suggested_index_relative_to_group
   * Whether `suggested_index` is relative to the "Firefox Suggest" group. If false, it is relative to the entire list of suggestions.
   */
  constexpr impl::BooleanMetric suggested_index_relative_to_group(937);
}

namespace suggest {
  /**
   * generated from suggest.ingest_download_time
   */
  enum class IngestDownloadTimeLabel: uint16_t {
    eIcon = 0,
    eAmp = 1,
    eWikipedia = 2,
    eAmoSuggestions = 3,
    ePocketSuggestions = 4,
    eYelpSuggestions = 5,
    eMdnSuggestions = 6,
    eWeather = 7,
    eConfiguration = 8,
    eFakespotSuggestions = 9,
    e__Other__,
  };
  /**
   * Download time for ingestion, labelled by record type
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, IngestDownloadTimeLabel> ingest_download_time(938);

  /**
   * generated from suggest.ingest_time
   */
  enum class IngestTimeLabel: uint16_t {
    eIcon = 0,
    eAmp = 1,
    eWikipedia = 2,
    eAmoSuggestions = 3,
    ePocketSuggestions = 4,
    eYelpSuggestions = 5,
    eMdnSuggestions = 6,
    eWeather = 7,
    eConfiguration = 8,
    eFakespotSuggestions = 9,
    e__Other__,
  };
  /**
   * Time for ingestion (excluding download time), labelled by record type
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, IngestTimeLabel> ingest_time(939);

  /**
   * generated from suggest.query_time
   */
  enum class QueryTimeLabel: uint16_t {
    eAmp = 0,
    eWikipedia = 1,
    eAmo = 2,
    ePocket = 3,
    eYelp = 4,
    eMdn = 5,
    eWeather = 6,
    eFakespot = 7,
    e__Other__,
  };
  /**
   * Time executing queries, labelled by provider type
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, QueryTimeLabel> query_time(940);
}

namespace suggest_relevance {
  /**
   * generated from suggest_relevance.outcome
   */
  enum class OutcomeLabel: uint16_t {
    eBoosted = 0,
    eDecreased = 1,
    e__Other__,
  };
  /**
   * For each successful scoring, count whether the relevance score gets boosted or decreased over the original score. Note that given how the score is calculated, it's practically impossible to have the two scores tied. If that's the case anyhow, it will increment the "boosted" counter.
   */
  constexpr impl::Labeled<impl::CounterMetric, OutcomeLabel> outcome(941);

  /**
   * generated from suggest_relevance.status
   */
  enum class StatusLabel: uint16_t {
    eSuccess = 0,
    eFailure = 1,
    e__Other__,
  };
  /**
   * Count the successful / failed attempts of relevance scoring in Firefox Suggest.
   */
  constexpr impl::Labeled<impl::CounterMetric, StatusLabel> status(942);
}

namespace urlbar {
  /**
   * generated from urlbar.abandonment
   */
  struct AbandonmentExtra {
    mozilla::Maybe<nsCString> abandonmentType;
    mozilla::Maybe<nsCString> actions;
    mozilla::Maybe<nsCString> groups;
    mozilla::Maybe<nsCString> interaction;
    mozilla::Maybe<uint32_t> nChars;
    mozilla::Maybe<uint32_t> nResults;
    mozilla::Maybe<uint32_t> nWords;
    mozilla::Maybe<nsCString> results;
    mozilla::Maybe<nsCString> sap;
    mozilla::Maybe<nsCString> searchEngineDefaultId;
    mozilla::Maybe<nsCString> searchMode;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (abandonmentType) {
        extraKeys.AppendElement()->AssignASCII("abandonment_type");
        extraValues.EmplaceBack(abandonmentType.value());
      }
      if (actions) {
        extraKeys.AppendElement()->AssignASCII("actions");
        extraValues.EmplaceBack(actions.value());
      }
      if (groups) {
        extraKeys.AppendElement()->AssignASCII("groups");
        extraValues.EmplaceBack(groups.value());
      }
      if (interaction) {
        extraKeys.AppendElement()->AssignASCII("interaction");
        extraValues.EmplaceBack(interaction.value());
      }
      if (nChars) {
        extraKeys.AppendElement()->AssignASCII("n_chars");
        extraValues.AppendElement()->AppendInt(nChars.value());
      }
      if (nResults) {
        extraKeys.AppendElement()->AssignASCII("n_results");
        extraValues.AppendElement()->AppendInt(nResults.value());
      }
      if (nWords) {
        extraKeys.AppendElement()->AssignASCII("n_words");
        extraValues.AppendElement()->AppendInt(nWords.value());
      }
      if (results) {
        extraKeys.AppendElement()->AssignASCII("results");
        extraValues.EmplaceBack(results.value());
      }
      if (sap) {
        extraKeys.AppendElement()->AssignASCII("sap");
        extraValues.EmplaceBack(sap.value());
      }
      if (searchEngineDefaultId) {
        extraKeys.AppendElement()->AssignASCII("search_engine_default_id");
        extraValues.EmplaceBack(searchEngineDefaultId.value());
      }
      if (searchMode) {
        extraKeys.AppendElement()->AssignASCII("search_mode");
        extraValues.EmplaceBack(searchMode.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user abandons a search (blurring the urlbar).
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(943);

  /**
   * generated from urlbar.autocomplete_first_result_time
   * PLACES: Time for first autocomplete result if > 50ms (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_AUTOCOMPLETE_1ST_RESULT_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric autocomplete_first_result_time(944);

  /**
   * generated from urlbar.autocomplete_sixth_result_time
   * PLACES: Time for the 6 first autocomplete results (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram PLACES_AUTOCOMPLETE_6_FIRST_RESULTS_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric autocomplete_sixth_result_time(945);

  /**
   * generated from urlbar.autofill_deletion
   * A uint recording the deletion count for autofilled string in the urlbar. This occurs when the user deletes whole autofilled string by BACKSPACE or DELETE key while the autofilled string is selected. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.autofill_deletion.
   */
  constexpr impl::CounterMetric autofill_deletion(946);

  /**
   * generated from urlbar.disable
   */
  struct DisableExtra {
    mozilla::Maybe<nsCString> feature;
    mozilla::Maybe<nsCString> interaction;
    mozilla::Maybe<uint32_t> nChars;
    mozilla::Maybe<uint32_t> nResults;
    mozilla::Maybe<uint32_t> nWords;
    mozilla::Maybe<nsCString> results;
    mozilla::Maybe<nsCString> sap;
    mozilla::Maybe<nsCString> searchEngineDefaultId;
    mozilla::Maybe<nsCString> searchMode;
    mozilla::Maybe<nsCString> selectedResult;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (feature) {
        extraKeys.AppendElement()->AssignASCII("feature");
        extraValues.EmplaceBack(feature.value());
      }
      if (interaction) {
        extraKeys.AppendElement()->AssignASCII("interaction");
        extraValues.EmplaceBack(interaction.value());
      }
      if (nChars) {
        extraKeys.AppendElement()->AssignASCII("n_chars");
        extraValues.AppendElement()->AppendInt(nChars.value());
      }
      if (nResults) {
        extraKeys.AppendElement()->AssignASCII("n_results");
        extraValues.AppendElement()->AppendInt(nResults.value());
      }
      if (nWords) {
        extraKeys.AppendElement()->AssignASCII("n_words");
        extraValues.AppendElement()->AppendInt(nWords.value());
      }
      if (results) {
        extraKeys.AppendElement()->AssignASCII("results");
        extraValues.EmplaceBack(results.value());
      }
      if (sap) {
        extraKeys.AppendElement()->AssignASCII("sap");
        extraValues.EmplaceBack(sap.value());
      }
      if (searchEngineDefaultId) {
        extraKeys.AppendElement()->AssignASCII("search_engine_default_id");
        extraValues.EmplaceBack(searchEngineDefaultId.value());
      }
      if (searchMode) {
        extraKeys.AppendElement()->AssignASCII("search_mode");
        extraValues.EmplaceBack(searchMode.value());
      }
      if (selectedResult) {
        extraKeys.AppendElement()->AssignASCII("selected_result");
        extraValues.EmplaceBack(selectedResult.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded after a search containing a Suggest result is engaged or abandoned. Number of seconds is controlled by hidden browser.urlbar.disableSuggestEvent.maxSecondsFromLastSearch pref. Reported values refer to the last search.
   */
  constexpr impl::EventMetric<DisableExtra> disable(947);

  /**
   * generated from urlbar.engagement
   */
  struct EngagementExtra {
    mozilla::Maybe<nsCString> actions;
    mozilla::Maybe<nsCString> engagementType;
    mozilla::Maybe<nsCString> groups;
    mozilla::Maybe<nsCString> interaction;
    mozilla::Maybe<uint32_t> nChars;
    mozilla::Maybe<uint32_t> nResults;
    mozilla::Maybe<uint32_t> nWords;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<nsCString> results;
    mozilla::Maybe<nsCString> sap;
    mozilla::Maybe<nsCString> searchEngineDefaultId;
    mozilla::Maybe<nsCString> searchMode;
    mozilla::Maybe<uint32_t> selectedPosition;
    mozilla::Maybe<nsCString> selectedResult;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (actions) {
        extraKeys.AppendElement()->AssignASCII("actions");
        extraValues.EmplaceBack(actions.value());
      }
      if (engagementType) {
        extraKeys.AppendElement()->AssignASCII("engagement_type");
        extraValues.EmplaceBack(engagementType.value());
      }
      if (groups) {
        extraKeys.AppendElement()->AssignASCII("groups");
        extraValues.EmplaceBack(groups.value());
      }
      if (interaction) {
        extraKeys.AppendElement()->AssignASCII("interaction");
        extraValues.EmplaceBack(interaction.value());
      }
      if (nChars) {
        extraKeys.AppendElement()->AssignASCII("n_chars");
        extraValues.AppendElement()->AppendInt(nChars.value());
      }
      if (nResults) {
        extraKeys.AppendElement()->AssignASCII("n_results");
        extraValues.AppendElement()->AppendInt(nResults.value());
      }
      if (nWords) {
        extraKeys.AppendElement()->AssignASCII("n_words");
        extraValues.AppendElement()->AppendInt(nWords.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (results) {
        extraKeys.AppendElement()->AssignASCII("results");
        extraValues.EmplaceBack(results.value());
      }
      if (sap) {
        extraKeys.AppendElement()->AssignASCII("sap");
        extraValues.EmplaceBack(sap.value());
      }
      if (searchEngineDefaultId) {
        extraKeys.AppendElement()->AssignASCII("search_engine_default_id");
        extraValues.EmplaceBack(searchEngineDefaultId.value());
      }
      if (searchMode) {
        extraKeys.AppendElement()->AssignASCII("search_mode");
        extraValues.EmplaceBack(searchMode.value());
      }
      if (selectedPosition) {
        extraKeys.AppendElement()->AssignASCII("selected_position");
        extraValues.AppendElement()->AppendInt(selectedPosition.value());
      }
      if (selectedResult) {
        extraKeys.AppendElement()->AssignASCII("selected_result");
        extraValues.EmplaceBack(selectedResult.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user executes an action on a result.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(948);

  /**
   * generated from urlbar.exposure
   */
  struct ExposureExtra {
    mozilla::Maybe<nsCString> results;
    mozilla::Maybe<nsCString> terminal;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (results) {
        extraKeys.AppendElement()->AssignASCII("results");
        extraValues.EmplaceBack(results.value());
      }
      if (terminal) {
        extraKeys.AppendElement()->AssignASCII("terminal");
        extraValues.EmplaceBack(terminal.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when client is exposed to urlbar experiment results.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(949);

  /**
   * generated from urlbar.fakespot_engagement
   */
  struct FakespotEngagementExtra {
    mozilla::Maybe<nsCString> grade;
    mozilla::Maybe<nsCString> provider;
    mozilla::Maybe<nsCString> rating;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (grade) {
        extraKeys.AppendElement()->AssignASCII("grade");
        extraValues.EmplaceBack(grade.value());
      }
      if (provider) {
        extraKeys.AppendElement()->AssignASCII("provider");
        extraValues.EmplaceBack(provider.value());
      }
      if (rating) {
        extraKeys.AppendElement()->AssignASCII("rating");
        extraValues.EmplaceBack(rating.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user engages with a Fakespot suggestion.
   */
  constexpr impl::EventMetric<FakespotEngagementExtra> fakespot_engagement(950);

  /**
   * generated from urlbar.keyword_exposure
   */
  struct KeywordExposureExtra {
    mozilla::Maybe<nsCString> keyword;
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<bool> terminal;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (keyword) {
        extraKeys.AppendElement()->AssignASCII("keyword");
        extraValues.EmplaceBack(keyword.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (terminal) {
        extraKeys.AppendElement()->AssignASCII("terminal");
        extraValues.AppendElement()->AssignASCII(terminal.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * When keyword exposures are enabled, this event is recorded in the `urlbar-keyword-exposure` ping, which is submitted at the end of urlbar sessions during which one or more exposure results are matched. The ping will contain one `keyword_exposure` event for each instance where a result is matched during the session. See the `urlbar-keyword-exposure` ping for details.
   */
  constexpr impl::EventMetric<KeywordExposureExtra> keyword_exposure(951);

  /**
   * generated from urlbar.pref_max_results
   * Maximum results to show in the Address Bar. Corresponds to the value of the `browser.urlbar.maxRichResults` pref.
   */
  constexpr impl::QuantityMetric pref_max_results(952);

  /**
   * generated from urlbar.pref_suggest_data_collection
   * Whether the user has opted in to data collection for Firefox Suggest, i.e., online suggestions served from Merino. Corresponds to the value of the `browser.urlbar.quicksuggest.dataCollection.enabled` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_data_collection(953);

  /**
   * generated from urlbar.pref_suggest_nonsponsored
   * Whether non-sponsored quick suggest results are shown in the urlbar. Corresponds to the value of the `browser.urlbar.suggest.quicksuggest.nonsponsored` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_nonsponsored(954);

  /**
   * generated from urlbar.pref_suggest_sponsored
   * Whether sponsored quick suggest results are shown in the urlbar. Corresponds to the value of the `browser.urlbar.suggest.quicksuggest.sponsored` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_sponsored(955);

  /**
   * generated from urlbar.pref_suggest_topsites
   * Whether topsite results are enabled in the urlbar. Corresponds to the value of the `browser.urlbar.suggest.topsites` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_topsites(956);

  /**
   * generated from urlbar.quick_suggest_contextual_opt_in
   */
  struct QuickSuggestContextualOptInExtra {
    mozilla::Maybe<nsCString> interaction;
    mozilla::Maybe<bool> sayHello;
    mozilla::Maybe<bool> topPosition;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (interaction) {
        extraKeys.AppendElement()->AssignASCII("interaction");
        extraValues.EmplaceBack(interaction.value());
      }
      if (sayHello) {
        extraKeys.AppendElement()->AssignASCII("say_hello");
        extraValues.AppendElement()->AssignASCII(sayHello.value() ? "true" : "false");
      }
      if (topPosition) {
        extraKeys.AppendElement()->AssignASCII("top_position");
        extraValues.AppendElement()->AssignASCII(topPosition.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the contextual opt-in UI is shown or interacted with.
   */
  constexpr impl::EventMetric<QuickSuggestContextualOptInExtra> quick_suggest_contextual_opt_in(957);
}

namespace urlbar_persistedsearchterms {
  /**
   * generated from urlbar.persistedsearchterms.revert_by_popup_count
   * The count of the number of times search terms were removed from the urlbar due to a shown PopupNotification. This event can happen when a user loads a SERP and a PopupNotification is shown, as well as when a user switches away from a tab on a SERP showing a PopupNotification and switches back to it. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.persistedsearchterms.revert_by_popup_count.
   */
  constexpr impl::CounterMetric revert_by_popup_count(958);

  /**
   * generated from urlbar.persistedsearchterms.view_count
   * The count of the number of times search terms persisted in the Urlbar. This gets recorded after a user loads a SERP that persists search terms, or switches back to an existing tab that should be showing the persisted search terms in the Urlbar, regardless of whether PopupNotification cleared the search terms from the Urlbar. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.persistedsearchterms.view_count.
   */
  constexpr impl::CounterMetric view_count(959);
}

namespace urlbar_quickaction {
  /**
   * generated from urlbar.quickaction.picked
   * Counts how many times quickaction results were selected. The key is the in the form "actionkey-N" where N is the number of characters the user typed to be shown the action. This metric was generated to correspond to the Legacy Telemetry scalar quickaction.picked.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> picked(960);
}

namespace urlbar_trending {
  /**
   * generated from urlbar.trending.block
   * User has blocked seeing trending results. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.trending.block.
   */
  constexpr impl::CounterMetric block(961);
}

namespace urlbar_unifiedsearchbutton {
  /**
   * generated from urlbar.unifiedsearchbutton.opened
   * Counts how many times Unified Search Button popup is opened. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.unifiedsearchbutton.opened.
   */
  constexpr impl::CounterMetric opened(962);

  /**
   * generated from urlbar.unifiedsearchbutton.picked
   * Counts how many times Unified Search Button items were selected. The key is followings. * builtin_search: Builtin search engine. * addon_search: Addon search engine. * local_search: Local search engine such as Bookmarks. * settings: Settings menu. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.unifiedsearchbutton.picked.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> picked(963);
}

namespace urlbar_zeroprefix {
  /**
   * generated from urlbar.zeroprefix.abandonment
   * Counts how many times the zero-prefix urlbar results panel was abandoned. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.zeroprefix.abandonment.
   */
  constexpr impl::CounterMetric abandonment(964);

  /**
   * generated from urlbar.zeroprefix.engagement
   * Counts how many times a result was picked in the zero-prefix urlbar results panel. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.zeroprefix.engagement.
   */
  constexpr impl::CounterMetric engagement(965);

  /**
   * generated from urlbar.zeroprefix.exposure
   * Counts how many times the zero-prefix urlbar results panel was shown to the user. This metric was generated to correspond to the Legacy Telemetry scalar urlbar.zeroprefix.exposure.
   */
  constexpr impl::CounterMetric exposure(966);
}

} // namespace mozilla::glean

#endif // mozilla_GleanUrlbarMetrics_h
