// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanWidgetMetrics_h
#define mozilla_GleanWidgetMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace gfx {

  /**
   * generated from gfx.content_backend
   * The content backend (e.g. "Direct2D 1.1", "Skia", "Cairo").
   */
  constexpr impl::StringMetric content_backend(3885);

  /**
   * generated from gfx.d2d_enabled
   * Whether Direct2D is enabled. (Windows-only)
   */
  constexpr impl::BooleanMetric d2d_enabled(3886);

  /**
   * generated from gfx.dwrite_enabled
   * Whether DirectWrite is enabled. (Windows-only)
   */
  constexpr impl::BooleanMetric dwrite_enabled(3887);

  /**
   * generated from gfx.headless
   * Whether the app's running in headless mode (e.g. via `MOZ_HEADLESS`).
   */
  constexpr impl::BooleanMetric headless(3888);


  /**
   * generated from gfx.target_frame_rate
   * The frame rate in Hz, typically 60 or more.
   */
  constexpr impl::QuantityMetric target_frame_rate(3890);

  /**
   * generated from gfx.text_scale_factor
   * The text scale factor.
   */
  constexpr impl::StringMetric text_scale_factor(3891);
}

namespace widget {
  /**
   * generated from widget.dark_mode
   * Whether the OS theme is dark. This metric was generated to correspond to the Legacy Telemetry scalar widget.dark_mode.
   */
  constexpr impl::BooleanMetric dark_mode(5880);

  /**
   * generated from widget.notify_idle
   * Time spent checking for and notifying listeners that the user is idle (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram IDLE_NOTIFY_IDLE_MS.
   */
  constexpr impl::TimingDistributionMetric notify_idle(5881);

  /**
   * generated from widget.pointing_devices
   */
  enum class PointingDevicesLabel: uint16_t {
    eMouse = 0,
    eTouch = 1,
    ePen = 2,
    e__Other__,
  };
  /**
   * Whether the system has any matching pointing device for each label.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PointingDevicesLabel> pointing_devices(5882);
}

namespace gfx_features {
  /**
   * generated from gfx.features.compositor
   * Layers backend for compositing.
   * One of "d3d9", "d3d11", "opengl", "basic", or "none".
   * "none" indicates no compositors have been created.
   */
  constexpr impl::StringMetric compositor(5886);








}

} // namespace mozilla::glean

#endif // mozilla_GleanWidgetMetrics_h
