/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  Anonymous380,
  Anonymous098,
  Anonymous250,
  Anonymous154,
  Anonymous102,
  Anonymous406,
  Anonymous405,
  CategoryManager,
  Anonymous229,
  Anonymous147,
  Anonymous287,
  Anonymous112,
  Anonymous152,
  Anonymous373,
  Anonymous019,
  Anonymous310,
  Anonymous257,
  Anonymous167,
  Anonymous317,
  Anonymous387,
  Directory,
  Anonymous198,
  Anonymous025,
  Anonymous189,
  Anonymous411,
  Anonymous375,
  Anonymous211,
  Anonymous104,
  Anonymous158,
  Anonymous237,
  Anonymous318,
  Anonymous061,
  Anonymous368,
  Anonymous372,
  Anonymous016,
  Anonymous345,
  Anonymous259,
  Anonymous359,
  Anonymous323,
  Anonymous046,
  CacheStorage,
  Anonymous277,
  Anonymous205,
  Anonymous306,
  Anonymous271,
  Anonymous393,
  Anonymous272,
  Anonymous035,
  Anonymous012,
  Anonymous156,
  Anonymous402,
  Anonymous062,
  Anonymous037,
  Anonymous118,
  Predictor,
  Anonymous120,
  Anonymous322,
  Anonymous421,
  Anonymous429,
  Anonymous101,
  PrivateAttribution,
  ApplicationReputation,
  Anonymous191,
  Anonymous169,
  Anonymous395,
  Anonymous186,
  FileProtocolHandler,
  Anonymous338,
  Anonymous190,
  NSSComponent,
  Locale,
  HttpHandler,
  Anonymous024,
  Anonymous427,
  Anonymous199,
  IDN,
  Anonymous157,
  Anonymous108,
  Anonymous188,
  Anonymous064,
  Anonymous422,
  ServiceWorkerManager,
  Anonymous296,
  Anonymous255,
  UrlClassifierDB,
  Anonymous416,
  Anonymous328,
  Anonymous408,
  Anonymous127,
  Anonymous001,
  Anonymous397,
  Anonymous137,
  StreamTransport,
  Anonymous332,
  Anonymous119,
  StringBundle,
  Anonymous203,
  Anonymous034,
  Anonymous376,
  IdentityCredentialPromptService,
  Anonymous362,
  Anonymous197,
  Anonymous235,
  Anonymous043,
  Anonymous399,
  Anonymous357,
  Anonymous027,
  Anonymous274,
  AuthPromptAdapter,
  Anonymous225,
  Anonymous164,
  Anonymous297,
  Anonymous435,
  Anonymous117,
  Anonymous134,
  Anonymous208,
  Prefetch,
  Anonymous066,
  Anonymous294,
  Anonymous159,
  Anonymous388,
  Anonymous437,
  Anonymous047,
  Anonymous266,
  Anonymous349,
  Anonymous285,
  Anonymous269,
  Anonymous121,
  Anonymous354,
  Anonymous095,
  Anonymous276,
  Console,
  Anonymous327,
  Anonymous083,
  Anonymous151,
  Anonymous226,
  PermissionManager,
  Anonymous055,
  UrlClassifierUtils,
  Anonymous178,
  Anonymous212,
  Anonymous440,
  Anonymous436,
  DNS,
  Anonymous346,
  Anonymous308,
  Anonymous329,
  Anonymous135,
  NSSErrors,
  CaptivePortal,
  PageThumbsStorage,
  Anonymous017,
  Anonymous070,
  Anonymous299,
  Anonymous041,
  Anonymous038,
  Observer,
  Anonymous251,
  Anonymous361,
  Anonymous009,
  Anonymous065,
  Anonymous194,
  Anonymous056,
  Anonymous031,
  Anonymous161,
  Anonymous133,
  Anonymous144,
  History,
  Anonymous254,
  Anonymous077,
  NSSCertificateDB,
  Anonymous216,
  BounceTrackingProtection,
  Anonymous060,
  Anonymous192,
  Anonymous131,
  AppStartup,
  Anonymous324,
  Anonymous298,
  Anonymous142,
  Anonymous170,
  TypeAheadFind,
  Anonymous350,
  URIFixup,
  StreamConverter,
  RFPService,
  Anonymous282,
  Anonymous087,
  Anonymous096,
  Anonymous049,
  Anonymous404,
  Anonymous415,
  Anonymous307,
  Anonymous232,
  Anonymous045,
  Anonymous010,
  Anonymous094,
  Anonymous141,
  Anonymous088,
  Anonymous258,
  ExternalProtocolHandler,
  SiteSecurity,
  Anonymous391,
  Anonymous028,
  Anonymous222,
  Anonymous100,
  Anonymous234,
  Anonymous033,
  Anonymous022,
  Anonymous044,
  Anonymous063,
  Anonymous090,
  Anonymous371,
  Anonymous007,
  Anonymous425,
  Anonymous166,
  Anonymous224,
  Anonymous006,
  SystemInfo,
  Anonymous403,
  Anonymous221,
  Anonymous330,
  Anonymous023,
  Anonymous000,
  Anonymous030,
  GfxInfo,
  Anonymous240,
  Anonymous099,
  MimeHeaderParam,
  Anonymous026,
  Anonymous261,
  Anonymous301,
  nsIContentAnalysis,
  Anonymous011,
  Anonymous146,
  Anonymous390,
  Anonymous132,
  Anonymous245,
  IdentityCredentialStorageService,
  Anonymous358,
  Anonymous292,
  Anonymous238,
  Anonymous428,
  Anonymous268,
  CookieBannerService,
  Anonymous081,
  Anonymous213,
  Anonymous106,
  RandomGenerator,
  Anonymous347,
  Anonymous052,
  Anonymous136,
  Anonymous353,
  URLQueryStringStripper,
  Anonymous290,
  Anonymous273,
  Anonymous071,
  Anonymous333,
  Anonymous042,
  Anonymous305,
  Anonymous244,
  Anonymous424,
  Anonymous366,
  Anonymous058,
  PlacesPreviewsHelper,
  Anonymous325,
  Anonymous093,
  Anonymous336,
  Anonymous185,
  Anonymous074,
  Anonymous400,
  Anonymous048,
  Anonymous110,
  Anonymous032,
  Anonymous150,
  Anonymous201,
  Anonymous243,
  Anonymous414,
  Anonymous176,
  ScriptSecurityManager,
  Anonymous029,
  Anonymous173,
  Anonymous209,
  Anonymous389,
  Anonymous334,
  Anonymous160,
  Anonymous309,
  Anonymous162,
  Anonymous040,
  Anonymous348,
  Anonymous392,
  Anonymous335,
  Anonymous220,
  Anonymous355,
  Anonymous286,
  Anonymous125,
  Anonymous109,
  Anonymous283,
  HttpActivityDistributor,
  Anonymous312,
  Anonymous084,
  Dashboard,
  Anonymous059,
  Anonymous321,
  Anonymous140,
  Anonymous407,
  UrlClassifierPrefixSet,
  Anonymous236,
  Anonymous105,
  Anonymous206,
  Anonymous174,
  Anonymous439,
  Anonymous311,
  Anonymous385,
  Anonymous386,
  UUIDGenerator,
  Anonymous363,
  Anonymous284,
  Anonymous111,
  FindService,
  Anonymous005,
  Anonymous021,
  Anonymous123,
  Anonymous343,
  Anonymous300,
  Anonymous003,
  Anonymous126,
  Anonymous067,
  Anonymous401,
  Anonymous241,
  Anonymous200,
  Anonymous219,
  Anonymous370,
  Anonymous069,
  Anonymous246,
  AsyncShutdown,
  Anonymous092,
  Anonymous295,
  Anonymous139,
  Anonymous078,
  Anonymous008,
  Anonymous270,
  Anonymous367,
  Anonymous252,
  Anonymous412,
  UrlClassifierStreamUpdater,
  Anonymous115,
  Anonymous086,
  Anonymous207,
  Anonymous085,
  IO,
  Anonymous381,
  Anonymous383,
  Anonymous103,
  Anonymous215,
  Anonymous014,
  Anonymous374,
  ThirdPartyUtil,
  Anonymous143,
  Anonymous230,
  Anonymous430,
  Anonymous054,
  Anonymous171,
  Anonymous441,
  Anonymous279,
  Anonymous004,
  Anonymous379,
  Anonymous420,
  Anonymous175,
  Anonymous281,
  Anonymous097,
  Anonymous426,
  Alerts,
  Anonymous247,
  Anonymous177,
  Anonymous195,
  Anonymous262,
  Anonymous163,
  Anonymous342,
  Anonymous091,
  Anonymous057,
  Anonymous217,
  DocLoader,
  SocketTransport,
  Anonymous168,
  WifiMonitor,
  Anonymous377,
  Anonymous382,
  Anonymous409,
  Anonymous253,
  Anonymous339,
  ProtocolProxy,
  Anonymous210,
  Anonymous075,
  Anonymous050,
  Anonymous304,
  Anonymous113,
  Anonymous128,
  Anonymous183,
  Anonymous076,
  Anonymous320,
  Anonymous193,
  Anonymous291,
  Anonymous256,
  Anonymous267,
  Anonymous068,
  TextToSubURI,
  AddonContentPolicy,
  Anonymous344,
  Anonymous181,
  Anonymous015,
  Anonymous013,
  Anonymous124,
  Anonymous288,
  Anonymous360,
  Anonymous130,
  Anonymous280,
  Anonymous417,
  Anonymous413,
  Anonymous289,
  Anonymous319,
  Anonymous352,
  Anonymous196,
  Anonymous340,
  Anonymous155,
  Anonymous331,
  Anonymous233,
  Anonymous396,
  Anonymous114,
  Anonymous239,
  Anonymous315,
  Anonymous431,
  Anonymous356,
  XULRuntime,
  Anonymous116,
  ChromeRegistry,
  ExtensionPolicy,
  Anonymous438,
  Anonymous231,
  Anonymous214,
  Anonymous314,
  Anonymous179,
  Anonymous260,
  Anonymous122,
  Anonymous313,
  Anonymous153,
  Anonymous089,
  Anonymous418,
  Anonymous419,
  Anonymous079,
  URILoader,
  Anonymous182,
  Anonymous223,
  Anonymous384,
  Anonymous129,
  Anonymous378,
  Anonymous293,
  Anonymous249,
  Anonymous410,
  Anonymous433,
  Anonymous302,
  Anonymous202,
  Anonymous036,
  Anonymous165,
  Anonymous242,
  Anonymous316,
  Anonymous341,
  Anonymous018,
  Anonymous149,
  Anonymous228,
  Anonymous148,
  Anonymous369,
  Anonymous303,
  Anonymous227,
  Anonymous053,
  Anonymous432,
  Anonymous204,
  Anonymous072,
  Anonymous138,
  Anonymous145,
  Anonymous275,
  Anonymous073,
  Anonymous107,
  Anonymous442,
  Anonymous337,
  Anonymous002,
  ContentSecurityManager,
  Anonymous265,
  Anonymous184,
  Anonymous263,
  Anonymous394,
  Anonymous443,
  Anonymous326,
  Anonymous039,
  Anonymous278,
  Anonymous365,
  Anonymous172,
  EffectiveTLD,
  DownloadPlatform,
  AlertNotification,
  Anonymous218,
  Anonymous020,
  Anonymous398,
  Anonymous364,
  Anonymous264,
  Anonymous434,
  Anonymous082,
  Anonymous423,
  Anonymous080,
  Anonymous051,
  Anonymous180,
  Preferences,
  CredentialChooserService,
  Anonymous248,
  WindowWatcher,
  Anonymous351,
  Anonymous187,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace AuthPromptAdapter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AuthPromptAdapter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}
}  // namespace AuthPromptAdapter

namespace BounceTrackingProtection {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::BounceTrackingProtection);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::BounceTrackingProtection, aRv};
}
}  // namespace BounceTrackingProtection

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace CaptivePortal {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CaptivePortal);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CaptivePortal, aRv};
}
}  // namespace CaptivePortal

namespace CategoryManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CategoryManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}
}  // namespace CategoryManager

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace Console {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Console);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}
}  // namespace Console

namespace ContentSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ContentSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}
}  // namespace ContentSecurityManager

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace CredentialChooserService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CredentialChooserService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}
}  // namespace CredentialChooserService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Dashboard {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Dashboard);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}
}  // namespace Dashboard

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace EffectiveTLD {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::EffectiveTLD);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::EffectiveTLD, aRv};
}
}  // namespace EffectiveTLD

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FileProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FileProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FileProtocolHandler, aRv};
}
}  // namespace FileProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace HttpHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpHandler, aRv};
}
}  // namespace HttpHandler

namespace IDN {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IDN);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}
}  // namespace IDN

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace Locale {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Locale);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Locale, aRv};
}
}  // namespace Locale

namespace MimeHeaderParam {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::MimeHeaderParam);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}
}  // namespace MimeHeaderParam

namespace NSSCertificateDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSCertificateDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}
}  // namespace NSSCertificateDB

namespace NSSComponent {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSComponent);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}
}  // namespace NSSComponent

namespace NSSErrors {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSErrors);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}
}  // namespace NSSErrors

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PageThumbsStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PageThumbsStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}
}  // namespace PageThumbsStorage

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace PlacesPreviewsHelper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PlacesPreviewsHelper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}
}  // namespace PlacesPreviewsHelper

namespace Predictor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Predictor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Predictor, aRv};
}
}  // namespace Predictor

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace PrivateAttribution {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PrivateAttribution);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}
}  // namespace PrivateAttribution

namespace ProtocolProxy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ProtocolProxy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ProtocolProxy, aRv};
}
}  // namespace ProtocolProxy

namespace RFPService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RFPService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RFPService, aRv};
}
}  // namespace RFPService

namespace RandomGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RandomGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}
}  // namespace RandomGenerator

namespace ScriptSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ScriptSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}
}  // namespace ScriptSecurityManager

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SiteSecurity {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SiteSecurity);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}
}  // namespace SiteSecurity

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamConverter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamConverter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}
}  // namespace StreamConverter

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace SystemInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SystemInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}
}  // namespace SystemInfo

namespace TextToSubURI {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TextToSubURI);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}
}  // namespace TextToSubURI

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace WifiMonitor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WifiMonitor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WifiMonitor, aRv};
}
}  // namespace WifiMonitor

namespace WindowWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WindowWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}
}  // namespace WindowWatcher

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

namespace nsIContentAnalysis {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIContentAnalysis);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}
}  // namespace nsIContentAnalysis

}  // namespace components

}  // namespace mozilla

#endif
