#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineError = 4764,
  GPUPipelineLayout = 4781,
  GPUQuerySet = 4799,
  GPUQueue = 4811,
  GPURenderBundle = 4820,
  GPURenderBundleEncoder = 4836,
  GPURenderPassEncoder = 4859,
  GPURenderPipeline = 4880,
  GPUSampler = 4898,
  GPUShaderModule = 4909,
  GPUShaderStage = 4925,
  GPUSupportedFeatures = 4940,
  GPUSupportedLimits = 4961,
  GPUTexture = 4980,
  GPUTextureUsage = 4991,
  GPUTextureView = 5007,
  GPUUncapturedErrorEvent = 5022,
  GPUValidationError = 5046,
  GainNode = 5065,
  Gamepad = 5074,
  GamepadAxisMoveEvent = 5082,
  GamepadButton = 5103,
  GamepadButtonEvent = 5117,
  GamepadEvent = 5136,
  GamepadHapticActuator = 5149,
  GamepadLightIndicator = 5171,
  GamepadPose = 5193,
  GamepadServiceTest = 5205,
  GamepadTouch = 5224,
  Geolocation = 5237,
  GeolocationCoordinates = 5249,
  GeolocationPosition = 5272,
  GeolocationPositionError = 5292,
  GetUserMediaRequest = 5317,
  GleanBoolean = 5337,
  GleanCategory = 5350,
  GleanCounter = 5364,
  GleanCustomDistribution = 5377,
  GleanDatetime = 5401,
  GleanDenominator = 5415,
  GleanEvent = 5432,
  GleanImpl = 5443,
  GleanLabeled = 5453,
  GleanMemoryDistribution = 5466,
  GleanMetric = 5490,
  GleanNumerator = 5502,
  GleanObject = 5517,
  GleanPingsImpl = 5529,
  GleanQuantity = 5544,
  GleanRate = 5558,
  GleanString = 5568,
  GleanStringList = 5580,
  GleanText = 5596,
  GleanTimespan = 5606,
  GleanTimingDistribution = 5620,
  GleanUrl = 5644,
  GleanUuid = 5653,
  Grid = 5663,
  GridArea = 5668,
  GridDimension = 5677,
  GridLine = 5691,
  GridLines = 5700,
  GridTrack = 5710,
  GridTracks = 5720,
  HTMLAllCollection = 5731,
  HTMLAnchorElement = 5749,
  HTMLAreaElement = 5767,
  HTMLAudioElement = 5783,
  HTMLBRElement = 5800,
  HTMLBaseElement = 5814,
  HTMLBodyElement = 5830,
  HTMLButtonElement = 5846,
  HTMLCanvasElement = 5864,
  HTMLCollection = 5882,
  HTMLDListElement = 5897,
  HTMLDataElement = 5914,
  HTMLDataListElement = 5930,
  HTMLDetailsElement = 5950,
  HTMLDialogElement = 5969,
  HTMLDirectoryElement = 5987,
  HTMLDivElement = 6008,
  HTMLDocument = 6023,
  HTMLElement = 6036,
  HTMLEmbedElement = 6048,
  HTMLFieldSetElement = 6065,
  HTMLFontElement = 6085,
  HTMLFormControlsCollection = 6101,
  HTMLFormElement = 6128,
  HTMLFrameElement = 6144,
  HTMLFrameSetElement = 6161,
  HTMLHRElement = 6181,
  HTMLHeadElement = 6195,
  HTMLHeadingElement = 6211,
  HTMLHtmlElement = 6230,
  HTMLIFrameElement = 6246,
  HTMLImageElement = 6264,
  HTMLInputElement = 6281,
  HTMLLIElement = 6298,
  HTMLLabelElement = 6312,
  HTMLLegendElement = 6329,
  HTMLLinkElement = 6347,
  HTMLMapElement = 6363,
  HTMLMarqueeElement = 6378,
  HTMLMediaElement = 6397,
  HTMLMenuElement = 6414,
  HTMLMetaElement = 6430,
  HTMLMeterElement = 6446,
  HTMLModElement = 6463,
  HTMLOListElement = 6478,
  HTMLObjectElement = 6495,
  HTMLOptGroupElement = 6513,
  HTMLOptionElement = 6533,
  HTMLOptionsCollection = 6551,
  HTMLOutputElement = 6573,
  HTMLParagraphElement = 6591,
  HTMLParamElement = 6612,
  HTMLPictureElement = 6629,
  HTMLPreElement = 6648,
  HTMLProgressElement = 6663,
  HTMLQuoteElement = 6683,
  HTMLScriptElement = 6700,
  HTMLSelectElement = 6718,
  HTMLSlotElement = 6736,
  HTMLSourceElement = 6752,
  HTMLSpanElement = 6770,
  HTMLStyleElement = 6786,
  HTMLTableCaptionElement = 6803,
  HTMLTableCellElement = 6827,
  HTMLTableColElement = 6848,
  HTMLTableElement = 6868,
  HTMLTableRowElement = 6885,
  HTMLTableSectionElement = 6905,
  HTMLTemplateElement = 6929,
  HTMLTextAreaElement = 6949,
  HTMLTimeElement = 6969,
  HTMLTitleElement = 6985,
  HTMLTrackElement = 7002,
  HTMLUListElement = 7019,
  HTMLUnknownElement = 7036,
  HTMLVideoElement = 7055,
  HashChangeEvent = 7072,
  Headers = 7088,
  Headers_Iterator = 7096,
  HeapSnapshot = 7113,
  Highlight = 7126,
  HighlightRegistry = 7136,
  History = 7154,
  IDBCursor = 7162,
  IDBCursorWithValue = 7172,
  IDBDatabase = 7191,
  IDBFactory = 7203,
  IDBIndex = 7214,
  IDBKeyRange = 7223,
  IDBObjectStore = 7235,
  IDBOpenDBRequest = 7250,
  IDBRequest = 7267,
  IDBTransaction = 7278,
  IDBVersionChangeEvent = 7293,
  IIRFilterNode = 7315,
  IOUtils = 7329,
  IdentityCredential = 7337,
  IdleDeadline = 7356,
  Image = 7369,
  ImageBitmap = 7375,
  ImageBitmapRenderingContext = 7387,
  ImageCapture = 7415,
  ImageCaptureError = 7428,
  ImageCaptureErrorEvent = 7446,
  ImageData = 7469,
  ImageDecoder = 7479,
  ImageDocument = 7492,
  ImageTrack = 7506,
  ImageTrackList = 7517,
  InputEvent = 7532,
  InspectorCSSParser = 7543,
  InspectorFontFace = 7562,
  InspectorUtils = 7580,
  InstallTriggerImpl = 7595,
  IntersectionObserver = 7614,
  IntersectionObserverEntry = 7635,
  IntlUtils = 7661,
  InvokeEvent = 7671,
  JSProcessActorChild = 7683,
  JSProcessActorParent = 7703,
  JSWindowActorChild = 7724,
  JSWindowActorParent = 7743,
  KeyEvent = 7763,
  KeyboardEvent = 7772,
  KeyframeEffect = 7786,
  L10nFileSource = 7801,
  L10nOverlays = 7816,
  L10nRegistry = 7829,
  LargestContentfulPaint = 7842,
  LegacyMozTCPSocket = 7865,
  Localization = 7884,
  Location = 7897,
  Lock = 7906,
  LockManager = 7911,
  MIDIAccess = 7923,
  MIDIConnectionEvent = 7934,
  MIDIInput = 7954,
  MIDIInputMap = 7964,
  MIDIMessageEvent = 7977,
  MIDIOutput = 7994,
  MIDIOutputMap = 8005,
  MIDIPort = 8019,
  MLS = 8028,
  MLSGroupView = 8032,
  MOZ_debug = 8045,
  MatchGlob = 8055,
  MatchPattern = 8065,
  MatchPatternSet = 8078,
  MathMLElement = 8094,
  MediaCapabilities = 8108,
  MediaControlService = 8126,
  MediaController = 8146,
  MediaDeviceInfo = 8162,
  MediaDevices = 8178,
  MediaElementAudioSourceNode = 8191,
  MediaEncryptedEvent = 8219,
  MediaError = 8239,
  MediaKeyError = 8250,
  MediaKeyMessageEvent = 8264,
  MediaKeySession = 8285,
  MediaKeyStatusMap = 8301,
  MediaKeyStatusMap_Iterator = 8319,
  MediaKeySystemAccess = 8346,
  MediaKeys = 8367,
  MediaList = 8377,
  MediaMetadata = 8387,
  MediaQueryList = 8401,
  MediaQueryListEvent = 8416,
  MediaRecorder = 8436,
  MediaRecorderErrorEvent = 8450,
  MediaSession = 8474,
  MediaSource = 8487,
  MediaStream = 8499,
  MediaStreamAudioDestinationNode = 8511,
  MediaStreamAudioSourceNode = 8543,
  MediaStreamError = 8570,
  MediaStreamEvent = 8587,
  MediaStreamTrack = 8604,
  MediaStreamTrackAudioSourceNode = 8621,
  MediaStreamTrackEvent = 8653,
  MerchantValidationEvent = 8675,
  MessageBroadcaster = 8699,
  MessageChannel = 8718,
  MessageEvent = 8733,
  MessageListenerManager = 8746,
  MessagePort = 8769,
  MessageSender = 8781,
  MimeType = 8795,
  MimeTypeArray = 8804,
  MouseEvent = 8818,
  MouseScrollEvent = 8829,
  MozCanvasPrintState = 8846,
  MozDocumentMatcher = 8866,
  MozDocumentObserver = 8885,
  MozQueryInterface = 8905,
  MozSharedMap = 8923,
  MozSharedMap_Iterator = 8936,
  MozSharedMapChangeEvent = 8958,
  MozStorageAsyncStatementParams = 8982,
  MozStorageStatementParams = 9013,
  MozStorageStatementRow = 9039,
  MozWritableSharedMap = 9062,
  MutationEvent = 9083,
  MutationObserver = 9097,
  MutationRecord = 9114,
  NamedNodeMap = 9129,
  NavigateEvent = 9142,
  Navigation = 9156,
  NavigationActivation = 9167,
  NavigationCurrentEntryChangeEvent = 9188,
  NavigationDestination = 9222,
  NavigationHistoryEntry = 9244,
  NavigationPreloadManager = 9267,
  NavigationTransition = 9292,
  Navigator = 9313,
  NavigatorLogin = 9323,
  NetworkInformation = 9338,
  Node = 9357,
  NodeFilter = 9362,
  NodeIterator = 9373,
  NodeList = 9386,
  Notification = 9395,
  NotificationEvent = 9408,
  NotifyPaintEvent = 9426,
  OES_draw_buffers_indexed = 9443,
  OES_element_index_uint = 9468,
  OES_fbo_render_mipmap = 9491,
  OES_standard_derivatives = 9513,
  OES_texture_float = 9538,
  OES_texture_float_linear = 9556,
  OES_texture_half_float = 9581,
  OES_texture_half_float_linear = 9604,
  OES_vertex_array_object = 9634,
  OVR_multiview2 = 9658,
  OfflineAudioCompletionEvent = 9673,
  OfflineAudioContext = 9701,
  OffscreenCanvas = 9721,
  OffscreenCanvasRenderingContext2D = 9737,
  Option = 9771,
  OscillatorNode = 9778,
  PageTransitionEvent = 9793,
  PaintRequest = 9813,
  PaintRequestList = 9826,
  PaintWorkletGlobalScope = 9843,
  PannerNode = 9867,
  ParentProcessMessageManager = 9878,
  Path2D = 9906,
  PathUtils = 9913,
  PaymentAddress = 9923,
  PaymentMethodChangeEvent = 9938,
  PaymentRequest = 9963,
  PaymentRequestUpdateEvent = 9978,
  PaymentResponse = 10004,
  Performance = 10020,
  PerformanceEntry = 10032,
  PerformanceEntryEvent = 10049,
  PerformanceEventTiming = 10071,
  PerformanceMark = 10094,
  PerformanceMeasure = 10110,
  PerformanceNavigation = 10129,
  PerformanceNavigationTiming = 10151,
  PerformanceObserver = 10179,
  PerformanceObserverEntryList = 10199,
  PerformancePaintTiming = 10228,
  PerformanceResourceTiming = 10251,
  PerformanceServerTiming = 10277,
  PerformanceTiming = 10301,
  PeriodicWave = 10319,
  PermissionStatus = 10332,
  Permissions = 10349,
  PlacesBookmark = 10361,
  PlacesBookmarkAddition = 10376,
  PlacesBookmarkChanged = 10399,
  PlacesBookmarkGuid = 10421,
  PlacesBookmarkKeyword = 10440,
  PlacesBookmarkMoved = 10462,
  PlacesBookmarkRemoved = 10482,
  PlacesBookmarkTags = 10504,
  PlacesBookmarkTime = 10523,
  PlacesBookmarkTitle = 10542,
  PlacesBookmarkUrl = 10562,
  PlacesEvent = 10580,
  PlacesEventCounts = 10592,
  PlacesFavicon = 10610,
  PlacesHistoryCleared = 10624,
  PlacesObservers = 10645,
  PlacesPurgeCaches = 10661,
  PlacesRanking = 10679,
  PlacesVisit = 10693,
  PlacesVisitRemoved = 10705,
  PlacesVisitTitle = 10724,
  PlacesWeakCallbackWrapper = 10741,
  Plugin = 10767,
  PluginArray = 10774,
  PluginCrashedEvent = 10786,
  PointerEvent = 10805,
  PopStateEvent = 10818,
  PopupBlockedEvent = 10832,
  PopupPositionedEvent = 10850,
  PositionStateEvent = 10871,
  PrecompiledScript = 10890,
  PrivateAttribution = 10908,
  ProcessMessageManager = 10927,
  ProcessingInstruction = 10949,
  ProgressEvent = 10971,
  PromiseDebugging = 10985,
  PromiseNativeHandler = 11002,
  PromiseRejectionEvent = 11023,
  PublicKeyCredential = 11045,
  PushEvent = 11065,
  PushManager = 11075,
  PushManagerImpl = 11087,
  PushMessageData = 11103,
  PushSubscription = 11119,
  PushSubscriptionChangeEvent = 11136,
  PushSubscriptionOptions = 11164,
  RadioNodeList = 11188,
  Range = 11202,
  ReadableByteStreamController = 11208,
  ReadableStream = 11237,
  ReadableStream_AsyncIterator = 11252,
  ReadableStreamBYOBReader = 11281,
  ReadableStreamBYOBRequest = 11306,
  ReadableStreamDefaultController = 11332,
  ReadableStreamDefaultReader = 11364,
  Report = 11392,
  ReportBody = 11399,
  ReportingObserver = 11410,
  Request = 11428,
  ResizeObserver = 11436,
  ResizeObserverEntry = 11451,
  ResizeObserverSize = 11471,
  Response = 11490,
  SVGAElement = 11499,
  SVGAngle = 11511,
  SVGAnimateElement = 11520,
  SVGAnimateMotionElement = 11538,
  SVGAnimateTransformElement = 11562,
  SVGAnimatedAngle = 11589,
  SVGAnimatedBoolean = 11606,
  SVGAnimatedEnumeration = 11625,
  SVGAnimatedInteger = 11648,
  SVGAnimatedLength = 11667,
  SVGAnimatedLengthList = 11685,
  SVGAnimatedNumber = 11707,
  SVGAnimatedNumberList = 11725,
  SVGAnimatedPreserveAspectRatio = 11747,
  SVGAnimatedRect = 11778,
  SVGAnimatedString = 11794,
  SVGAnimatedTransformList = 11812,
  SVGAnimationElement = 11837,
  SVGCircleElement = 11857,
  SVGClipPathElement = 11874,
  SVGComponentTransferFunctionElement = 11893,
  SVGDefsElement = 11929,
  SVGDescElement = 11944,
  SVGElement = 11959,
  SVGEllipseElement = 11970,
  SVGFEBlendElement = 11988,
  SVGFEColorMatrixElement = 12006,
  SVGFEComponentTransferElement = 12030,
  SVGFECompositeElement = 12060,
  SVGFEConvolveMatrixElement = 12082,
  SVGFEDiffuseLightingElement = 12109,
  SVGFEDisplacementMapElement = 12137,
  SVGFEDistantLightElement = 12165,
  SVGFEDropShadowElement = 12190,
  SVGFEFloodElement = 12213,
  SVGFEFuncAElement = 12231,
  SVGFEFuncBElement = 12249,
  SVGFEFuncGElement = 12267,
  SVGFEFuncRElement = 12285,
  SVGFEGaussianBlurElement = 12303,
  SVGFEImageElement = 12328,
  SVGFEMergeElement = 12346,
  SVGFEMergeNodeElement = 12364,
  SVGFEMorphologyElement = 12386,
  SVGFEOffsetElement = 12409,
  SVGFEPointLightElement = 12428,
  SVGFESpecularLightingElement = 12451,
  SVGFESpotLightElement = 12480,
  SVGFETileElement = 12502,
  SVGFETurbulenceElement = 12519,
  SVGFilterElement = 12542,
  SVGForeignObjectElement = 12559,
  SVGGElement = 12583,
  SVGGeometryElement = 12595,
  SVGGradientElement = 12614,
  SVGGraphicsElement = 12633,
  SVGImageElement = 12652,
  SVGLength = 12668,
  SVGLengthList = 12678,
  SVGLineElement = 12692,
  SVGLinearGradientElement = 12707,
  SVGMPathElement = 12732,
  SVGMarkerElement = 12748,
  SVGMaskElement = 12765,
  SVGMatrix = 12780,
  SVGMetadataElement = 12790,
  SVGNumber = 12809,
  SVGNumberList = 12819,
  SVGPathElement = 12833,
  SVGPathSegment = 12848,
  SVGPatternElement = 12863,
  SVGPoint = 12881,
  SVGPointList = 12890,
  SVGPolygonElement = 12903,
  SVGPolylineElement = 12921,
  SVGPreserveAspectRatio = 12940,
  SVGRadialGradientElement = 12963,
  SVGRect = 12988,
  SVGRectElement = 12996,
  SVGSVGElement = 13011,
  SVGScriptElement = 13025,
  SVGSetElement = 13042,
  SVGStopElement = 13056,
  SVGStringList = 13071,
  SVGStyleElement = 13085,
  SVGSwitchElement = 13101,
  SVGSymbolElement = 13118,
  SVGTSpanElement = 13135,
  SVGTextContentElement = 13151,
  SVGTextElement = 13173,
  SVGTextPathElement = 13188,
  SVGTextPositioningElement = 13207,
  SVGTitleElement = 13233,
  SVGTransform = 13249,
  SVGTransformList = 13262,
  SVGUnitTypes = 13279,
  SVGUseElement = 13292,
  SVGViewElement = 13306,
  Sanitizer = 13321,
  Scheduler = 13331,
  Screen = 13341,
  ScreenLuminance = 13348,
  ScreenOrientation = 13364,
  ScriptProcessorNode = 13382,
  ScrollAreaEvent = 13402,
  SecurityPolicyViolationEvent = 13418,
  Selection = 13447,
  ServiceWorker = 13457,
  ServiceWorkerContainer = 13471,
  ServiceWorkerGlobalScope = 13494,
  ServiceWorkerRegistration = 13519,
  SessionStoreFormData = 13545,
  SessionStoreScrollData = 13566,
  SessionStoreUtils = 13589,
  ShadowRealmGlobalScope = 13607,
  ShadowRoot = 13630,
  SharedWorker = 13641,
  SharedWorkerGlobalScope = 13654,
  SimpleGestureEvent = 13678,
  SourceBuffer = 13697,
  SourceBufferList = 13710,
  SpeechGrammar = 13727,
  SpeechGrammarList = 13741,
  SpeechRecognition = 13759,
  SpeechRecognitionAlternative = 13777,
  SpeechRecognitionError = 13806,
  SpeechRecognitionEvent = 13829,
  SpeechRecognitionResult = 13852,
  SpeechRecognitionResultList = 13876,
  SpeechSynthesis = 13904,
  SpeechSynthesisErrorEvent = 13920,
  SpeechSynthesisEvent = 13946,
  SpeechSynthesisUtterance = 13967,
  SpeechSynthesisVoice = 13992,
  StaticRange = 14013,
  StereoPannerNode = 14025,
  Storage = 14042,
  StorageEvent = 14050,
  StorageManager = 14063,
  StreamFilter = 14078,
  StreamFilterDataEvent = 14091,
  StructuredCloneHolder = 14113,
  StructuredCloneTester = 14135,
  StyleSheet = 14157,
  StyleSheetApplicableStateChangeEvent = 14168,
  StyleSheetList = 14205,
  StyleSheetRemovedEvent = 14220,
  SubmitEvent = 14243,
  SubtleCrypto = 14255,
  SyncMessageSender = 14268,
  SyncReadFile = 14286,
  TCPServerSocket = 14299,
  TCPServerSocketEvent = 14315,
  TCPSocket = 14336,
  TCPSocketErrorEvent = 14346,
  TCPSocketEvent = 14366,
  TaskController = 14381,
  TaskPriorityChangeEvent = 14396,
  TaskSignal = 14420,
  TestUtils = 14431,
  TestingDeprecatedInterface = 14441,
  Text = 14468,
  TextClause = 14473,
  TextDecoder = 14484,
  TextDecoderStream = 14496,
  TextEncoder = 14514,
  TextEncoderStream = 14526,
  TextEvent = 14544,
  TextMetrics = 14554,
  TextTrack = 14566,
  TextTrackCue = 14576,
  TextTrackCueList = 14589,
  TextTrackList = 14606,
  TimeEvent = 14620,
  TimeRanges = 14630,
  ToggleEvent = 14641,
  Touch = 14653,
  TouchEvent = 14659,
  TouchList = 14670,
  TrackEvent = 14680,
  TransformStream = 14691,
  TransformStreamDefaultController = 14707,
  TransitionEvent = 14740,
  TreeColumn = 14756,
  TreeColumns = 14767,
  TreeContentView = 14779,
  TreeWalker = 14795,
  TrustedHTML = 14806,
  TrustedScript = 14818,
  TrustedScriptURL = 14832,
  TrustedTypePolicy = 14849,
  TrustedTypePolicyFactory = 14867,
  UDPMessageEvent = 14892,
  UDPSocket = 14908,
  UIEvent = 14918,
  URL = 14926,
  URLSearchParams = 14930,
  URLSearchParams_Iterator = 14946,
  UniFFIPointer = 14971,
  UniFFIScaffolding = 14985,
  UserActivation = 15003,
  UserInteraction = 15018,
  UserProximityEvent = 15034,
  VRDisplay = 15053,
  VRDisplayCapabilities = 15063,
  VRDisplayEvent = 15085,
  VREyeParameters = 15100,
  VRFieldOfView = 15116,
  VRFrameData = 15130,
  VRMockController = 15142,
  VRMockDisplay = 15159,
  VRPose = 15173,
  VRServiceTest = 15180,
  VRStageParameters = 15194,
  VTTCue = 15212,
  VTTRegion = 15219,
  ValidityState = 15229,
  VideoColorSpace = 15243,
  VideoDecoder = 15259,
  VideoEncoder = 15272,
  VideoFrame = 15285,
  VideoPlaybackQuality = 15296,
  VideoTrack = 15317,
  VideoTrackList = 15328,
  ViewTransition = 15343,
  VisualViewport = 15358,
  WEBGL_color_buffer_float = 15373,
  WEBGL_compressed_texture_astc = 15398,
  WEBGL_compressed_texture_etc = 15428,
  WEBGL_compressed_texture_etc1 = 15457,
  WEBGL_compressed_texture_pvrtc = 15487,
  WEBGL_compressed_texture_s3tc = 15518,
  WEBGL_compressed_texture_s3tc_srgb = 15548,
  WEBGL_debug_renderer_info = 15583,
  WEBGL_debug_shaders = 15609,
  WEBGL_depth_texture = 15629,
  WEBGL_draw_buffers = 15649,
  WEBGL_explicit_present = 15668,
  WEBGL_lose_context = 15691,
  WEBGL_provoking_vertex = 15710,
  WGSLLanguageFeatures = 15733,
  WakeLock = 15754,
  WakeLockSentinel = 15763,
  WaveShaperNode = 15780,
  WebExtensionContentScript = 15795,
  WebExtensionPolicy = 15821,
  WebGL2RenderingContext = 15840,
  WebGLActiveInfo = 15863,
  WebGLBuffer = 15879,
  WebGLContextEvent = 15891,
  WebGLFramebuffer = 15909,
  WebGLProgram = 15926,
  WebGLQuery = 15939,
  WebGLRenderbuffer = 15950,
  WebGLRenderingContext = 15968,
  WebGLSampler = 15990,
  WebGLShader = 16003,
  WebGLShaderPrecisionFormat = 16015,
  WebGLSync = 16042,
  WebGLTexture = 16052,
  WebGLTransformFeedback = 16065,
  WebGLUniformLocation = 16088,
  WebGLVertexArrayObject = 16109,
  WebKitCSSMatrix = 16132,
  WebSocket = 16148,
  WebTransport = 16158,
  WebTransportBidirectionalStream = 16171,
  WebTransportDatagramDuplexStream = 16203,
  WebTransportError = 16236,
  WebTransportReceiveStream = 16254,
  WebTransportSendStream = 16280,
  WheelEvent = 16303,
  Window = 16314,
  WindowClient = 16321,
  WindowContext = 16334,
  WindowGlobalChild = 16348,
  WindowGlobalParent = 16366,
  WindowRoot = 16385,
  Worker = 16396,
  WorkerDebuggerGlobalScope = 16403,
  WorkerGlobalScope = 16429,
  WorkerLocation = 16447,
  WorkerNavigator = 16462,
  WorkerTestUtils = 16478,
  Worklet = 16494,
  WorkletGlobalScope = 16502,
  WritableStream = 16521,
  WritableStreamDefaultController = 16536,
  WritableStreamDefaultWriter = 16568,
  XMLDocument = 16596,
  XMLHttpRequest = 16608,
  XMLHttpRequestEventTarget = 16623,
  XMLHttpRequestUpload = 16649,
  XMLSerializer = 16670,
  XPathEvaluator = 16684,
  XPathExpression = 16699,
  XPathResult = 16715,
  XRBoundedReferenceSpace = 16727,
  XRFrame = 16751,
  XRInputSource = 16759,
  XRInputSourceArray = 16773,
  XRInputSourceEvent = 16792,
  XRInputSourcesChangeEvent = 16811,
  XRPose = 16837,
  XRReferenceSpace = 16844,
  XRReferenceSpaceEvent = 16861,
  XRRenderState = 16883,
  XRRigidTransform = 16897,
  XRSession = 16914,
  XRSessionEvent = 16924,
  XRSpace = 16939,
  XRSystem = 16947,
  XRView = 16956,
  XRViewerPose = 16963,
  XRViewport = 16976,
  XRWebGLLayer = 16987,
  XSLTProcessor = 17000,
  XULCommandEvent = 17014,
  XULElement = 17030,
  XULFrameElement = 17041,
  XULMenuElement = 17057,
  XULPopupElement = 17072,
  XULResizerElement = 17088,
  XULTextElement = 17106,
  XULTreeElement = 17121,
  console = 17136,
  webkitSpeechGrammar = 17144,
  webkitSpeechGrammarList = 17164,
  webkitSpeechRecognition = 17188,
  webkitURL = 17212,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
