/* THIS FILE IS AUTOGENERATED FROM AudioEncoder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_AUDIOENCODERBINDING_H_
#define DOM_AUDIOENCODERBINDING_H_

#include "AudioDecoderBinding.h"
#include "MediaRecorderBinding.h"
#include "VideoDecoderBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct AudioDecoderConfig;
class AudioEncoder;
struct AudioEncoderConfig;
struct AudioEncoderConfigAtoms;
struct AudioEncoderInitAtoms;
struct AudioEncoderSupportAtoms;
class EncodedAudioChunk;
struct EncodedAudioChunkMetadata;
struct EncodedAudioChunkMetadataAtoms;
class EncodedAudioChunkOutputCallback;
struct NativePropertyHooks;
struct OpusEncoderConfig;
struct OpusEncoderConfigAtoms;
class ProtoAndIfaceCache;
class WebCodecsErrorCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class OpusBitstreamFormat : uint8_t {
  Opus,
  Ogg,
};

namespace binding_detail {
template <> struct EnumStrings<OpusBitstreamFormat> {
  static constexpr nsLiteralCString Values[2] {
    "opus"_ns,
    "ogg"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, OpusBitstreamFormat aArgument, JS::MutableHandle<JS::Value> aValue);


struct AudioEncoderInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<WebCodecsErrorCallback> mError;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<EncodedAudioChunkOutputCallback> mOutput;

  AudioEncoderInit();

  explicit inline AudioEncoderInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioEncoderInit(AudioEncoderInit&& aOther) = default;

private:
  AudioEncoderInit(const AudioEncoderInit&) = delete;
  AudioEncoderInit& operator=(const AudioEncoderInit&) = delete;

  static bool
  InitIds(JSContext* cx, AudioEncoderInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mError, "mError", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOutput, "mOutput", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mError);
    ImplCycleCollectionUnlink(mOutput);
  }
};

namespace binding_detail {
struct FastAudioEncoderInit : public AudioEncoderInit
{
  inline FastAudioEncoderInit()
    : AudioEncoderInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct EncodedAudioChunkMetadata : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<AudioDecoderConfig> mDecoderConfig;

  EncodedAudioChunkMetadata();

  explicit inline EncodedAudioChunkMetadata(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  EncodedAudioChunkMetadata(EncodedAudioChunkMetadata&& aOther) = default;

private:
  EncodedAudioChunkMetadata(const EncodedAudioChunkMetadata&) = delete;
  EncodedAudioChunkMetadata& operator=(const EncodedAudioChunkMetadata&) = delete;

  static bool
  InitIds(JSContext* cx, EncodedAudioChunkMetadataAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastEncodedAudioChunkMetadata : public EncodedAudioChunkMetadata
{
  inline FastEncodedAudioChunkMetadata()
    : EncodedAudioChunkMetadata(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class EncodedAudioChunkOutputCallback : public CallbackFunction
{
public:
  explicit inline EncodedAudioChunkOutputCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedAudioChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedAudioChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline EncodedAudioChunkOutputCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, EncodedAudioChunk& output, const EncodedAudioChunkMetadata& metadata, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EncodedAudioChunkOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, output, metadata, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(EncodedAudioChunk& output, const EncodedAudioChunkMetadata& metadata, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EncodedAudioChunkOutputCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, output, metadata, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, EncodedAudioChunk& output, const EncodedAudioChunkMetadata& metadata, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, output, metadata, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(EncodedAudioChunk& output, const EncodedAudioChunkMetadata& metadata, const char* aExecutionReason = nullptr)
  {
    return Call(output, metadata, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const EncodedAudioChunkOutputCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, EncodedAudioChunk& output, const EncodedAudioChunkMetadata& metadata, ErrorResult& aRv);
};


namespace binding_detail {
class FastEncodedAudioChunkOutputCallback : public EncodedAudioChunkOutputCallback
{
public:
  explicit inline FastEncodedAudioChunkOutputCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : EncodedAudioChunkOutputCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    EncodedAudioChunkOutputCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    EncodedAudioChunkOutputCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct OpusEncoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mComplexity;
  MOZ_INIT_OUTSIDE_CTOR OpusBitstreamFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mFrameDuration;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPacketlossperc;
  MOZ_INIT_OUTSIDE_CTOR bool mUsedtx;
  MOZ_INIT_OUTSIDE_CTOR bool mUseinbandfec;

  OpusEncoderConfig();

  explicit inline OpusEncoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  OpusEncoderConfig(OpusEncoderConfig&& aOther) = default;

  explicit inline OpusEncoderConfig(const OpusEncoderConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  OpusEncoderConfig&
  operator=(const OpusEncoderConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, OpusEncoderConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastOpusEncoderConfig : public OpusEncoderConfig
{
  inline FastOpusEncoderConfig()
    : OpusEncoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AudioEncoderConfig : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBitrate;
  MOZ_INIT_OUTSIDE_CTOR BitrateMode mBitrateMode;
  MOZ_INIT_OUTSIDE_CTOR nsString mCodec;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mNumberOfChannels;
  MOZ_INIT_OUTSIDE_CTOR Optional<OpusEncoderConfig> mOpus;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mSampleRate;

  AudioEncoderConfig();

  explicit inline AudioEncoderConfig(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioEncoderConfig(AudioEncoderConfig&& aOther) = default;

  explicit inline AudioEncoderConfig(const AudioEncoderConfig& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AudioEncoderConfig&
  operator=(const AudioEncoderConfig& aOther);

private:
  static bool
  InitIds(JSContext* cx, AudioEncoderConfigAtoms* atomsCache);
};

namespace binding_detail {
struct FastAudioEncoderConfig : public AudioEncoderConfig
{
  inline FastAudioEncoderConfig()
    : AudioEncoderConfig(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct AudioEncoderSupport : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<AudioEncoderConfig> mConfig;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mSupported;

  AudioEncoderSupport();

  explicit inline AudioEncoderSupport(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AudioEncoderSupport(AudioEncoderSupport&& aOther) = default;

  explicit inline AudioEncoderSupport(const AudioEncoderSupport& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AudioEncoderSupport&
  operator=(const AudioEncoderSupport& aOther);

private:
  static bool
  InitIds(JSContext* cx, AudioEncoderSupportAtoms* atomsCache);
};

namespace binding_detail {
struct FastAudioEncoderSupport : public AudioEncoderSupport
{
  inline FastAudioEncoderSupport()
    : AudioEncoderSupport(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AudioEncoder_Binding {

  typedef mozilla::dom::AudioEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::AudioEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace AudioEncoder_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::OpusBitstreamFormat>
{
  static constexpr dom::OpusBitstreamFormat value = dom::OpusBitstreamFormat::Ogg;

  static_assert(static_cast<uint8_t>(dom::OpusBitstreamFormat::Opus) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::OpusBitstreamFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_AUDIOENCODERBINDING_H_
