// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanMigrationMetrics_h
#define mozilla_GleanMigrationMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_migration {
  /**
   * generated from browser.migration.bookmarks_quantity
   * How many bookmarks we imported from another browser, keyed by the name of the browser.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_BOOKMARKS_QUANTITY.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> bookmarks_quantity(448);

  /**
   * generated from browser.migration.browser_selected_wizard
   */
  struct BrowserSelectedWizardExtra {
    mozilla::Maybe<nsCString> migratorKey;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a browser to migrate from. This event was generated to correspond to the Legacy Telemetry event browser.migration.browser_selected#wizard.
   */
  constexpr impl::EventMetric<BrowserSelectedWizardExtra> browser_selected_wizard(449);

  /**
   * generated from browser.migration.cards_quantity
   * How many credit card entries we imported from another browser, keyed by the name of the browser.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_CARDS_QUANTITY.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> cards_quantity(450);

  /**
   * generated from browser.migration.chrome_password_file_wizard
   */
  /**
   * Recorded if the user is importing from Chrome, and was presented with the page of the wizard requesting to import passwords from a file. This currently only gets shown on Windows.
   */
  constexpr impl::EventMetric<NoExtraKeys> chrome_password_file_wizard(451);

  /**
   * generated from browser.migration.entry_point_categorical
   */
  enum class EntryPointCategoricalLabel: uint16_t {
    eUnknown = 0,
    eFirstrun = 1,
    eFxrefresh = 2,
    ePlaces = 3,
    ePasswords = 4,
    eNewtab = 5,
    eFileMenu = 6,
    eHelpMenu = 7,
    eBookmarksToolbar = 8,
    ePreferences = 9,
    e__Other__,
  };
  /**
   * Where the migration wizard was entered from.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram FX_MIGRATION_ENTRY_POINT_CATEGORICAL.
   */
  constexpr impl::Labeled<impl::CounterMetric, EntryPointCategoricalLabel> entry_point_categorical(452);

  /**
   * generated from browser.migration.errors
   * Errors encountered during migration in buckets defined by the datatype, keyed by the string description of the browser.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_ERRORS.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> errors(453);

  /**
   * generated from browser.migration.extensions_quantity
   * How many extensions were matched to be imported from another browser, keyed by the name of the browser.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_EXTENSIONS_QUANTITY.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> extensions_quantity(454);

  /**
   * generated from browser.migration.history_quantity
   * How many history visits we imported from another browser, keyed by the name of the browser.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_HISTORY_QUANTITY.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> history_quantity(455);

  /**
   * generated from browser.migration.linux_perms_wizard
   */
  struct LinuxPermsWizardExtra {
    mozilla::Maybe<nsCString> migratorKey;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded if the user is on Linux and the browser is installed in a sandboxed environment that prevents it from reading other browser's data, and the user is presented with instructions and an option to grant the browser permission to read that other data. This event was generated to correspond to the Legacy Telemetry event browser.migration.linux_perms#wizard.
   */
  constexpr impl::EventMetric<LinuxPermsWizardExtra> linux_perms_wizard(456);

  /**
   * generated from browser.migration.logins_quantity
   * How many logins (passwords) we imported from another browser, keyed by the name of the browser.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_MIGRATION_LOGINS_QUANTITY.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> logins_quantity(457);

  /**
   * generated from browser.migration.matched_extensions
   * Records a list of the Chrome extension IDs that were successfully matched to Firefox equivalents from the list downloaded from AMO.
   */
  constexpr impl::StringListMetric matched_extensions(458);

  /**
   * generated from browser.migration.migration_finished_wizard
   */
  struct MigrationFinishedWizardExtra {
    mozilla::Maybe<nsCString> bookmarks;
    mozilla::Maybe<nsCString> extensions;
    mozilla::Maybe<nsCString> formdata;
    mozilla::Maybe<nsCString> history;
    mozilla::Maybe<nsCString> migratorKey;
    mozilla::Maybe<uint32_t> other;
    mozilla::Maybe<nsCString> passwords;
    mozilla::Maybe<nsCString> paymentMethods;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bookmarks) {
        extraKeys.AppendElement()->AssignASCII("bookmarks");
        extraValues.EmplaceBack(bookmarks.value());
      }
      if (extensions) {
        extraKeys.AppendElement()->AssignASCII("extensions");
        extraValues.EmplaceBack(extensions.value());
      }
      if (formdata) {
        extraKeys.AppendElement()->AssignASCII("formdata");
        extraValues.EmplaceBack(formdata.value());
      }
      if (history) {
        extraKeys.AppendElement()->AssignASCII("history");
        extraValues.EmplaceBack(history.value());
      }
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      if (other) {
        extraKeys.AppendElement()->AssignASCII("other");
        extraValues.AppendElement()->AppendInt(other.value());
      }
      if (passwords) {
        extraKeys.AppendElement()->AssignASCII("passwords");
        extraValues.EmplaceBack(passwords.value());
      }
      if (paymentMethods) {
        extraKeys.AppendElement()->AssignASCII("payment_methods");
        extraValues.EmplaceBack(paymentMethods.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user finishes a migration. This event was generated to correspond to the Legacy Telemetry event browser.migration.migration_finished#wizard.
   */
  constexpr impl::EventMetric<MigrationFinishedWizardExtra> migration_finished_wizard(459);

  /**
   * generated from browser.migration.migration_started_wizard
   */
  struct MigrationStartedWizardExtra {
    mozilla::Maybe<nsCString> bookmarks;
    mozilla::Maybe<nsCString> extensions;
    mozilla::Maybe<nsCString> formdata;
    mozilla::Maybe<nsCString> history;
    mozilla::Maybe<nsCString> migratorKey;
    mozilla::Maybe<uint32_t> other;
    mozilla::Maybe<nsCString> passwords;
    mozilla::Maybe<nsCString> paymentMethods;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bookmarks) {
        extraKeys.AppendElement()->AssignASCII("bookmarks");
        extraValues.EmplaceBack(bookmarks.value());
      }
      if (extensions) {
        extraKeys.AppendElement()->AssignASCII("extensions");
        extraValues.EmplaceBack(extensions.value());
      }
      if (formdata) {
        extraKeys.AppendElement()->AssignASCII("formdata");
        extraValues.EmplaceBack(formdata.value());
      }
      if (history) {
        extraKeys.AppendElement()->AssignASCII("history");
        extraValues.EmplaceBack(history.value());
      }
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      if (other) {
        extraKeys.AppendElement()->AssignASCII("other");
        extraValues.AppendElement()->AppendInt(other.value());
      }
      if (passwords) {
        extraKeys.AppendElement()->AssignASCII("passwords");
        extraValues.EmplaceBack(passwords.value());
      }
      if (paymentMethods) {
        extraKeys.AppendElement()->AssignASCII("payment_methods");
        extraValues.EmplaceBack(paymentMethods.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user begins a migration. This event was generated to correspond to the Legacy Telemetry event browser.migration.migration_started#wizard.
   */
  constexpr impl::EventMetric<MigrationStartedWizardExtra> migration_started_wizard(460);

  /**
   * generated from browser.migration.no_browsers_found_wizard
   */
  /**
   * Recorded when the migration wizard reports that there are no browsers to migrate from. This event was generated to correspond to the Legacy Telemetry event browser.migration.no_browsers_found#wizard.
   */
  constexpr impl::EventMetric<NoExtraKeys> no_browsers_found_wizard(461);

  /**
   * generated from browser.migration.opened_wizard
   */
  /**
   * Recorded when the migration wizard opens. This event was generated to correspond to the Legacy Telemetry event browser.migration.opened#wizard.
   */
  constexpr impl::EventMetric<NoExtraKeys> opened_wizard(462);

  /**
   * generated from browser.migration.profile_selected_wizard
   */
  struct ProfileSelectedWizardExtra {
    mozilla::Maybe<nsCString> migratorKey;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects a profile to migrate from. If the browser doesn't support multiple profiles, this will not be recorded. This event was generated to correspond to the Legacy Telemetry event browser.migration.profile_selected#wizard.
   */
  constexpr impl::EventMetric<ProfileSelectedWizardExtra> profile_selected_wizard(463);

  /**
   * generated from browser.migration.resources_selected_wizard
   */
  struct ResourcesSelectedWizardExtra {
    mozilla::Maybe<nsCString> bookmarks;
    mozilla::Maybe<nsCString> configured;
    mozilla::Maybe<nsCString> extensions;
    mozilla::Maybe<nsCString> formdata;
    mozilla::Maybe<nsCString> history;
    mozilla::Maybe<nsCString> migratorKey;
    mozilla::Maybe<uint32_t> other;
    mozilla::Maybe<nsCString> passwords;
    mozilla::Maybe<nsCString> paymentMethods;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bookmarks) {
        extraKeys.AppendElement()->AssignASCII("bookmarks");
        extraValues.EmplaceBack(bookmarks.value());
      }
      if (configured) {
        extraKeys.AppendElement()->AssignASCII("configured");
        extraValues.EmplaceBack(configured.value());
      }
      if (extensions) {
        extraKeys.AppendElement()->AssignASCII("extensions");
        extraValues.EmplaceBack(extensions.value());
      }
      if (formdata) {
        extraKeys.AppendElement()->AssignASCII("formdata");
        extraValues.EmplaceBack(formdata.value());
      }
      if (history) {
        extraKeys.AppendElement()->AssignASCII("history");
        extraValues.EmplaceBack(history.value());
      }
      if (migratorKey) {
        extraKeys.AppendElement()->AssignASCII("migrator_key");
        extraValues.EmplaceBack(migratorKey.value());
      }
      if (other) {
        extraKeys.AppendElement()->AssignASCII("other");
        extraValues.AppendElement()->AppendInt(other.value());
      }
      if (passwords) {
        extraKeys.AppendElement()->AssignASCII("passwords");
        extraValues.EmplaceBack(passwords.value());
      }
      if (paymentMethods) {
        extraKeys.AppendElement()->AssignASCII("payment_methods");
        extraValues.EmplaceBack(paymentMethods.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user selects resources from the browser / profile to import. This event was generated to correspond to the Legacy Telemetry event browser.migration.resources_selected#wizard.
   */
  constexpr impl::EventMetric<ResourcesSelectedWizardExtra> resources_selected_wizard(464);

  /**
   * generated from browser.migration.safari_password_file_wizard
   */
  /**
   * Recorded if the user is on macOS, chose to migrate from Safari, and was presented with the page of the wizard requesting to import passwords from a file. This only gets recorded in the new migration wizard. This event was generated to correspond to the Legacy Telemetry event browser.migration.safari_password_file#wizard.
   */
  constexpr impl::EventMetric<NoExtraKeys> safari_password_file_wizard(465);

  /**
   * generated from browser.migration.safari_perms_wizard
   */
  /**
   * Recorded if the user is on macOS, chose to migrate from Safari, and was presented with the page of the wizard requesting permission to read from the Safari profile folder. This event was generated to correspond to the Legacy Telemetry event browser.migration.safari_perms#wizard.
   */
  constexpr impl::EventMetric<NoExtraKeys> safari_perms_wizard(466);

  /**
   * generated from browser.migration.source_browser
   * The browser that data is pulled from. The values correspond to the internal browser ID (see MigrationUtils.sys.mjs)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_SOURCE_BROWSER.
   */
  constexpr impl::CustomDistributionMetric source_browser(467);

  /**
   * generated from browser.migration.unmatched_extensions
   * Records a list of the Chrome extension IDs that were unsuccessfully matched to Firefox equivalents from the list downloaded from AMO.
   */
  constexpr impl::StringListMetric unmatched_extensions(468);

  /**
   * generated from browser.migration.usage
   * Usage of migration for each datatype when migration is run through the post-firstrun flow which allows individual datatypes, keyed by the string description of the browser.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_MIGRATION_USAGE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> usage(469);
}

namespace migration {
  /**
   * generated from migration.discovered_migrators
   * A keyed uint recording how many times the migration wizard detected a browser / profile pair for a particular browser. This is incremented every time the discovery occurs, so multiple openings of the wizard will increase the counts each time. This metric was generated to correspond to the Legacy Telemetry scalar migration.discovered_migrators.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> discovered_migrators(470);

  /**
   * generated from migration.time_to_produce_migrator_list
   * The amount of time it took in milliseconds to produce the list of migrators and profiles for the first time the migration wizard opened during the process lifetime. This metric was generated to correspond to the Legacy Telemetry scalar migration.time_to_produce_migrator_list.
   */
  constexpr impl::TimespanMetric time_to_produce_migrator_list(471);

  /**
   * generated from migration.uninstaller_profile_refresh
   * Set when a profile refresh is initiated from the uninstaller. This metric was generated to correspond to the Legacy Telemetry scalar migration.uninstaller_profile_refresh.
   */
  constexpr impl::BooleanMetric uninstaller_profile_refresh(472);
}

} // namespace mozilla::glean

#endif // mozilla_GleanMigrationMetrics_h
