/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * This file contains the list of field names that are used in @autocomplete
 * attribute for <input>, <select> and <textarea> controls. It is designed
 * to be used as inline input through the magic of C preprocessing.
 *
 * The first argument to AUTOCOMPLETE_* macro is the identifier for the token
 * The second argument is the string value of the token
 */

#ifndef AUTOCOMPLETE_FIELD_NAME
#define AUTOCOMPLETE_FIELD_NAME(name_, value_)
#define DEFINED_AUTOCOMPLETE_FIELD_NAME
#endif

#ifndef AUTOCOMPLETE_NO_PERSIST_FIELD_NAME
#define AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(name_, value_)
#define DEFINED_AUTOCOMPLETE_NO_PERSIST_FIELD_NAME
#endif

#ifndef AUTOCOMPLETE_CONTACT_FIELD_NAME
#define AUTOCOMPLETE_CONTACT_FIELD_NAME(name_, value_)
#define DEFINED_AUTOCOMPLETE_CONTACT_FIELD_NAME
#endif

#ifndef AUTOCOMPLETE_FIELD_HINT
#define AUTOCOMPLETE_FIELD_HINT(name_, value_)
#define DEFINED_AUTOCOMPLETE_FIELD_HINT
#endif

#ifndef AUTOCOMPLETE_FIELD_CONTACT_HINT
#define AUTOCOMPLETE_FIELD_CONTACT_HINT(name_, value_)
#define DEFINED_AUTOCOMPLETE_FIELD_CONTACT_HINT
#endif

#ifndef AUTOCOMPLETE_CREDENTIAL_TYPE
#define AUTOCOMPLETE_CREDENTIAL_TYPE(name_, value_)
#define DEFINED_AUTOCOMPLETE_CREDENTIAL_TYPE
#endif

#ifndef AUTOCOMPLETE_CATEGORY
#define AUTOCOMPLETE_CATEGORY(name_, value_)
#define DEFINED_AUTOCOMPLETE_CATEGORY
#endif

#ifndef AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME
#define AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(name_, value_)
#define DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME
#endif

#ifndef AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT
#define AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT(name_, value_)
#define DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT
#endif

//-----------------------------------------------------
// Unsupported list

// Unsupported field names
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(HONORIFIX_PREFIX, "honorifix-prefix")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(HONORIFIX_SUFFIX, "honorifix-suffix")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(NICKNAME, "nickname")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(ORGANIZATION_TITLE, "organization-title")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(ADDRESS_LEVEL4, "address-level4")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(CC_GIVEN_NAME, "cc-given-name")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(CC_ADDITIONAL_NAME, "cc-additional-name")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(CC_FAMILY_NAME, "cc-family-name")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(CC_CSC, "cc-csc")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(CC_TYPE, "cc-type")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(TRANSACTION_CURRENCY,
                                    "transaction-currency")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(TRANSACTION_AMOUNT, "transaction-amount")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(ONE_TIME_CODE, "one-time-code")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(LANGUAGE, "language")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(BDAY, "bday")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(BDAY_DAY, "bday-day")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(BDAY_MONTH, "bday-month")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(BDAY_YEAR, "bday-year")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(SEX, "sex")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(URL, "url")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(PHOTO, "photo")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(TEL_EXTENSION, "tel-extension")
AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME(IMPP, "impp")

// Unsupported contact types
AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT(FAX, "fax")
AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT(PAGER, "pager")

//-----------------------------------------------------
// Valid list

AUTOCOMPLETE_FIELD_NAME(OFF, "off")
AUTOCOMPLETE_FIELD_NAME(ON, "on")

// Name types
AUTOCOMPLETE_FIELD_NAME(NAME, "name")
AUTOCOMPLETE_FIELD_NAME(HONORIFIX_PREFIX, "honorifix-prefix")
AUTOCOMPLETE_FIELD_NAME(GIVEN_NAME, "given-name")
AUTOCOMPLETE_FIELD_NAME(ADDITIONAL_NAME, "additional-name")
AUTOCOMPLETE_FIELD_NAME(FAMILY_NAME, "family-name")
AUTOCOMPLETE_FIELD_NAME(HONORIFIX_SUFFIX, "honorifix-suffix")
AUTOCOMPLETE_FIELD_NAME(NICKNAME, "nickname")
AUTOCOMPLETE_FIELD_NAME(ORGANIZATION_TITLE, "organization-title")

// Login types
AUTOCOMPLETE_FIELD_NAME(USERNAME, "username")
AUTOCOMPLETE_FIELD_NAME(NEW_PASSWORD, "new-password")
AUTOCOMPLETE_FIELD_NAME(CURRENT_PASSWORD, "current-password")
AUTOCOMPLETE_FIELD_NAME(ONE_TIME_CODE, "one-time-code")

// Address types
AUTOCOMPLETE_FIELD_NAME(ORGANIZATION, "organization")
AUTOCOMPLETE_FIELD_NAME(STREET_ADDRESS, "street-address")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LINE1, "address-line1")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LINE2, "address-line2")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LINE3, "address-line3")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LEVEL4, "address-level4")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LEVEL3, "address-level3")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LEVEL2, "address-level2")
AUTOCOMPLETE_FIELD_NAME(ADDRESS_LEVEL1, "address-level1")
AUTOCOMPLETE_FIELD_NAME(COUNTRY, "country")
AUTOCOMPLETE_FIELD_NAME(COUNTRY_NAME, "country-name")
AUTOCOMPLETE_FIELD_NAME(POSTAL_CODE, "postal-code")

// Credit Card types
AUTOCOMPLETE_FIELD_NAME(CC_NAME, "cc-name")
AUTOCOMPLETE_FIELD_NAME(CC_GIVEN_NAME, "cc-given-name")
AUTOCOMPLETE_FIELD_NAME(CC_ADDITIONAL_NAME, "cc-additional-name")
AUTOCOMPLETE_FIELD_NAME(CC_FAMILY_NAME, "cc-family-name")
AUTOCOMPLETE_FIELD_NAME(CC_NUMBER, "cc-number")
AUTOCOMPLETE_FIELD_NAME(CC_EXP, "cc-exp")
AUTOCOMPLETE_FIELD_NAME(CC_EXP_MONTH, "cc-exp-month")
AUTOCOMPLETE_FIELD_NAME(CC_EXP_YEAR, "cc-exp-year")
AUTOCOMPLETE_FIELD_NAME(CC_CSC, "cc-csc")
AUTOCOMPLETE_FIELD_NAME(CC_TYPE, "cc-type")

// Transaction types
AUTOCOMPLETE_FIELD_NAME(TRANSACTION_CURRENCY, "transaction-currency")
AUTOCOMPLETE_FIELD_NAME(TRANSACTION_AMOUNT, "transaction-amount")

// Additional field types
AUTOCOMPLETE_FIELD_NAME(LANGUAGE, "language")
AUTOCOMPLETE_FIELD_NAME(BDAY, "bday")
AUTOCOMPLETE_FIELD_NAME(BDAY_DAY, "bday-day")
AUTOCOMPLETE_FIELD_NAME(BDAY_MONTH, "bday-month")
AUTOCOMPLETE_FIELD_NAME(BDAY_YEAR, "bday-year")
AUTOCOMPLETE_FIELD_NAME(SEX, "sex")
AUTOCOMPLETE_FIELD_NAME(URL, "url")
AUTOCOMPLETE_FIELD_NAME(PHOTO, "photo")

// Field for which we don't want to automatically persist the value e.g. in
// session/form history.
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(OFF, "off")
// passwords:
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(CURRENT_PASSWORD, "current-password")
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(NEW_PASSWORD, "new-password")
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(ONE_TIME_CODE, "one-time-code")
// credit card numbers
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(CC_NUMBER, "cc-number")
AUTOCOMPLETE_NO_PERSIST_FIELD_NAME(CC_CSC, "cc-csc")

// Contact category types
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL, "tel")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_COUNTRY_CODE, "tel-country-code")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_NATIONAL, "tel-national")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_AREA_CODE, "tel-area-code")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_LOCAL, "tel-local")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_LOCAL_PREFIX, "tel-local-prefix")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_LOCAL_SUFFIX, "tel-local-suffix")
AUTOCOMPLETE_CONTACT_FIELD_NAME(TEL_EXTENSION, "tel-extension")
AUTOCOMPLETE_CONTACT_FIELD_NAME(EMAIL, "email")
AUTOCOMPLETE_CONTACT_FIELD_NAME(IMPP, "impp")

AUTOCOMPLETE_FIELD_HINT(SHIPPING, "shipping")
AUTOCOMPLETE_FIELD_HINT(BILLING, "billing")

AUTOCOMPLETE_FIELD_CONTACT_HINT(HOME, "home")
AUTOCOMPLETE_FIELD_CONTACT_HINT(WORK, "work")
AUTOCOMPLETE_FIELD_CONTACT_HINT(MOBILE, "mobile")
AUTOCOMPLETE_FIELD_CONTACT_HINT(FAX, "fax")
AUTOCOMPLETE_FIELD_CONTACT_HINT(PAGER, "pager")

// Credential types
AUTOCOMPLETE_CREDENTIAL_TYPE(WEBAUTHN, "webauthn")

AUTOCOMPLETE_CATEGORY(NORMAL, "normal")
AUTOCOMPLETE_CATEGORY(CONTACT, "contact")
//-----------------------------------------------------

#ifdef DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME
#undef AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME
#undef DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_NAME
#endif

#ifdef DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT
#undef AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT
#undef DEFINED_AUTOCOMPLETE_UNSUPPORTED_FIELD_CONTACT_HINT
#endif

#ifdef DEFINED_AUTOCOMPLETE_FIELD_NAME
#undef AUTOCOMPLETE_FIELD_NAME
#undef DEFINED_AUTOCOMPLETE_FIELD_NAME
#endif

#ifdef DEFINED_AUTOCOMPLETE_NO_PERSIST_FIELD_NAME
#undef AUTOCOMPLETE_NO_PERSIST_FIELD_NAME
#undef DEFINED_AUTOCOMPLETE_NO_PERSIST_FIELD_NAME
#endif

#ifdef DEFINED_AUTOCOMPLETE_CONTACT_FIELD_NAME
#undef AUTOCOMPLETE_CONTACT_FIELD_NAME
#undef DEFINED_AUTOCOMPLETE_CONTACT_FIELD_NAME
#endif

#ifdef DEFINED_AUTOCOMPLETE_FIELD_HINT
#undef AUTOCOMPLETE_FIELD_HINT
#undef DEFINED_AUTOCOMPLETE_FIELD_HINT
#endif

#ifdef DEFINED_AUTOCOMPLETE_FIELD_CONTACT_HINT
#undef AUTOCOMPLETE_FIELD_CONTACT_HINT
#undef DEFINED_AUTOCOMPLETE_FIELD_CONTACT_HINT
#endif

#ifdef DEFINED_AUTOCOMPLETE_CREDENTIAL_TYPE
#undef AUTOCOMPLETE_CREDENTIAL_TYPE
#undef DEFINED_AUTOCOMPLETE_CREDENTIAL_TYPE
#endif

#ifdef DEFINED_AUTOCOMPLETE_CATEGORY
#undef AUTOCOMPLETE_CATEGORY
#undef DEFINED_AUTOCOMPLETE_CATEGORY
#endif
