/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM DeviceOrientationEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_DEVICEORIENTATIONEVENT_H_
#define DOM_DEVICEORIENTATIONEVENT_H_

#include "mozilla/Attributes.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DeviceOrientationEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla::dom {

class DeviceOrientationEvent : public Event
{
public:
  NS_INLINE_DECL_REFCOUNTING_INHERITED(DeviceOrientationEvent, Event)

protected:
  virtual ~DeviceOrientationEvent();
  explicit DeviceOrientationEvent(mozilla::dom::EventTarget* aOwner);

  Nullable<double> mAlpha;
  Nullable<double> mBeta;
  Nullable<double> mGamma;
  bool mAbsolute;

public:
  DeviceOrientationEvent* AsDeviceOrientationEvent() override;

  JSObject* WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<DeviceOrientationEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict);

  static already_AddRefed<DeviceOrientationEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict);

  Nullable<double> GetAlpha() const;

  Nullable<double> GetBeta() const;

  Nullable<double> GetGamma() const;

  bool Absolute() const;

  void InitDeviceOrientationEvent(const nsAString& aType, bool aCanBubble, bool aCancelable, const Nullable<double>& aAlpha, const Nullable<double>& aBeta, const Nullable<double>& aGamma, bool aAbsolute);
};

} // namespace mozilla::dom

#endif // DOM_DEVICEORIENTATIONEVENT_H_
