/* THIS FILE IS AUTOGENERATED FROM Document.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_DOCUMENTBINDING_H_
#define DOM_DOCUMENTBINDING_H_

#include "ReferrerPolicyBinding.h"
#include "js/CallAndConstruct.h"
#include "jsapi.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsIContent.h"

class nsINode;

namespace mozilla {

class StyleSheet;

namespace dom {

struct BlockParsingOptionsAtoms;
class Document;
struct ElementCreationOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct WireframeAtoms;
struct WireframeTaggedRect;
struct WireframeTaggedRectAtoms;

} // namespace dom

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class VisibilityState : uint8_t {
  Hidden,
  Visible,
};

namespace binding_detail {
template <> struct EnumStrings<VisibilityState> {
  static const nsLiteralCString Values[2];
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, VisibilityState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class WireframeRectType : uint8_t {
  Image,
  Background,
  Text,
  Unknown,
};

namespace binding_detail {
template <> struct EnumStrings<WireframeRectType> {
  static const nsLiteralCString Values[4];
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, WireframeRectType aArgument, JS::MutableHandle<JS::Value> aValue);


struct BlockParsingOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mBlockScriptCreated;

  BlockParsingOptions();

  explicit inline BlockParsingOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  BlockParsingOptions(BlockParsingOptions&& aOther) = default;

  explicit inline BlockParsingOptions(const BlockParsingOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BlockParsingOptions&
  operator=(const BlockParsingOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BlockParsingOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBlockParsingOptions : public BlockParsingOptions
{
  inline FastBlockParsingOptions()
    : BlockParsingOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ElementCreationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIs;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPseudo;

  ElementCreationOptions();

  explicit inline ElementCreationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ElementCreationOptions(ElementCreationOptions&& aOther) = default;

  explicit inline ElementCreationOptions(const ElementCreationOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ElementCreationOptions&
  operator=(const ElementCreationOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ElementCreationOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastElementCreationOptions : public ElementCreationOptions
{
  inline FastElementCreationOptions()
    : ElementCreationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WireframeTaggedRect : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mColor;
  MOZ_INIT_OUTSIDE_CTOR double mHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<nsINode>> mNode;
  MOZ_INIT_OUTSIDE_CTOR Optional<WireframeRectType> mType;
  MOZ_INIT_OUTSIDE_CTOR double mWidth;
  MOZ_INIT_OUTSIDE_CTOR double mX;
  MOZ_INIT_OUTSIDE_CTOR double mY;

  WireframeTaggedRect();

  explicit inline WireframeTaggedRect(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WireframeTaggedRect(WireframeTaggedRect&& aOther) = default;

  explicit inline WireframeTaggedRect(const WireframeTaggedRect& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mNode, "mNode", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mNode);
  }

  WireframeTaggedRect&
  operator=(const WireframeTaggedRect& aOther);

private:
  static bool
  InitIds(JSContext* cx, WireframeTaggedRectAtoms* atomsCache);
};

namespace binding_detail {
struct FastWireframeTaggedRect : public WireframeTaggedRect
{
  inline FastWireframeTaggedRect()
    : WireframeTaggedRect(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ElementCreationOptionsOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };
public:
  enum class Type
  {
    eElementCreationOptions = TypeOrUninit::eElementCreationOptions,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastElementCreationOptions > mElementCreationOptions;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  ElementCreationOptionsOrString(const ElementCreationOptionsOrString&) = delete;
  ElementCreationOptionsOrString& operator=(const ElementCreationOptionsOrString&) = delete;
public:
  explicit inline ElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ElementCreationOptionsOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FastElementCreationOptions&
  RawSetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastElementCreationOptions&
  SetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    Uninit();
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline binding_detail::FastElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline const ElementCreationOptions&
  GetAsElementCreationOptions() const
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElementCreationOptions: {
        DestroyElementCreationOptions();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

private:
  bool
  TrySetToElementCreationOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElementCreationOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    mValue.mElementCreationOptions.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementCreationOptionsOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };
public:
  enum class Type
  {
    eElementCreationOptions = TypeOrUninit::eElementCreationOptions,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<ElementCreationOptions > mElementCreationOptions;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  OwningElementCreationOptionsOrString(OwningElementCreationOptionsOrString&& aOther);

  explicit inline OwningElementCreationOptionsOrString(const OwningElementCreationOptionsOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementCreationOptionsOrString()
  {
    Uninit();
  }

  [[nodiscard]] ElementCreationOptions&
  RawSetAsElementCreationOptions();

  [[nodiscard]] ElementCreationOptions&
  SetAsElementCreationOptions();

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline ElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline ElementCreationOptions const &
  GetAsElementCreationOptions() const
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningElementCreationOptionsOrString&
  operator=(OwningElementCreationOptionsOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningElementCreationOptionsOrString&
  operator=(const OwningElementCreationOptionsOrString& aOther);

private:
  bool
  TrySetToElementCreationOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElementCreationOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElementCreationOptions();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


struct Wireframe : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCanvasBackground;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<WireframeTaggedRect>> mRects;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mVersion;

  Wireframe();

  explicit inline Wireframe(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Wireframe(Wireframe&& aOther) = default;

  explicit inline Wireframe(const Wireframe& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mRects, "mRects", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mRects);
  }

  Wireframe&
  operator=(const Wireframe& aOther);

private:
  static bool
  InitIds(JSContext* cx, WireframeAtoms* atomsCache);
};

namespace binding_detail {
struct FastWireframe : public Wireframe
{
  inline FastWireframe()
    : Wireframe(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Document_Binding {

  typedef mozilla::dom::Document NativeType;

  static const uint16_t KEYPRESS_EVENT_MODEL_DEFAULT = 0;
  static const uint16_t KEYPRESS_EVENT_MODEL_SPLIT = 1;
  static const uint16_t KEYPRESS_EVENT_MODEL_CONFLATED = 2;
  namespace AdoptedStyleSheetsHelpers {
  already_AddRefed<StyleSheet>
  ElementAt(mozilla::dom::Document* self, uint32_t aIndex, ErrorResult& aRv);

  void
  ReplaceElementAt(mozilla::dom::Document* self, uint32_t aIndex, StyleSheet& aValue, ErrorResult& aRv);

  void
  AppendElement(mozilla::dom::Document* self, StyleSheet& aValue, ErrorResult& aRv);

  void
  RemoveLastElement(mozilla::dom::Document* self, ErrorResult& aRv);

  uint32_t
  Length(mozilla::dom::Document* self, ErrorResult& aRv);
  } // namespace AdoptedStyleSheetsHelpers

  bool
  CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Document* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedAdoptedStyleSheetsValue(mozilla::dom::Document* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Document,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Document,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Document,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Document_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::VisibilityState>
{
  static constexpr dom::VisibilityState value = dom::VisibilityState::Visible;

  static_assert(static_cast<uint8_t>(dom::VisibilityState::Hidden) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(mozilla::ArrayLength(dom::binding_detail::EnumStrings<dom::VisibilityState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::WireframeRectType>
{
  static constexpr dom::WireframeRectType value = dom::WireframeRectType::Unknown;

  static_assert(static_cast<uint8_t>(dom::WireframeRectType::Image) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(mozilla::ArrayLength(dom::binding_detail::EnumStrings<dom::WireframeRectType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_DOCUMENTBINDING_H_
