/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Components_h
#define mozilla_Components_h

#include "nsCOMPtr.h"

struct nsID;

#define NS_IMPL_COMPONENT_FACTORY(iface) \
  template <>                            \
  already_AddRefed<nsISupports> mozCreateComponent<iface>()

template <typename T>
already_AddRefed<nsISupports> mozCreateComponent();

namespace mozilla {
namespace xpcom {

enum class ModuleID : uint16_t {
  SiteSecurity,
  Anonymous052,
  ProtocolProxy,
  Anonymous297,
  Anonymous128,
  Anonymous314,
  WifiMonitor,
  Anonymous273,
  Anonymous161,
  Anonymous247,
  Anonymous415,
  Anonymous137,
  Anonymous016,
  Anonymous219,
  Anonymous199,
  Anonymous216,
  Anonymous189,
  Anonymous329,
  Anonymous315,
  Anonymous188,
  Anonymous069,
  Anonymous403,
  UrlClassifierUtils,
  Anonymous070,
  Anonymous004,
  Anonymous019,
  Anonymous138,
  Anonymous207,
  Anonymous000,
  Anonymous080,
  Anonymous111,
  Anonymous382,
  UrlClassifierPrefixSet,
  Anonymous316,
  ThirdPartyUtil,
  TextToSubURI,
  Anonymous101,
  Anonymous276,
  Anonymous326,
  Anonymous200,
  Anonymous346,
  Anonymous419,
  StreamTransport,
  IDN,
  Anonymous300,
  Anonymous115,
  Anonymous191,
  Anonymous229,
  Anonymous008,
  Anonymous243,
  StreamConverter,
  Anonymous026,
  Anonymous281,
  ContentSecurityManager,
  Anonymous106,
  Anonymous013,
  Anonymous294,
  Anonymous135,
  Anonymous063,
  Anonymous333,
  Anonymous353,
  Anonymous345,
  Anonymous215,
  Anonymous066,
  URIFixup,
  Anonymous042,
  IdentityCredentialStorageService,
  nsIContentAnalysis,
  Directory,
  Anonymous110,
  Anonymous259,
  NSSErrors,
  ServiceWorkerManager,
  Anonymous092,
  Anonymous179,
  Anonymous380,
  Anonymous232,
  Anonymous195,
  Anonymous343,
  Anonymous317,
  MimeHeaderParam,
  Anonymous325,
  Anonymous362,
  Anonymous257,
  Anonymous172,
  ExtensionPolicy,
  Anonymous287,
  Anonymous384,
  Anonymous091,
  Anonymous418,
  Anonymous060,
  Anonymous112,
  Anonymous214,
  Anonymous422,
  Anonymous040,
  Anonymous227,
  Anonymous256,
  Anonymous203,
  Anonymous391,
  Anonymous268,
  Anonymous261,
  Anonymous318,
  Anonymous048,
  Anonymous245,
  Anonymous124,
  Anonymous024,
  Anonymous369,
  Anonymous149,
  Anonymous083,
  Anonymous402,
  Anonymous408,
  Anonymous043,
  Anonymous064,
  Anonymous006,
  Anonymous312,
  Anonymous313,
  AppStartup,
  NSSCertificateDB,
  Anonymous103,
  Anonymous230,
  Anonymous285,
  Anonymous239,
  Anonymous271,
  Anonymous096,
  CategoryManager,
  PermissionManager,
  Anonymous310,
  ScriptSecurityManager,
  ApplicationReputation,
  Anonymous177,
  Anonymous275,
  Anonymous224,
  Anonymous084,
  Anonymous270,
  Observer,
  Anonymous209,
  Anonymous113,
  IdentityCredentialPromptService,
  Anonymous020,
  Anonymous157,
  Anonymous184,
  Anonymous073,
  Anonymous076,
  Anonymous376,
  Dashboard,
  Anonymous142,
  GfxInfo,
  Anonymous298,
  Anonymous426,
  AddonContentPolicy,
  Locale,
  Anonymous401,
  Anonymous001,
  Anonymous390,
  Anonymous288,
  Anonymous213,
  DownloadPlatform,
  Anonymous406,
  Anonymous226,
  Anonymous246,
  DocLoader,
  Anonymous284,
  Anonymous114,
  Anonymous131,
  Anonymous328,
  Anonymous205,
  Anonymous416,
  EffectiveTLD,
  Anonymous065,
  Anonymous178,
  NSSComponent,
  Anonymous306,
  Anonymous231,
  Anonymous241,
  Anonymous320,
  Anonymous133,
  Anonymous003,
  Anonymous208,
  Anonymous330,
  Anonymous368,
  Anonymous183,
  Anonymous366,
  Anonymous190,
  Prefetch,
  Anonymous168,
  Anonymous260,
  Anonymous094,
  Anonymous286,
  PageThumbsStorage,
  URLQueryStringStripper,
  Anonymous009,
  Anonymous186,
  Anonymous193,
  Anonymous302,
  Anonymous221,
  ExternalProtocolHandler,
  Anonymous371,
  Anonymous057,
  Preferences,
  Anonymous381,
  HttpHandler,
  Anonymous087,
  Anonymous356,
  Anonymous370,
  Anonymous045,
  Anonymous018,
  Anonymous400,
  Anonymous375,
  Anonymous340,
  Anonymous117,
  Anonymous098,
  Anonymous181,
  Anonymous194,
  Anonymous116,
  Anonymous269,
  Anonymous395,
  Anonymous182,
  Anonymous429,
  Anonymous095,
  CacheStorage,
  Anonymous308,
  Anonymous166,
  Anonymous171,
  Anonymous202,
  Anonymous165,
  Anonymous307,
  Anonymous068,
  Anonymous030,
  UUIDGenerator,
  Anonymous079,
  Anonymous150,
  Anonymous397,
  Anonymous034,
  Anonymous240,
  Anonymous204,
  Anonymous377,
  Anonymous072,
  Anonymous430,
  Anonymous129,
  SocketTransport,
  Anonymous154,
  Anonymous222,
  Anonymous059,
  Anonymous197,
  Anonymous090,
  History,
  Anonymous405,
  Anonymous192,
  Anonymous409,
  HttpActivityDistributor,
  FileProtocolHandler,
  Anonymous093,
  Anonymous055,
  Anonymous036,
  Anonymous414,
  Anonymous244,
  Anonymous389,
  Anonymous223,
  Anonymous029,
  Anonymous354,
  Anonymous155,
  Anonymous263,
  Anonymous289,
  Anonymous266,
  IO,
  Anonymous277,
  Anonymous412,
  Anonymous105,
  Anonymous067,
  Predictor,
  Anonymous364,
  Anonymous265,
  Anonymous242,
  Anonymous123,
  Anonymous251,
  Anonymous021,
  Anonymous022,
  Anonymous151,
  Anonymous027,
  Anonymous097,
  Anonymous331,
  Anonymous417,
  Anonymous238,
  Anonymous355,
  Anonymous387,
  Anonymous305,
  Anonymous023,
  Anonymous102,
  Anonymous041,
  Anonymous180,
  Anonymous337,
  Anonymous421,
  Anonymous249,
  Anonymous132,
  Anonymous196,
  Anonymous424,
  Anonymous134,
  Anonymous347,
  Anonymous290,
  Anonymous425,
  TypeAheadFind,
  Anonymous174,
  Anonymous038,
  Anonymous404,
  Anonymous283,
  CredentialChooserService,
  Anonymous367,
  Anonymous393,
  Anonymous011,
  Anonymous228,
  Anonymous139,
  Anonymous163,
  BounceTrackingProtection,
  Anonymous398,
  Anonymous344,
  Anonymous025,
  Anonymous292,
  Anonymous359,
  Anonymous431,
  Anonymous304,
  Anonymous324,
  Anonymous378,
  Anonymous031,
  Anonymous348,
  Anonymous050,
  Anonymous295,
  StringBundle,
  Anonymous007,
  Anonymous032,
  Anonymous169,
  Anonymous253,
  Anonymous056,
  Anonymous254,
  Anonymous049,
  URILoader,
  Anonymous399,
  Anonymous258,
  Anonymous360,
  Anonymous044,
  Anonymous054,
  Anonymous187,
  Anonymous109,
  Anonymous061,
  Anonymous125,
  Anonymous099,
  Anonymous153,
  Anonymous170,
  Anonymous319,
  Anonymous411,
  Anonymous267,
  Anonymous413,
  Anonymous198,
  Anonymous350,
  Anonymous336,
  AuthPromptAdapter,
  Alerts,
  Anonymous012,
  Anonymous053,
  Anonymous051,
  Anonymous089,
  Anonymous176,
  Anonymous047,
  Anonymous035,
  Anonymous252,
  Anonymous388,
  Anonymous262,
  Anonymous005,
  Anonymous143,
  Anonymous140,
  Anonymous127,
  Anonymous351,
  Anonymous374,
  Anonymous341,
  Anonymous146,
  Anonymous085,
  ChromeRegistry,
  FindService,
  Anonymous002,
  Anonymous349,
  Anonymous148,
  Anonymous365,
  Anonymous383,
  Anonymous185,
  Anonymous075,
  Anonymous206,
  Anonymous282,
  Anonymous332,
  Anonymous118,
  Anonymous309,
  Anonymous071,
  Anonymous379,
  Anonymous201,
  Anonymous175,
  Anonymous303,
  Anonymous120,
  Anonymous010,
  Anonymous126,
  Anonymous338,
  Anonymous296,
  Anonymous141,
  Anonymous392,
  Anonymous218,
  Anonymous147,
  Anonymous279,
  XULRuntime,
  UrlClassifierDB,
  AsyncShutdown,
  PlacesPreviewsHelper,
  Anonymous122,
  WindowWatcher,
  Anonymous210,
  Anonymous291,
  Anonymous372,
  Anonymous015,
  CaptivePortal,
  Anonymous236,
  Anonymous311,
  Anonymous108,
  Anonymous339,
  Anonymous107,
  Anonymous428,
  RFPService,
  Anonymous264,
  DNS,
  Anonymous037,
  Anonymous394,
  Anonymous158,
  Anonymous386,
  Anonymous373,
  PrivateAttribution,
  Console,
  Anonymous212,
  Anonymous335,
  Anonymous058,
  CookieBannerService,
  Anonymous423,
  Anonymous152,
  Anonymous081,
  Anonymous156,
  Anonymous039,
  Anonymous136,
  Anonymous363,
  Anonymous217,
  Anonymous396,
  Anonymous272,
  Anonymous278,
  Anonymous274,
  Anonymous342,
  Anonymous144,
  Anonymous173,
  Anonymous322,
  Anonymous014,
  Anonymous211,
  Anonymous233,
  Anonymous237,
  Anonymous352,
  Anonymous162,
  Anonymous167,
  Anonymous130,
  Anonymous234,
  Anonymous420,
  Anonymous255,
  Anonymous410,
  Anonymous121,
  Anonymous104,
  Anonymous248,
  Anonymous358,
  Anonymous334,
  Anonymous033,
  Anonymous361,
  Anonymous385,
  Anonymous301,
  Anonymous160,
  Anonymous250,
  Anonymous078,
  Anonymous119,
  Anonymous427,
  Anonymous321,
  Anonymous220,
  Anonymous100,
  Anonymous327,
  Anonymous077,
  Anonymous323,
  Anonymous407,
  Anonymous357,
  Anonymous293,
  Anonymous062,
  Anonymous235,
  Anonymous046,
  Anonymous280,
  Anonymous299,
  Anonymous159,
  Anonymous082,
  Anonymous225,
  AlertNotification,
  Anonymous164,
  Anonymous145,
  Anonymous074,
  Anonymous017,
  Anonymous088,
  Anonymous028,
  UrlClassifierStreamUpdater,
  Anonymous086,
  SystemInfo,
  RandomGenerator,

};

// May be added as a friend function to allow constructing services via
// private constructors and init methods.
nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult);

class MOZ_STACK_CLASS StaticModuleHelper : public nsCOMPtr_helper {
 public:
  StaticModuleHelper(ModuleID aId, nsresult* aErrorPtr)
      : mId(aId), mErrorPtr(aErrorPtr) {}

 protected:
  nsresult SetResult(nsresult aRv) const {
    if (mErrorPtr) {
      *mErrorPtr = aRv;
    }
    return aRv;
  }

  ModuleID mId;
  nsresult* mErrorPtr;
};

class MOZ_STACK_CLASS GetServiceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class MOZ_STACK_CLASS CreateInstanceHelper final : public StaticModuleHelper {
 public:
  using StaticModuleHelper::StaticModuleHelper;

  nsresult NS_FASTCALL operator()(const nsIID& aIID,
                                  void** aResult) const override;
};

class Components final {
 public:
  static const nsID& GetCID(ModuleID aID);
};

}  // namespace xpcom

namespace components {

namespace AddonContentPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AddonContentPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AddonContentPolicy, aRv};
}
}  // namespace AddonContentPolicy

namespace AlertNotification {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AlertNotification);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AlertNotification, aRv};
}
}  // namespace AlertNotification

namespace Alerts {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Alerts);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Alerts, aRv};
}
}  // namespace Alerts

namespace AppStartup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AppStartup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AppStartup, aRv};
}
}  // namespace AppStartup

namespace ApplicationReputation {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ApplicationReputation);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ApplicationReputation, aRv};
}
}  // namespace ApplicationReputation

namespace AsyncShutdown {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AsyncShutdown);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AsyncShutdown, aRv};
}
}  // namespace AsyncShutdown

namespace AuthPromptAdapter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::AuthPromptAdapter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::AuthPromptAdapter, aRv};
}
}  // namespace AuthPromptAdapter

namespace BounceTrackingProtection {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::BounceTrackingProtection);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::BounceTrackingProtection, aRv};
}
}  // namespace BounceTrackingProtection

namespace CacheStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CacheStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CacheStorage, aRv};
}
}  // namespace CacheStorage

namespace CaptivePortal {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CaptivePortal);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CaptivePortal, aRv};
}
}  // namespace CaptivePortal

namespace CategoryManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CategoryManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CategoryManager, aRv};
}
}  // namespace CategoryManager

namespace ChromeRegistry {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ChromeRegistry);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ChromeRegistry, aRv};
}
}  // namespace ChromeRegistry

namespace Console {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Console);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Console, aRv};
}
}  // namespace Console

namespace ContentSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ContentSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ContentSecurityManager, aRv};
}
}  // namespace ContentSecurityManager

namespace CookieBannerService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CookieBannerService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CookieBannerService, aRv};
}
}  // namespace CookieBannerService

namespace CredentialChooserService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::CredentialChooserService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::CredentialChooserService, aRv};
}
}  // namespace CredentialChooserService

namespace DNS {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DNS);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DNS, aRv};
}
}  // namespace DNS

namespace Dashboard {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Dashboard);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Dashboard, aRv};
}
}  // namespace Dashboard

namespace Directory {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Directory);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Directory, aRv};
}
}  // namespace Directory

namespace DocLoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DocLoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DocLoader, aRv};
}
}  // namespace DocLoader

namespace DownloadPlatform {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::DownloadPlatform);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::DownloadPlatform, aRv};
}
}  // namespace DownloadPlatform

namespace EffectiveTLD {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::EffectiveTLD);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::EffectiveTLD, aRv};
}
}  // namespace EffectiveTLD

namespace ExtensionPolicy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExtensionPolicy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExtensionPolicy, aRv};
}
}  // namespace ExtensionPolicy

namespace ExternalProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ExternalProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ExternalProtocolHandler, aRv};
}
}  // namespace ExternalProtocolHandler

namespace FileProtocolHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FileProtocolHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FileProtocolHandler, aRv};
}
}  // namespace FileProtocolHandler

namespace FindService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::FindService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::FindService, aRv};
}
}  // namespace FindService

namespace GfxInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::GfxInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::GfxInfo, aRv};
}
}  // namespace GfxInfo

namespace History {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::History);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::History, aRv};
}
}  // namespace History

namespace HttpActivityDistributor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpActivityDistributor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpActivityDistributor, aRv};
}
}  // namespace HttpActivityDistributor

namespace HttpHandler {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::HttpHandler);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::HttpHandler, aRv};
}
}  // namespace HttpHandler

namespace IDN {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IDN);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IDN, aRv};
}
}  // namespace IDN

namespace IO {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IO);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IO, aRv};
}
}  // namespace IO

namespace IdentityCredentialPromptService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialPromptService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialPromptService, aRv};
}
}  // namespace IdentityCredentialPromptService

namespace IdentityCredentialStorageService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::IdentityCredentialStorageService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::IdentityCredentialStorageService, aRv};
}
}  // namespace IdentityCredentialStorageService

namespace Locale {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Locale);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Locale, aRv};
}
}  // namespace Locale

namespace MimeHeaderParam {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::MimeHeaderParam);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::MimeHeaderParam, aRv};
}
}  // namespace MimeHeaderParam

namespace NSSCertificateDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSCertificateDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSCertificateDB, aRv};
}
}  // namespace NSSCertificateDB

namespace NSSComponent {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSComponent);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSComponent, aRv};
}
}  // namespace NSSComponent

namespace NSSErrors {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::NSSErrors);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::NSSErrors, aRv};
}
}  // namespace NSSErrors

namespace Observer {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Observer);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Observer, aRv};
}
}  // namespace Observer

namespace PageThumbsStorage {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PageThumbsStorage);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PageThumbsStorage, aRv};
}
}  // namespace PageThumbsStorage

namespace PermissionManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PermissionManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PermissionManager, aRv};
}
}  // namespace PermissionManager

namespace PlacesPreviewsHelper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PlacesPreviewsHelper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PlacesPreviewsHelper, aRv};
}
}  // namespace PlacesPreviewsHelper

namespace Predictor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Predictor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Predictor, aRv};
}
}  // namespace Predictor

namespace Preferences {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Preferences);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Preferences, aRv};
}
}  // namespace Preferences

namespace Prefetch {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::Prefetch);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::Prefetch, aRv};
}
}  // namespace Prefetch

namespace PrivateAttribution {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::PrivateAttribution);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::PrivateAttribution, aRv};
}
}  // namespace PrivateAttribution

namespace ProtocolProxy {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ProtocolProxy);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ProtocolProxy, aRv};
}
}  // namespace ProtocolProxy

namespace RFPService {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RFPService);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RFPService, aRv};
}
}  // namespace RFPService

namespace RandomGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::RandomGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::RandomGenerator, aRv};
}
}  // namespace RandomGenerator

namespace ScriptSecurityManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ScriptSecurityManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ScriptSecurityManager, aRv};
}
}  // namespace ScriptSecurityManager

namespace ServiceWorkerManager {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ServiceWorkerManager);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ServiceWorkerManager, aRv};
}
}  // namespace ServiceWorkerManager

namespace SiteSecurity {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SiteSecurity);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SiteSecurity, aRv};
}
}  // namespace SiteSecurity

namespace SocketTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SocketTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SocketTransport, aRv};
}
}  // namespace SocketTransport

namespace StreamConverter {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamConverter);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamConverter, aRv};
}
}  // namespace StreamConverter

namespace StreamTransport {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StreamTransport);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StreamTransport, aRv};
}
}  // namespace StreamTransport

namespace StringBundle {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::StringBundle);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::StringBundle, aRv};
}
}  // namespace StringBundle

namespace SystemInfo {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::SystemInfo);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::SystemInfo, aRv};
}
}  // namespace SystemInfo

namespace TextToSubURI {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TextToSubURI);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TextToSubURI, aRv};
}
}  // namespace TextToSubURI

namespace ThirdPartyUtil {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::ThirdPartyUtil);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::ThirdPartyUtil, aRv};
}
}  // namespace ThirdPartyUtil

namespace TypeAheadFind {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::TypeAheadFind);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::TypeAheadFind, aRv};
}
}  // namespace TypeAheadFind

namespace URIFixup {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URIFixup);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URIFixup, aRv};
}
}  // namespace URIFixup

namespace URILoader {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URILoader);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URILoader, aRv};
}
}  // namespace URILoader

namespace URLQueryStringStripper {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::URLQueryStringStripper);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::URLQueryStringStripper, aRv};
}
}  // namespace URLQueryStringStripper

namespace UUIDGenerator {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UUIDGenerator);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UUIDGenerator, aRv};
}
}  // namespace UUIDGenerator

namespace UrlClassifierDB {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierDB);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierDB, aRv};
}
}  // namespace UrlClassifierDB

namespace UrlClassifierPrefixSet {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierPrefixSet, aRv};
}
}  // namespace UrlClassifierPrefixSet

namespace UrlClassifierStreamUpdater {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierStreamUpdater, aRv};
}
}  // namespace UrlClassifierStreamUpdater

namespace UrlClassifierUtils {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::UrlClassifierUtils);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::UrlClassifierUtils, aRv};
}
}  // namespace UrlClassifierUtils

namespace WifiMonitor {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WifiMonitor);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WifiMonitor, aRv};
}
}  // namespace WifiMonitor

namespace WindowWatcher {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::WindowWatcher);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::WindowWatcher, aRv};
}
}  // namespace WindowWatcher

namespace XULRuntime {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::XULRuntime);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::XULRuntime, aRv};
}
}  // namespace XULRuntime

namespace nsIContentAnalysis {
static inline const nsID& CID() {
  return ::mozilla::xpcom::Components::GetCID(::mozilla::xpcom::ModuleID::nsIContentAnalysis);
}

static inline ::mozilla::xpcom::GetServiceHelper Service(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}

static inline ::mozilla::xpcom::CreateInstanceHelper Create(nsresult* aRv = nullptr) {
  return {::mozilla::xpcom::ModuleID::nsIContentAnalysis, aRv};
}
}  // namespace nsIContentAnalysis

}  // namespace components

}  // namespace mozilla

#endif
